/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.core.openshift;

import cz.xtf.core.openshift.OpenShift;
import cz.xtf.core.openshift.PodShellOutput;
import cz.xtf.core.waiting.SimpleWaiter;
import cz.xtf.core.waiting.WaiterException;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.ExecListener;
import io.fabric8.kubernetes.client.dsl.Execable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.TtyExecErrorChannelable;
import io.fabric8.kubernetes.client.dsl.TtyExecErrorable;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PodShell {
    private static final Logger log = LoggerFactory.getLogger(PodShell.class);
    private final OpenShift openShift;
    private final String podName;
    private final String containerName;
    private final ByteArrayOutputStream baosOutput;
    private final ByteArrayOutputStream baosError;

    public PodShell(OpenShift openShift, String dcName) {
        this(openShift, openShift.getAnyPod(dcName));
    }

    public PodShell(OpenShift openShift, Pod pod) {
        this(openShift, pod, null);
    }

    public PodShell(OpenShift openShift, Pod pod, String containerName) {
        this.openShift = openShift;
        this.podName = pod.getMetadata().getName();
        this.containerName = containerName;
        this.baosOutput = new ByteArrayOutputStream();
        this.baosError = new ByteArrayOutputStream();
    }

    public PodShellOutput executeWithBash(String command) {
        return this.execute("bash", "-c", command);
    }

    public PodShellOutput execute(String ... commands) {
        this.baosOutput.reset();
        this.baosError.reset();
        StateExecListener execListener = new StateExecListener();
        if (this.containerName == null) {
            ((Execable)((TtyExecErrorChannelable)((TtyExecErrorable)((PodResource)this.openShift.pods().withName(this.podName)).writingOutput((Object)this.baosOutput)).writingError((Object)this.baosError)).usingListener((Object)execListener)).exec((Object[])commands);
        } else {
            ((Execable)((TtyExecErrorChannelable)((TtyExecErrorable)((ContainerResource)((PodResource)this.openShift.pods().withName(this.podName)).inContainer((Object)this.containerName)).writingOutput((Object)this.baosOutput)).writingError((Object)this.baosError)).usingListener((Object)execListener)).exec((Object[])commands);
        }
        new SimpleWaiter(execListener::hasExecutionFinished).timeout(TimeUnit.MINUTES, 1L).reason("Waiting for " + Arrays.toString(commands) + " execution in '" + this.podName + "' pod.").waitFor();
        try {
            new SimpleWaiter(() -> this.baosOutput.size() > 0 || this.baosError.size() > 0).timeout(TimeUnit.SECONDS, 10L).waitFor();
        }
        catch (WaiterException e) {
            log.warn("Output from PodShell's execution didn't appear in 10 seconds after channel close.");
        }
        return new PodShellOutput(this.baosOutput.toString().trim(), this.baosError.toString().trim());
    }

    public class StateExecListener
    implements ExecListener {
        private final AtomicBoolean executionDone = new AtomicBoolean(false);

        public void onOpen(Response response) {
        }

        public void onFailure(Throwable throwable, Response response) {
        }

        public void onClose(int i, String s) {
            this.executionDone.set(true);
        }

        public boolean hasExecutionFinished() {
            return this.executionDone.get();
        }
    }
}

