/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.core.service.logs.streaming;

import cz.xtf.core.service.logs.streaming.ServiceLogsSettings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SystemPropertyBasedServiceLogsConfigurations {
    private static final String CONFIGURATION_PROPERTY_ITEMS_SEPARATOR = ",";
    private static final String CONFIGURATION_PROPERTY_ATTRIBUTE_SEPARATOR = ";";
    private static final String CONFIGURATION_PROPERTY_NAME_VALUE_SEPARATOR = "=";
    private static final String ALLOWED_ATTRIBUTE_NAME_REGEX = String.format("%s|%s|%s", "target", "filter", "output");
    private static final String ALLOWED_ATTRIBUTE_VALUE_REGEX = "[\\\\|\\w|^|$|.|+|?|*|\\[|\\]|(|)|{|}|&|\\-|>|<|/|:]";
    private static final String ALLOWED_ATTRIBUTE_REGEX = "(?:" + ALLOWED_ATTRIBUTE_NAME_REGEX + ")" + "=" + "[\\\\|\\w|^|$|.|+|?|*|\\[|\\]|(|)|{|}|&|\\-|>|<|/|:]" + "+";
    private static final String ALLOWED_ITEM_REGEX = "(" + ALLOWED_ATTRIBUTE_REGEX + "(?:" + ";" + ALLOWED_ATTRIBUTE_REGEX + ")*)";
    private final String serviceLogsStreamingConfigProperty;
    private final Map<String, ServiceLogsSettings> configurations;

    public SystemPropertyBasedServiceLogsConfigurations(String serviceLogsStreamingConfigProperty) {
        if (serviceLogsStreamingConfigProperty == null || serviceLogsStreamingConfigProperty.isEmpty()) {
            throw new IllegalArgumentException("A valid configuration must be provided by setting \"xtf.log.streaming.config\" value, in order to initialize a \"SystemPropertyBasedServiceLogsConfigurations\" instance");
        }
        this.serviceLogsStreamingConfigProperty = serviceLogsStreamingConfigProperty;
        this.configurations = this.loadConfigurations();
    }

    private Map<String, ServiceLogsSettings> loadConfigurations() {
        return Stream.of(this.serviceLogsStreamingConfigProperty.split(CONFIGURATION_PROPERTY_ITEMS_SEPARATOR)).map(configurationItem -> SystemPropertyBasedServiceLogsConfigurations.getSettingsFromItemConfiguration(configurationItem)).collect(Collectors.toMap(serviceLogsSettings -> serviceLogsSettings.getTarget(), serviceLogsSettings -> serviceLogsSettings));
    }

    private static ServiceLogsSettings getSettingsFromItemConfiguration(String configurationItem) {
        if (!configurationItem.matches(ALLOWED_ITEM_REGEX)) {
            throw new IllegalArgumentException(String.format("The value of the \"xtf.log.streaming.config\" property items must match the following format: %s. Was: %s" + ALLOWED_ITEM_REGEX, configurationItem));
        }
        String[] configurationAttributes = configurationItem.split(CONFIGURATION_PROPERTY_ATTRIBUTE_SEPARATOR);
        ServiceLogsSettings.Builder builder = new ServiceLogsSettings.Builder();
        Arrays.stream(configurationAttributes).map(a -> a.split(CONFIGURATION_PROPERTY_NAME_VALUE_SEPARATOR)).forEach(nameValuePair -> {
            String attributeName = nameValuePair[0];
            String attributeValue = nameValuePair[1];
            SystemPropertyBasedServiceLogsConfigurations.toBuilder(builder, attributeName, attributeValue);
        });
        return builder.build();
    }

    private static ServiceLogsSettings.Builder toBuilder(ServiceLogsSettings.Builder theBuilder, String attributeName, String attributeValue) {
        switch (attributeName) {
            case "target": {
                theBuilder.withTarget(attributeValue);
                break;
            }
            case "filter": {
                theBuilder.withFilter(attributeValue);
                break;
            }
            case "output": {
                theBuilder.withOutputPath(attributeValue);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unconventional configuration attribute name: %s. Allowed configuration attributes names: (%s)", attributeName, ALLOWED_ATTRIBUTE_NAME_REGEX));
            }
        }
        return theBuilder;
    }

    Collection<ServiceLogsSettings> list() {
        return this.configurations.values();
    }

    public ServiceLogsSettings forClass(Class<?> testClazz) {
        Optional<Map.Entry> selectedConfigurationSearch = this.configurations.entrySet().stream().filter(c -> testClazz.getName().equals(c.getKey())).findFirst();
        if (!selectedConfigurationSearch.isPresent()) {
            selectedConfigurationSearch = this.configurations.entrySet().stream().filter(c -> testClazz.getName().matches((String)c.getKey())).findFirst();
        }
        return selectedConfigurationSearch.isPresent() ? (ServiceLogsSettings)selectedConfigurationSearch.get().getValue() : null;
    }
}

