/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.core.service.logs.streaming.k8s;

import cz.xtf.core.service.logs.streaming.ServiceLogs;
import cz.xtf.core.service.logs.streaming.k8s.PodLogsWatcher;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PodLogs
implements ServiceLogs {
    private static final Logger log = LoggerFactory.getLogger(PodLogs.class);
    private KubernetesClient client;
    private List<String> namespaces;
    private PrintStream printStream;
    private Pattern filter;
    private List<Watch> watches;

    private PodLogs(KubernetesClient client, List<String> namespaces, PrintStream printStream, Pattern filter) {
        this.client = client;
        this.namespaces = namespaces;
        this.printStream = printStream == null ? System.out : printStream;
        this.filter = filter;
        this.watches = new ArrayList<Watch>();
    }

    @Override
    public void start() {
        if (this.namespaces != null && !this.namespaces.isEmpty()) {
            for (String namespace : this.namespaces) {
                log.info("=============================================================================================================================");
                log.info("Service Logs Streaming (SLS) was started in order to stream logs belonging to all pods in the {} namespace", (Object)namespace);
                log.info("=============================================================================================================================");
                Watch watch = ((NonNamespaceOperation)this.client.pods().inNamespace(namespace)).watch((Watcher)new PodLogsWatcher.Builder().withClient(this.client).inNamespace(namespace).outputTo(this.printStream).filter(this.filter).build());
                this.watches.add(watch);
            }
        }
    }

    @Override
    public void stop() {
        for (Watch watch : this.watches) {
            watch.close();
        }
    }

    public static class Builder {
        private KubernetesClient client;
        private List<String> namespaces;
        private PrintStream printStream;
        private Pattern filter;

        public Builder withClient(KubernetesClient client) {
            this.client = client;
            return this;
        }

        public Builder inNamespaces(List<String> namespaces) {
            this.namespaces = namespaces;
            return this;
        }

        public Builder outputTo(PrintStream printStream) {
            this.printStream = printStream;
            return this;
        }

        public Builder filter(String filter) {
            if (filter != null) {
                this.filter = Pattern.compile(filter);
            }
            return this;
        }

        public PodLogs build() {
            if (this.client == null) {
                throw new IllegalStateException("The Kubernetes client must be specified!");
            }
            if (this.namespaces == null) {
                throw new IllegalStateException("A list of namespaces must be specified!");
            }
            if (this.printStream == null) {
                throw new IllegalStateException("A target print stream must be specified!");
            }
            return new PodLogs(this.client, this.namespaces, this.printStream, this.filter);
        }
    }
}

