/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.junit5.listeners;

import cz.xtf.core.openshift.OpenShift;
import cz.xtf.core.openshift.OpenShifts;
import io.fabric8.kubernetes.api.model.Event;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventsRecorder
implements TestExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(EventsRecorder.class);

    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.recordEvents(Paths.get("log", "events"));
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        if (testIdentifier.isTest() && TestExecutionResult.Status.FAILED.equals((Object)testExecutionResult.getStatus())) {
            this.recordEvents(Paths.get("log", "pods", this.getTestDisplayName(testIdentifier), "events"));
        }
    }

    private String getTestDisplayName(TestIdentifier testIdentifier) {
        String className = ((String)testIdentifier.getParentId().get()).replaceAll(".*class:", "").replaceAll("].*", "");
        return String.format("%s#%s", className, testIdentifier.getDisplayName());
    }

    private void recordEvents(Path eventsLogPath) {
        OpenShift openShift = OpenShifts.master();
        if (openShift.getProject(openShift.getNamespace()) != null) {
            eventsLogPath.getParent().toFile().mkdirs();
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(eventsLogPath.toFile()), StandardCharsets.UTF_8);){
                ((Writer)writer).append("LAST SEEN");
                writer.append('\t');
                ((Writer)writer).append("FIRST SEEN");
                writer.append('\t');
                ((Writer)writer).append("COUNT");
                writer.append('\t');
                ((Writer)writer).append("NAME");
                writer.append('\t');
                ((Writer)writer).append("KIND");
                writer.append('\t');
                ((Writer)writer).append("SUBOBJECT");
                writer.append('\t');
                ((Writer)writer).append("TYPE");
                writer.append('\t');
                ((Writer)writer).append("REASON");
                writer.append('\t');
                ((Writer)writer).append("SOURCE");
                writer.append('\t');
                ((Writer)writer).append("MESSAGE");
                writer.append('\n');
                for (Event event : openShift.getEvents()) {
                    ((Writer)writer).append(event.getLastTimestamp());
                    writer.append('\t');
                    ((Writer)writer).append(event.getFirstTimestamp());
                    writer.append('\t');
                    ((Writer)writer).append("" + event.getCount());
                    writer.append('\t');
                    ((Writer)writer).append(event.getMetadata().getName());
                    writer.append('\t');
                    ((Writer)writer).append(event.getKind());
                    writer.append('\t');
                    ((Writer)writer).append(event.getInvolvedObject().getFieldPath());
                    writer.append('\t');
                    ((Writer)writer).append(event.getType());
                    writer.append('\t');
                    ((Writer)writer).append(event.getReason());
                    writer.append('\t');
                    ((Writer)writer).append(event.getSource().getComponent());
                    writer.append('\t');
                    ((Writer)writer).append(event.getMessage());
                    writer.append('\n');
                }
            }
            catch (FileNotFoundException e) {
                log.warn("FileNotFoundException opening {}", (Object)eventsLogPath, (Object)e);
            }
            catch (IOException e) {
                log.warn("IOException writing {}", (Object)eventsLogPath, (Object)e);
            }
        }
    }
}

