/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.api.security;

import io.agroal.api.security.AgroalSecurityProvider;
import java.util.Properties;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

public class AgroalKerberosSecurityProvider
implements AgroalSecurityProvider {
    private static final Properties EMPTY_PROPERTIES = new Properties();
    private static final String KERBEROS_v5 = "1.2.840.113554.1.2.2";

    @Override
    public Properties getSecurityProperties(Object securityObject) {
        if (securityObject instanceof GSSCredential) {
            try {
                Properties properties = new Properties();
                properties.setProperty("user", ((GSSCredential)securityObject).getName(new Oid(KERBEROS_v5)).toString());
                return properties;
            }
            catch (GSSException gSSException) {
                // empty catch block
            }
        }
        return EMPTY_PROPERTIES;
    }
}

