/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.springframework.boot;

import io.agroal.api.AgroalDataSource;
import io.agroal.api.AgroalDataSourceListener;
import io.agroal.api.AgroalDataSourceMetrics;
import io.agroal.api.AgroalPoolInterceptor;
import io.agroal.api.configuration.AgroalConnectionPoolConfiguration;
import io.agroal.api.configuration.AgroalDataSourceConfiguration;
import io.agroal.api.configuration.supplier.AgroalConnectionFactoryConfigurationSupplier;
import io.agroal.api.configuration.supplier.AgroalConnectionPoolConfigurationSupplier;
import io.agroal.api.configuration.supplier.AgroalDataSourceConfigurationSupplier;
import io.agroal.api.configuration.supplier.AgroalPropertiesReader;
import io.agroal.api.security.AgroalSecurityProvider;
import io.agroal.api.security.NamePrincipal;
import io.agroal.api.security.SimplePassword;
import io.agroal.api.transaction.TransactionIntegration;
import io.agroal.narayana.NarayanaTransactionIntegration;
import java.io.PrintWriter;
import java.security.Principal;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.transaction.jta.JtaTransactionManager;

public class AgroalDataSource
implements io.agroal.api.AgroalDataSource,
InitializingBean {
    private static final long serialVersionUID = 3633107290245258196L;
    private final Logger logger = LoggerFactory.getLogger(AgroalDataSource.class);
    private final AgroalDataSourceConfigurationSupplier datasourceConfiguration = new AgroalDataSourceConfigurationSupplier();
    private final AgroalConnectionPoolConfigurationSupplier connectionPoolConfiguration = new AgroalConnectionPoolConfigurationSupplier();
    private final AgroalConnectionFactoryConfigurationSupplier connectionFactoryConfiguration = new AgroalConnectionFactoryConfigurationSupplier();
    private io.agroal.api.AgroalDataSource delegate;
    private String datasourceName = "<default>";

    public AgroalDataSource() {
        this.connectionPoolConfiguration.maxSize(10);
    }

    public void afterPropertiesSet() throws SQLException {
        this.connectionPoolConfiguration.connectionFactoryConfiguration((Supplier)this.connectionFactoryConfiguration);
        this.datasourceConfiguration.connectionPoolConfiguration((Supplier)this.connectionPoolConfiguration);
        this.delegate = io.agroal.api.AgroalDataSource.from((Supplier)this.datasourceConfiguration, (AgroalDataSourceListener[])new AgroalDataSourceListener[]{new LoggingListener(this.datasourceName)});
        this.logger.info("Started DataSource {} connected to {}", (Object)this.datasourceName, (Object)this.getConfiguration().connectionPoolConfiguration().connectionFactoryConfiguration().jdbcUrl());
    }

    public void setName(String name) {
        this.datasourceName = name;
    }

    public void setImplementation(String name) {
        this.datasourceConfiguration.dataSourceImplementation(AgroalDataSourceConfiguration.DataSourceImplementation.valueOf((String)name));
    }

    public void setMaxSize(int size) {
        this.connectionPoolConfiguration.maxSize(size);
    }

    public void setMinSize(int size) {
        this.connectionPoolConfiguration.minSize(size);
    }

    public void setInitialSize(int size) {
        this.connectionPoolConfiguration.initialSize(size);
    }

    public void setValidateOnBorrow(boolean validateOnBorrow) {
        this.connectionPoolConfiguration.validateOnBorrow(validateOnBorrow);
    }

    public void setConnectionValidator(AgroalConnectionPoolConfiguration.ConnectionValidator validator) {
        this.connectionPoolConfiguration.connectionValidator(validator);
    }

    public void setConnectionValidatorName(String validator) {
        this.setConnectionValidator(AgroalPropertiesReader.parseConnectionValidator((String)validator));
    }

    public void setExceptionSorter(AgroalConnectionPoolConfiguration.ExceptionSorter sorter) {
        this.connectionPoolConfiguration.exceptionSorter(sorter);
    }

    public void setExceptionSorterName(String sorter) {
        this.setExceptionSorter(AgroalPropertiesReader.parseExceptionSorter((String)sorter));
    }

    public void setAcquisitionTimeout(int timeout) {
        this.connectionPoolConfiguration.acquisitionTimeout(Duration.ofSeconds(timeout));
    }

    public void setForegroundValidationTimeout(int timeout) {
        this.connectionPoolConfiguration.idleValidationTimeout(Duration.ofSeconds(timeout));
    }

    public void setIdleTimeout(int timeout) {
        this.connectionPoolConfiguration.reapTimeout(Duration.ofSeconds(timeout));
    }

    public void setLeakTimeout(int timeout) {
        this.connectionPoolConfiguration.leakTimeout(Duration.ofSeconds(timeout));
    }

    public void setLifetimeTimeout(int timeout) {
        this.connectionPoolConfiguration.maxLifetime(Duration.ofSeconds(timeout));
    }

    public void setValidationTimeout(int timeout) {
        this.connectionPoolConfiguration.validationTimeout(Duration.ofSeconds(timeout));
    }

    public void setJtaTransactionIntegration(TransactionIntegration transactionIntegration) {
        this.connectionPoolConfiguration.transactionIntegration(transactionIntegration);
    }

    public void setJtaTransactionIntegration(JtaTransactionManager jtaPlatform) {
        this.setJtaTransactionIntegration((TransactionIntegration)new NarayanaTransactionIntegration(jtaPlatform.getTransactionManager(), jtaPlatform.getTransactionSynchronizationRegistry()));
    }

    public void setJtaTransactionManager(JtaTransactionManager jtaPlatform) {
        this.setJtaTransactionIntegration(jtaPlatform);
    }

    public void setEnhancedLeakReport(boolean enhanced) {
        this.connectionPoolConfiguration.enhancedLeakReport(enhanced);
    }

    public void setFlushOnClose(boolean flush) {
        this.connectionPoolConfiguration.flushOnClose(flush);
    }

    public void setRecoveryEnable(boolean recovery) {
        this.connectionPoolConfiguration.recoveryEnable(recovery);
    }

    public String getUrl() {
        return this.getConfiguration().connectionPoolConfiguration().connectionFactoryConfiguration().jdbcUrl();
    }

    public void setUrl(String url) {
        this.connectionFactoryConfiguration.jdbcUrl(url);
    }

    public void setDriverClass(Class<? extends DataSource> driver) {
        this.connectionFactoryConfiguration.connectionProviderClass(driver);
    }

    public String getDriverClassName() {
        Class providerClass = this.getConfiguration().connectionPoolConfiguration().connectionFactoryConfiguration().connectionProviderClass();
        if (Driver.class.isAssignableFrom(providerClass)) {
            return providerClass.getName();
        }
        return DatabaseDriver.fromJdbcUrl((String)this.getUrl()).getDriverClassName();
    }

    public void setDriverClassName(String driver) {
        this.connectionFactoryConfiguration.connectionProviderClassName(driver);
    }

    public void addSecurityProvider(AgroalSecurityProvider securityProvider) {
        this.connectionFactoryConfiguration.addSecurityProvider(securityProvider);
    }

    public void addCredential(Object credential) {
        this.connectionFactoryConfiguration.credential(credential);
    }

    public void addRecoveryCredential(Object credential) {
        this.connectionFactoryConfiguration.recoveryCredential(credential);
    }

    public void setUsername(String username) {
        this.connectionFactoryConfiguration.principal((Principal)new NamePrincipal(username));
    }

    public void setPassword(String password) {
        this.connectionFactoryConfiguration.credential((Object)new SimplePassword(password));
    }

    public void setInitialSql(String initialSql) {
        this.connectionFactoryConfiguration.initialSql(initialSql);
    }

    public void setAutoCommit(boolean autoCommit) {
        this.connectionFactoryConfiguration.autoCommit(autoCommit);
    }

    public void setTrackResources(boolean track) {
        this.connectionFactoryConfiguration.trackJdbcResources(track);
    }

    public void setPoolRecovery(boolean poolRecovery) {
        this.connectionFactoryConfiguration.poolRecovery(poolRecovery);
    }

    public void setRecoveryUsername(String username) {
        this.connectionFactoryConfiguration.recoveryPrincipal((Principal)new NamePrincipal(username));
    }

    public void setRecoveryPassword(String password) {
        this.connectionFactoryConfiguration.recoveryCredential((Object)new SimplePassword(password));
    }

    public void setJdbcTransactionIsolation(int level) {
        this.connectionFactoryConfiguration.jdbcTransactionIsolation(level);
    }

    public void setJdbcProperties(Map<String, String> properties) {
        properties.forEach((arg_0, arg_1) -> ((AgroalConnectionFactoryConfigurationSupplier)this.connectionFactoryConfiguration).jdbcProperty(arg_0, arg_1));
    }

    public void setXaProperties(Map<String, String> properties) {
        properties.forEach((arg_0, arg_1) -> ((AgroalConnectionFactoryConfigurationSupplier)this.connectionFactoryConfiguration).xaProperty(arg_0, arg_1));
    }

    public AgroalDataSourceConfiguration getConfiguration() {
        return this.delegate.getConfiguration();
    }

    public AgroalDataSourceMetrics getMetrics() {
        return this.delegate.getMetrics();
    }

    public void setMetrics(boolean metrics) {
        this.datasourceConfiguration.metricsEnabled(metrics);
    }

    public void flush(AgroalDataSource.FlushMode mode) {
        this.delegate.flush(mode);
    }

    public boolean isHealthy(boolean newConnection) throws SQLException {
        return this.delegate.isHealthy(newConnection);
    }

    public List<AgroalPoolInterceptor> getPoolInterceptors() {
        return this.delegate.getPoolInterceptors();
    }

    public void setPoolInterceptors(Collection<? extends AgroalPoolInterceptor> interceptors) {
        this.delegate.setPoolInterceptors(interceptors);
    }

    public void close() {
        this.logger.debug("Closing DataSource {}", (Object)this.datasourceName);
        this.delegate.close();
        this.delegate = null;
    }

    public Connection getConnection() throws SQLException {
        return this.delegate.getConnection();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.delegate.getConnection(username, password);
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw new SQLException("Unable to unwrap: '" + this.getClass().getName() + "' is not a wrapper for '" + iface.getName() + "'");
    }

    public boolean isWrapperFor(Class<?> iface) {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.delegate.getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.delegate.setLogWriter(out);
    }

    public int getLoginTimeout() throws SQLException {
        return this.delegate.getLoginTimeout();
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.delegate.setLoginTimeout(seconds);
    }

    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.delegate.getParentLogger();
    }

    private static class LoggingListener
    implements AgroalDataSourceListener {
        private final Logger logger;

        LoggingListener(String name) {
            this.logger = LoggerFactory.getLogger((String)(io.agroal.api.AgroalDataSource.class.getName() + ".'" + name + "'"));
        }

        public void onWarning(String message) {
            this.logger.warn(message);
        }

        public void onWarning(Throwable throwable) {
            this.logger.warn(String.valueOf(throwable));
        }

        public void onInfo(String message) {
            this.logger.info(message);
        }

        public void onConnectionCreation(Connection connection) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Created connection {}", (Object)connection);
            }
        }

        public void onConnectionAcquire(Connection connection) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Connection acquired {}", (Object)connection);
            }
        }

        public void onConnectionReturn(Connection connection) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Connection return {}", (Object)connection);
            }
        }

        public void onConnectionLeak(Connection connection, Thread thread) {
            this.logger.info("Connection {} leak! Acquired by {}", (Object)connection, (Object)thread.getName());
            this.logger.info(Arrays.stream(thread.getStackTrace()).map(StackTraceElement::toString).collect(Collectors.joining(System.lineSeparator())));
        }

        public void beforeConnectionValidation(Connection connection) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Performing validation of {}", (Object)connection);
            }
        }

        public void onConnectionInvalid(Connection connection) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Connection invalid {}", (Object)connection);
            }
        }

        public void onConnectionReap(Connection connection) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Connection reap {}", (Object)connection);
            }
        }

        public void onConnectionDestroy(Connection connection) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Connection destroy {}", (Object)connection);
            }
        }
    }
}

