/*
 * Decompiled with CFR 0.152.
 */
package io.escalante.test.artifact.subsystem;

import io.escalante.artifact.subsystem.ArtifactExtension;
import io.escalante.artifact.subsystem.ArtifactExtension$;
import io.escalante.artifact.subsystem.ArtifactRepositoryService;
import io.escalante.artifact.subsystem.ArtifactRepositoryService$;
import io.escalante.artifact.subsystem.ThirdPartyModulesRepo$;
import io.escalante.test.subsystem.AbstractScalaSubsystemTest;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.ControllerInitializer;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.dmr.ModelNode;
import org.junit.Test;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

@ScalaSignature(bytes="\u0006\u000113A!\u0001\u0002\u0001\u001b\tI\u0012I\u001d;jM\u0006\u001cGoU;cgf\u001cH/Z7V]&$H+Z:u\u0015\t\u0019A!A\u0005tk\n\u001c\u0018p\u001d;f[*\u0011QAB\u0001\tCJ$\u0018NZ1di*\u0011q\u0001C\u0001\u0005i\u0016\u001cHO\u0003\u0002\n\u0015\u0005IQm]2bY\u0006tG/\u001a\u0006\u0002\u0017\u0005\u0011\u0011n\\\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010#5\t\u0001C\u0003\u0002\u0004\r%\u0011!\u0003\u0005\u0002\u001b\u0003\n\u001cHO]1diN\u001b\u0017\r\\1Tk\n\u001c\u0018p\u001d;f[R+7\u000f\u001e\u0005\u0006)\u0001!\t!F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Y\u0001\"a\u0006\u0001\u000e\u0003\tAQ!\u0007\u0001\u0005\u0002i\t!\u0003^3tiB\u000b'o]3Tk\n\u001c\u0018p\u001d;f[R\t1\u0004\u0005\u0002\u001d?5\tQDC\u0001\u001f\u0003\u0015\u00198-\u00197b\u0013\t\u0001SD\u0001\u0003V]&$\bF\u0001\r#!\t\u0019\u0003&D\u0001%\u0015\t)c%A\u0003kk:LGOC\u0001(\u0003\ry'oZ\u0005\u0003S\u0011\u0012A\u0001V3ti\")1\u0006\u0001C\u00015\u0005qB/Z:u!\u0006\u00148/\u001a+iSJ$\u0007/\u0019:us6{G-\u001e7fgJ+\u0007o\u001c\u0015\u0003U\tBQA\f\u0001\u0005\u0002i\t\u0001\u0004^3ti&s7\u000f^1mY2Kg\r^*vENL8\u000f^3nQ\ti#\u0005C\u00032\u0001\u0011\u0005!$A\u001auKN$\u0018J\\:uC2dw+\u001b;i'f\u001c\bK]8qKJ$\u0018\u0010\u00165je\u0012\u0004\u0018M\u001d;z\u001b>$W\u000f\\3t%\u0016\u0004x\u000eU1uQ\"\u0012\u0001G\t\u0004\u0005i\u0001\u0001QG\u0001\nQCRD\u0017J\\5uS\u0006d\u0017N_1uS>t7CA\u001a7!\t9d(D\u00019\u0015\t9\u0011H\u0003\u0002\u0004u)\u00111\bP\u0001\u0003CNT!!\u0010\u0014\u0002\u000b)\u0014wn]:\n\u0005}B$\u0001G!eI&$\u0018n\u001c8bY&s\u0017\u000e^5bY&T\u0018\r^5p]\")Ac\rC\u0001\u0003R\t!\t\u0005\u0002Dg5\t\u0001\u0001C\u0003Fg\u0011\u0005c)A\btKR,\boQ8oiJ|G\u000e\\3s)\tYr\tC\u0003I\t\u0002\u0007\u0011*\u0001\u0003j]&$\bCA\u001cK\u0013\tY\u0005HA\u000bD_:$(o\u001c7mKJLe.\u001b;jC2L'0\u001a:")
public class ArtifactSubsystemUnitTest
extends AbstractScalaSubsystemTest {
    @Test
    public void testParseSubsystem() {
        TopScope$ $tmpscope = Predef$.MODULE$.$scope();
        TopScope$ $scope = $tmpscope = new NamespaceBinding(null, ArtifactExtension$.MODULE$.ARTIFACT_SUBSYSTEM_NAMESPACE(), (NamespaceBinding)$tmpscope);
        Elem subsystemXml = new Elem(null, "subsystem", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0]));
        Iterable<ModelNode> operations = super.parse(subsystemXml);
        this.assert(this.convertToEqualizer(BoxesRunTime.boxToInteger((int)1)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)operations.size())));
        ModelNode op = (ModelNode)operations.head();
        this.assert(this.convertToEqualizer("add").$eq$eq$eq((Object)op.get("operation").asString()));
        PathAddress addr = PathAddress.pathAddress((ModelNode)op.get("address"));
        this.assert(this.convertToEqualizer(BoxesRunTime.boxToInteger((int)1)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)addr.size())));
        PathElement element = addr.getElement(0);
        this.assert(this.convertToEqualizer("subsystem").$eq$eq$eq((Object)element.getKey()));
        this.assert(this.convertToEqualizer(ArtifactExtension$.MODULE$.ARTIFACT_SUBSYSTEM_NAME()).$eq$eq$eq((Object)element.getValue()));
        this.assert(!op.hasDefined(ThirdPartyModulesRepo$.MODULE$.RELATIVE_TO()));
        this.assert(!op.hasDefined(ThirdPartyModulesRepo$.MODULE$.PATH()));
    }

    @Test
    public void testParseThirdpartyModulesRepo() {
        TopScope$ $tmpscope = Predef$.MODULE$.$scope();
        TopScope$ $scope = $tmpscope = new NamespaceBinding(null, ArtifactExtension$.MODULE$.ARTIFACT_SUBSYSTEM_NAMESPACE(), (NamespaceBinding)$tmpscope);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n        "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("path", (Seq)new Text("y"), (MetaData)$md);
        $md = new UnprefixedAttribute("relative-to", (Seq)new Text("x"), (MetaData)$md);
        $buf.$amp$plus((Object)new Elem(null, "thirdparty-modules-repo", (MetaData)$md, (NamespaceBinding)$scope, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf.$amp$plus((Object)new Text("\n      "));
        Elem subsystemXml = new Elem(null, "subsystem", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, false, (Seq)$buf);
        Iterable<ModelNode> operations = super.parse(subsystemXml);
        this.assert(this.convertToEqualizer(BoxesRunTime.boxToInteger((int)1)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)operations.size())));
        ModelNode op = (ModelNode)operations.head();
        this.assert(this.convertToEqualizer("add").$eq$eq$eq((Object)op.get("operation").asString()));
        PathAddress addr = PathAddress.pathAddress((ModelNode)op.get("address"));
        this.assert(this.convertToEqualizer(BoxesRunTime.boxToInteger((int)1)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)addr.size())));
        PathElement element = addr.getElement(0);
        this.assert(this.convertToEqualizer("subsystem").$eq$eq$eq((Object)element.getKey()));
        this.assert(this.convertToEqualizer(ArtifactExtension$.MODULE$.ARTIFACT_SUBSYSTEM_NAME()).$eq$eq$eq((Object)element.getValue()));
        this.assert(this.convertToEqualizer("x").$eq$eq$eq((Object)op.get(ThirdPartyModulesRepo$.MODULE$.RELATIVE_TO()).asString()));
        this.assert(this.convertToEqualizer("y").$eq$eq$eq((Object)op.get(ThirdPartyModulesRepo$.MODULE$.PATH()).asString()));
    }

    @Test
    public void testInstallLiftSubsystem() {
        TopScope$ $tmpscope = Predef$.MODULE$.$scope();
        TopScope$ $scope = $tmpscope = new NamespaceBinding(null, ArtifactExtension$.MODULE$.ARTIFACT_SUBSYSTEM_NAMESPACE(), (NamespaceBinding)$tmpscope);
        Elem subsystemXml = new Elem(null, "subsystem", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0]));
        KernelServices services = super.installInController(new PathInitialization(), subsystemXml);
        ModelNode model = services.readWholeModel();
        this.assert(model.get("subsystem").hasDefined(ArtifactExtension$.MODULE$.ARTIFACT_SUBSYSTEM_NAME()));
        ModelNode liftNode = model.get("subsystem").get(ArtifactExtension$.MODULE$.ARTIFACT_SUBSYSTEM_NAME());
        this.assert(!liftNode.hasDefined(ThirdPartyModulesRepo$.MODULE$.RELATIVE_TO()));
        this.assert(!liftNode.hasDefined(ThirdPartyModulesRepo$.MODULE$.PATH()));
    }

    @Test
    public void testInstallWithSysPropertyThirdpartyModulesRepoPath() {
        String key = "my.path.expression";
        String value = "lift1234";
        System.setProperty(key, value);
        try {
            TopScope$ $tmpscope = Predef$.MODULE$.$scope();
            TopScope$ $scope = $tmpscope = new NamespaceBinding(null, ArtifactExtension$.MODULE$.ARTIFACT_SUBSYSTEM_NAMESPACE(), (NamespaceBinding)$tmpscope);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n          "));
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("path", (Seq)new Text("/path/${my.path.expression}"), (MetaData)$md);
            $buf.$amp$plus((Object)new Elem(null, "thirdparty-modules-repo", (MetaData)$md, (NamespaceBinding)$scope, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
            $buf.$amp$plus((Object)new Text("\n        "));
            Elem subsystemXml = new Elem(null, "subsystem", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, false, (Seq)$buf);
            KernelServices services = super.installInController(new PathInitialization(), subsystemXml);
            ModelNode model = services.readWholeModel();
            this.assert(model.get("subsystem").hasDefined(ArtifactExtension$.MODULE$.ARTIFACT_SUBSYSTEM_NAME()));
            ModelNode node = model.get("subsystem").get(ArtifactExtension$.MODULE$.ARTIFACT_SUBSYSTEM_NAME());
            this.assert(!node.hasDefined(ThirdPartyModulesRepo$.MODULE$.RELATIVE_TO()));
            ArtifactRepositoryService service = (ArtifactRepositoryService)services.getContainer().getService(ArtifactRepositoryService$.MODULE$.SERVICE_NAME()).getValue();
            this.assert(this.convertToEqualizer(new StringBuilder().append((Object)"/path/").append((Object)value).toString()).$eq$eq$eq((Object)service.thirdPartyModulesPath()));
            this.assert(this.convertToEqualizer(new StringBuilder().append((Object)"/path/${").append((Object)key).append((Object)"}").toString()).$eq$eq$eq((Object)node.get(ThirdPartyModulesRepo$.MODULE$.PATH()).asString()));
            return;
        }
        finally {
            System.clearProperty(key);
        }
    }

    public ArtifactSubsystemUnitTest() {
        super(ArtifactExtension$.MODULE$.ARTIFACT_SUBSYSTEM_NAME(), (Extension)new ArtifactExtension());
    }

    public class PathInitialization
    extends AdditionalInitialization {
        public void setupController(ControllerInitializer init) {
            init.addPath("jboss.home.dir", "thirdparty-modules", null);
        }

        public /* synthetic */ ArtifactSubsystemUnitTest io$escalante$test$artifact$subsystem$ArtifactSubsystemUnitTest$PathInitialization$$$outer() {
            return ArtifactSubsystemUnitTest.this;
        }

        public PathInitialization() {
            if (ArtifactSubsystemUnitTest.this == null) {
                throw new NullPointerException();
            }
        }
    }
}

