/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import org.jboss.as.cmp.CmpMessages;
import org.jboss.as.cmp.context.CmpEntityBeanContext;
import org.jboss.as.cmp.jdbc.JDBCCreateCommand;
import org.jboss.as.cmp.jdbc.JDBCStoreManager;
import org.jboss.as.cmp.jdbc.JDBCUtil;
import org.jboss.as.cmp.jdbc.SQLExceptionProcessor;
import org.jboss.as.cmp.jdbc.SQLUtil;
import org.jboss.as.cmp.jdbc.bridge.JDBCCMPFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCCMRFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCEntityBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCFieldBridge;
import org.jboss.as.cmp.jdbc.metadata.JDBCEntityCommandMetaData;
import org.jboss.logging.Logger;
import org.jboss.security.AuthenticationManager;

public abstract class JDBCAbstractCreateCommand
implements JDBCCreateCommand {
    protected Logger log;
    protected boolean debug;
    protected boolean trace;
    protected JDBCEntityBridge entity;
    protected AuthenticationManager securityManager;
    protected boolean createAllowed;
    protected SQLExceptionProcessor exceptionProcessor;
    protected String insertSQL;
    protected JDBCFieldBridge[] insertFields;
    protected boolean insertAfterEjbPostCreate;
    private JDBCCMPFieldBridge createdPrincipal;
    private JDBCCMPFieldBridge createdTime;
    private JDBCCMPFieldBridge updatedPrincipal;
    private JDBCCMPFieldBridge updatedTime;

    @Override
    public void init(JDBCStoreManager manager) {
        this.log = Logger.getLogger((String)(this.getClass().getName() + '.' + manager.getMetaData().getName()));
        this.debug = this.log.isDebugEnabled();
        this.trace = this.log.isTraceEnabled();
        this.entity = (JDBCEntityBridge)manager.getEntityBridge();
        this.insertAfterEjbPostCreate = manager.getCmpConfig().isInsertAfterEjbPostCreate();
        this.createAllowed = true;
        JDBCFieldBridge[] pkFields = this.entity.getPrimaryKeyFields();
        for (int i = 0; i < pkFields.length; ++i) {
            if (!pkFields[i].isReadOnly()) continue;
            this.createAllowed = false;
            this.log.debug((Object)("Create will not be allowed because pk field " + pkFields[i].getFieldName() + "is read only."));
            break;
        }
        this.initGeneratedFields();
        JDBCEntityCommandMetaData entityCommand = manager.getMetaData().getEntityCommand();
        if (entityCommand == null) {
            throw CmpMessages.MESSAGES.entityCommandIsNull();
        }
        this.initEntityCommand(entityCommand);
        this.initInsertFields();
        this.initInsertSQL();
    }

    protected void initEntityCommand(JDBCEntityCommandMetaData entityCommand) {
        this.exceptionProcessor = null;
    }

    @Override
    public Object execute(Method m, Object[] args, CmpEntityBeanContext ctx) throws CreateException {
        if (this.insertAfterEjbPostCreate) {
            if (!JDBCEntityBridge.isEjbCreateDone(ctx)) {
                this.checkCreateAllowed();
                this.generateFields(ctx);
                JDBCEntityBridge.setEjbCreateDone(ctx);
            } else {
                this.beforeInsert(ctx);
                this.performInsert(ctx);
                this.afterInsert(ctx);
                JDBCEntityBridge.setCreated(ctx);
            }
        } else {
            this.checkCreateAllowed();
            this.generateFields(ctx);
            this.beforeInsert(ctx);
            this.performInsert(ctx);
            this.afterInsert(ctx);
            JDBCEntityBridge.setCreated(ctx);
        }
        return this.getPrimaryKey(ctx);
    }

    protected void checkCreateAllowed() throws CreateException {
        if (!this.createAllowed) {
            throw CmpMessages.MESSAGES.creationNotAllowedPKReadOnly();
        }
    }

    protected JDBCCMPFieldBridge getGeneratedPKField() {
        JDBCCMPFieldBridge pkField = null;
        JDBCFieldBridge[] pkFields = this.entity.getPrimaryKeyFields();
        for (int i = 0; i < pkFields.length; ++i) {
            if (pkField != null) {
                throw CmpMessages.MESSAGES.generationOnlySupportedWithSinglePK();
            }
            pkField = (JDBCCMPFieldBridge)pkFields[i];
        }
        return pkField;
    }

    protected void initGeneratedFields() {
        this.createdPrincipal = this.entity.getCreatedPrincipalField();
        if (this.securityManager == null && this.createdPrincipal != null) {
            throw CmpMessages.MESSAGES.noSecurityDomainForCreatedBy();
        }
        this.updatedPrincipal = this.entity.getUpdatedPrincipalField();
        if (this.securityManager == null && this.updatedPrincipal != null) {
            throw CmpMessages.MESSAGES.noSecurityDomainForCreatedBy();
        }
        this.createdTime = this.entity.getCreatedTimeField();
        this.updatedTime = this.entity.getUpdatedTimeField();
    }

    protected void generateFields(CmpEntityBeanContext ctx) throws CreateException {
        if (this.securityManager != null) {
            String principalName = ctx.getCallerPrincipal().getName();
            if (this.createdPrincipal != null && this.createdPrincipal.getInstanceValue(ctx) == null) {
                this.createdPrincipal.setInstanceValue(ctx, principalName);
            }
        }
        Date date = null;
        if (this.createdTime != null && this.createdTime.getInstanceValue(ctx) == null) {
            date = new Date();
            this.createdTime.setInstanceValue(ctx, date);
        }
    }

    protected void initInsertFields() {
        JDBCFieldBridge[] fields = this.entity.getTableFields();
        ArrayList<JDBCFieldBridge> insertFieldsList = new ArrayList<JDBCFieldBridge>(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            JDBCFieldBridge field = fields[i];
            if (!this.isInsertField(field)) continue;
            insertFieldsList.add(field);
        }
        this.insertFields = insertFieldsList.toArray(new JDBCFieldBridge[insertFieldsList.size()]);
    }

    protected boolean isInsertField(JDBCFieldBridge field) {
        boolean result;
        boolean bl = result = !(field instanceof JDBCCMRFieldBridge) && field.getJDBCType() != null && !field.isReadOnly();
        if (field instanceof JDBCCMPFieldBridge) {
            result = result && !((JDBCCMPFieldBridge)field).isRelationTableField();
        }
        return result;
    }

    protected void initInsertSQL() {
        StringBuffer sql = new StringBuffer(250);
        sql.append("INSERT INTO ").append(this.entity.getQualifiedTableName()).append(" (");
        SQLUtil.getColumnNamesClause(this.insertFields, sql);
        sql.append(')').append(" VALUES ").append('(');
        SQLUtil.getValuesClause(this.insertFields, sql).append(')');
        this.insertSQL = sql.toString();
        if (this.debug) {
            this.log.debug((Object)("Insert Entity SQL: " + this.insertSQL));
        }
    }

    protected void beforeInsert(CmpEntityBeanContext ctx) throws CreateException {
    }

    protected void performInsert(CmpEntityBeanContext ctx) throws CreateException {
        Connection c = null;
        PreparedStatement ps = null;
        boolean throwRuntimeExceptions = this.entity.getMetaData().getThrowRuntimeExceptions();
        if (throwRuntimeExceptions) {
            try {
                c = this.entity.getDataSource().getConnection();
            }
            catch (SQLException sqle) {
                EJBException ejbe = new EJBException("Could not get a connection; " + sqle);
                ejbe.initCause((Throwable)sqle);
                throw ejbe;
            }
        }
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Executing SQL: " + this.insertSQL));
            }
            if (!throwRuntimeExceptions) {
                c = this.entity.getDataSource().getConnection();
            }
            ps = this.prepareStatement(c, this.insertSQL, ctx);
            int index = 1;
            for (int fieldInd = 0; fieldInd < this.insertFields.length; ++fieldInd) {
                index = this.insertFields[fieldInd].setInstanceParameters(ps, index, ctx);
            }
            int rowsAffected = this.executeInsert(index, ps, ctx);
            if (rowsAffected != 1) {
                throw CmpMessages.MESSAGES.expectedOneRow(rowsAffected, ctx.getPrimaryKeyUnchecked());
            }
        }
        catch (SQLException e) {
            try {
                if (this.exceptionProcessor != null && this.exceptionProcessor.isDuplicateKey(e)) {
                    throw CmpMessages.MESSAGES.uniqueKeyViolationInvalidFk(ctx.getPrimaryKeyUnchecked());
                }
                throw CmpMessages.MESSAGES.couldNotCreateEntity(e);
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(ps);
                JDBCUtil.safeClose(c);
                throw throwable;
            }
        }
        JDBCUtil.safeClose(ps);
        JDBCUtil.safeClose(c);
        for (int fieldInd = 0; fieldInd < this.insertFields.length; ++fieldInd) {
            this.insertFields[fieldInd].setClean(ctx);
        }
    }

    protected PreparedStatement prepareStatement(Connection c, String sql, CmpEntityBeanContext ctx) throws SQLException {
        return c.prepareStatement(sql);
    }

    protected int executeInsert(int paramIndex, PreparedStatement ps, CmpEntityBeanContext ctx) throws SQLException {
        return ps.executeUpdate();
    }

    protected void afterInsert(CmpEntityBeanContext ctx) throws CreateException {
    }

    protected Object getPrimaryKey(CmpEntityBeanContext ctx) {
        return this.entity.extractPrimaryKeyFromInstance(ctx);
    }
}

