/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.addressRewrite;

import java.net.URI;
import java.net.URL;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.stack.cxf.Loggers;

public class SoapAddressRewriteHelper {
    private static final String HTTP = "http";
    private static final String HTTPS = "https";

    public static String getRewrittenPublishedEndpointUrl(String wsdlAddress, String epAddress, ServerConfig serverConfig) {
        if (wsdlAddress == null) {
            return null;
        }
        if (SoapAddressRewriteHelper.isRewriteRequired(serverConfig, wsdlAddress)) {
            String origUriScheme = SoapAddressRewriteHelper.getUriScheme(wsdlAddress);
            String newUriScheme = SoapAddressRewriteHelper.getUriScheme(epAddress);
            String uriScheme = origUriScheme.equals(HTTPS) || newUriScheme.equals(HTTPS) ? HTTPS : HTTP;
            return SoapAddressRewriteHelper.rewriteSoapAddress(serverConfig, wsdlAddress, epAddress, uriScheme);
        }
        return wsdlAddress;
    }

    public static boolean isAutoRewriteOn(ServerConfig serverConfig) {
        return serverConfig.isModifySOAPAddress() && "jbossws.undefined.host".equals(serverConfig.getWebServiceHost());
    }

    private static boolean isRewriteRequired(ServerConfig serverConfig, String address) {
        if (serverConfig.isModifySOAPAddress()) {
            Loggers.ADDRESS_REWRITE_LOGGER.addressRewriteRequiredBecauseOfServerConf(address);
            return true;
        }
        if (SoapAddressRewriteHelper.isInvalidAddress(address)) {
            Loggers.ADDRESS_REWRITE_LOGGER.addressRewriteRequiredBecauseOfInvalidAddress(address);
            return true;
        }
        Loggers.ADDRESS_REWRITE_LOGGER.rewriteNotRequired(address);
        return false;
    }

    private static boolean isInvalidAddress(String address) {
        if (address == null) {
            return true;
        }
        String s = address.trim();
        if (s.length() == 0 || s.contains("REPLACE_WITH_ACTUAL_URL")) {
            return true;
        }
        try {
            new URL(s);
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    private static String rewriteSoapAddress(ServerConfig serverConfig, String origAddress, String newAddress, String uriScheme) {
        try {
            int portNo;
            URL url = new URL(newAddress);
            String path = url.getPath();
            String host = serverConfig.getWebServiceHost();
            String port = "";
            if (HTTPS.equals(uriScheme)) {
                portNo = serverConfig.getWebServiceSecurePort();
                if (portNo != 443) {
                    port = ":" + portNo;
                }
            } else {
                portNo = serverConfig.getWebServicePort();
                if (portNo != 80) {
                    port = ":" + portNo;
                }
            }
            String urlStr = uriScheme + "://" + host + port + path;
            Loggers.ADDRESS_REWRITE_LOGGER.addressRewritten(origAddress, urlStr);
            return urlStr;
        }
        catch (Exception e) {
            Loggers.ADDRESS_REWRITE_LOGGER.invalidAddressProvidedUseItWithoutRewriting(newAddress, origAddress);
            return origAddress;
        }
    }

    private static String getUriScheme(String address) {
        try {
            URI addrURI = new URI(address);
            String scheme = addrURI.getScheme();
            return scheme != null ? scheme : HTTP;
        }
        catch (Exception e) {
            return HTTP;
        }
    }
}

