/*
 * Decompiled with CFR 0.152.
 */
package play.core.server.netty;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.net.ssl.KeyManagerFactory;
import play.api.Logger$;
import resource.Resource$;
import resource.package$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ManifestFactory$;
import scala.util.control.NonFatal$;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateIssuerName;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateSubjectName;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public final class FakeKeyStore$ {
    public static final FakeKeyStore$ MODULE$;
    private final String GeneratedKeyStore;
    private final String DnName;

    static {
        new FakeKeyStore$();
    }

    public String GeneratedKeyStore() {
        return this.GeneratedKeyStore;
    }

    public String DnName() {
        return this.DnName;
    }

    public Option<KeyManagerFactory> keyManagerFactory(File appPath) {
        None$ none$;
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            File keyStoreFile = new File(appPath, this.GeneratedKeyStore());
            if (keyStoreFile.exists()) {
                package$.MODULE$.managed((Function0)new Serializable(keyStoreFile){
                    public static final long serialVersionUID = 0L;
                    private final File keyStoreFile$1;

                    public final FileInputStream apply() {
                        return new FileInputStream(this.keyStoreFile$1);
                    }
                    {
                        this.keyStoreFile$1 = keyStoreFile$1;
                    }
                }, Resource$.MODULE$.closeableResource(), ManifestFactory$.MODULE$.classType(FileInputStream.class)).foreach((Function1)new Serializable(keyStore){
                    public static final long serialVersionUID = 0L;
                    private final KeyStore keyStore$1;

                    public final void apply(FileInputStream in) {
                        this.keyStore$1.load(in, "".toCharArray());
                    }
                    {
                        this.keyStore$1 = keyStore$1;
                    }
                });
            } else {
                Logger$.MODULE$.apply("play").info((Function0<String>)new Serializable(keyStoreFile){
                    public static final long serialVersionUID = 0L;
                    private final File keyStoreFile$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Generating HTTPS key pair in ").append((Object)this.keyStoreFile$1.getAbsolutePath()).append((Object)" - this may take some time. If nothing happens, try moving the mouse/typing on the keyboard to generate some entropy.").toString();
                    }
                    {
                        this.keyStoreFile$1 = keyStoreFile$1;
                    }
                });
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
                keyPairGenerator.initialize(1024);
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                X509Certificate cert = this.createSelfSignedCertificate(keyPair);
                keyStore.load(null, "".toCharArray());
                keyStore.setKeyEntry("playgenerated", keyPair.getPrivate(), "".toCharArray(), (Certificate[])((Object[])new Certificate[]{cert}));
                package$.MODULE$.managed((Function0)new Serializable(keyStoreFile){
                    public static final long serialVersionUID = 0L;
                    private final File keyStoreFile$1;

                    public final FileOutputStream apply() {
                        return new FileOutputStream(this.keyStoreFile$1);
                    }
                    {
                        this.keyStoreFile$1 = keyStoreFile$1;
                    }
                }, Resource$.MODULE$.closeableResource(), ManifestFactory$.MODULE$.classType(FileOutputStream.class)).foreach((Function1)new Serializable(keyStore){
                    public static final long serialVersionUID = 0L;
                    private final KeyStore keyStore$1;

                    public final void apply(FileOutputStream out) {
                        this.keyStore$1.store(out, "".toCharArray());
                    }
                    {
                        this.keyStore$1 = keyStore$1;
                    }
                });
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(keyStore, "".toCharArray());
            none$ = new Some((Object)kmf);
        }
        catch (Throwable throwable) {
            None$ none$2;
            Throwable x4 = throwable;
            Option o11 = NonFatal$.MODULE$.unapply(x4);
            if (o11.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)o11.get();
            Logger$.MODULE$.apply("play").error((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error loading fake key store";
                }
            }, (Function0<Throwable>)new Serializable(e){
                public static final long serialVersionUID = 0L;
                private final Throwable e$1;

                public final Throwable apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = e$1;
                }
            });
            none$ = none$2 = None$.MODULE$;
        }
        return none$;
    }

    public X509Certificate createSelfSignedCertificate(KeyPair keyPair) {
        X509CertInfo certInfo = new X509CertInfo();
        certInfo.set("serialNumber", new CertificateSerialNumber(new BigInteger(64, new SecureRandom())));
        certInfo.set("version", new CertificateVersion(2));
        Date validFrom = new Date();
        Date validTo = new Date(validFrom.getTime() + 1576800000000L);
        CertificateValidity validity = new CertificateValidity(validFrom, validTo);
        certInfo.set("validity", validity);
        X500Name owner = new X500Name(this.DnName());
        certInfo.set("subject", new CertificateSubjectName(owner));
        certInfo.set("issuer", new CertificateIssuerName(owner));
        certInfo.set("key", new CertificateX509Key(keyPair.getPublic()));
        AlgorithmId algorithm = new AlgorithmId(AlgorithmId.sha1WithRSAEncryption_oid);
        certInfo.set("algorithmID", new CertificateAlgorithmId(algorithm));
        X509CertImpl cert = new X509CertImpl(certInfo);
        cert.sign(keyPair.getPrivate(), "SHA1withRSA");
        AlgorithmId actualAlgorithm = (AlgorithmId)cert.get("x509.algorithm");
        certInfo.set("algorithmID.algorithm", actualAlgorithm);
        X509CertImpl newCert = new X509CertImpl(certInfo);
        newCert.sign(keyPair.getPrivate(), "SHA1withRSA");
        return newCert;
    }

    private FakeKeyStore$() {
        MODULE$ = this;
        this.GeneratedKeyStore = "conf/generated.keystore";
        this.DnName = "CN=localhost, OU=Unit Testing, O=Mavericks, L=Moon Base 1, ST=Cyberspace, C=CY";
    }
}

