/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hornetq.spi.core.naming.BindingRegistry;
import org.jboss.as.messaging.MessagingLogger;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.ValueManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.value.Values;

public class AS7BindingRegistry
implements BindingRegistry {
    private final ServiceContainer container;

    public AS7BindingRegistry(ServiceContainer container) {
        this.container = container;
    }

    public Object getContext() {
        return null;
    }

    public void setContext(Object ctx) {
    }

    public Object lookup(String name) {
        return null;
    }

    public boolean bind(String name, Object obj) {
        if (name == null || name.isEmpty()) {
            throw MessagingMessages.MESSAGES.cannotBindJndiName();
        }
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)name);
        BinderService binderService = new BinderService(bindInfo.getBindName());
        this.container.addService(bindInfo.getBinderServiceName(), (Service)binderService).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binderService.getNamingStoreInjector()).addInjection(binderService.getManagedObjectInjector(), (Object)new ValueManagedReferenceFactory(Values.immediateValue((Object)obj))).setInitialMode(ServiceController.Mode.ACTIVE).install();
        MessagingLogger.ROOT_LOGGER.boundJndiName(bindInfo.getAbsoluteJndiName());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(String name) {
        if (name == null || name.isEmpty()) {
            throw MessagingMessages.MESSAGES.cannotUnbindJndiName();
        }
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)name);
        ServiceController bindingService = this.container.getService(bindInfo.getBinderServiceName());
        if (bindingService == null) {
            MessagingLogger.ROOT_LOGGER.debugf("Cannot unbind %s since no binding exists with that name", name);
            return;
        }
        final CountDownLatch removedLatch = new CountDownLatch(1);
        AbstractServiceListener listener = new AbstractServiceListener(){

            public void transition(ServiceController controller, ServiceController.Transition transition) {
                if (transition.getAfter() == ServiceController.Substate.REMOVED) {
                    removedLatch.countDown();
                }
            }
        };
        bindingService.addListener((ServiceListener)listener);
        bindingService.setMode(ServiceController.Mode.REMOVE);
        try {
            if (!removedLatch.await(5L, TimeUnit.SECONDS)) {
                MessagingLogger.ROOT_LOGGER.failedToUnbindJndiName(name, 5L, TimeUnit.SECONDS.toString().toLowerCase(Locale.US));
                return;
            }
            MessagingLogger.ROOT_LOGGER.unboundJndiName(bindInfo.getAbsoluteJndiName());
        }
        catch (InterruptedException e) {
            MessagingLogger.ROOT_LOGGER.failedToUnbindJndiName(name, 5L, TimeUnit.SECONDS.toString().toLowerCase(Locale.US));
        }
        finally {
            bindingService.removeListener((ServiceListener)listener);
        }
    }

    public void close() {
    }
}

