/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa;

import java.util.Vector;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.poa.Current;
import org.jacorb.poa.EventMulticaster;
import org.jacorb.poa.RPPoolManagerListener;
import org.jacorb.poa.RequestProcessor;
import org.jacorb.poa.except.POAInternalError;
import org.omg.CORBA.TIMEOUT;
import org.slf4j.Logger;

public abstract class RPPoolManager {
    private RPPoolManagerListener pmListener;
    private final Current current;
    private Vector pool;
    private Vector activeProcessors;
    private int unused_size;
    private final int max_pool_size;
    private final int min_pool_size;
    private boolean inUse = false;
    private final Configuration configuration;
    private final Logger logger;
    private int poolThreadTimeout;

    protected RPPoolManager(Current _current, int min, int max, Logger _logger, Configuration _configuration) {
        this.current = _current;
        this.max_pool_size = max;
        this.min_pool_size = min;
        this.logger = _logger;
        this.configuration = _configuration;
        this.poolThreadTimeout = this.configuration.getAttributeAsInteger("jacorb.poa.threadtimeout", 0);
    }

    private void addProcessor() {
        RequestProcessor rp = new RequestProcessor(this);
        try {
            rp.configure(this.configuration);
        }
        catch (ConfigurationException ex) {
            throw new RuntimeException(ex.toString());
        }
        this.current._addContext(rp, rp);
        rp.setDaemon(true);
        this.pool.addElement(rp);
        ++this.unused_size;
        rp.start();
    }

    protected synchronized void addRPPoolManagerListener(RPPoolManagerListener listener) {
        this.pmListener = EventMulticaster.add(this.pmListener, listener);
    }

    abstract void destroy();

    protected synchronized void destroy(boolean really) {
        if (this.pool == null || !this.inUse) {
            return;
        }
        while (!this.activeProcessors.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {}
        }
        Object[] rps = new RequestProcessor[this.pool.size()];
        this.pool.copyInto(rps);
        for (int i = 0; i < rps.length; ++i) {
            if (((RequestProcessor)rps[i]).isActive()) {
                throw new POAInternalError("error: request processor is active (RequestProcessorPM.destroy)");
            }
            this.pool.removeElement(rps[i]);
            --this.unused_size;
            this.current._removeContext((Thread)rps[i]);
            ((RequestProcessor)rps[i]).end();
        }
        this.inUse = false;
    }

    protected int getPoolCount() {
        return this.pool == null ? 0 : this.pool.size();
    }

    protected synchronized int getPoolSize() {
        return this.unused_size;
    }

    protected synchronized RequestProcessor getProcessor() {
        if (!this.inUse) {
            this.init();
            this.inUse = true;
        }
        if (this.pool.isEmpty() && this.unused_size < this.max_pool_size) {
            this.addProcessor();
        }
        int timeout = this.poolThreadTimeout;
        while (this.pool.isEmpty()) {
            this.warnPoolIsEmpty();
            long start = System.currentTimeMillis();
            try {
                this.wait(timeout);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (timeout <= 0) continue;
            if (System.currentTimeMillis() - start >= (long)timeout && this.pool.isEmpty()) {
                throw new TIMEOUT("No request processor available to handle request");
            }
            if (System.currentTimeMillis() - start >= (long)timeout || !this.pool.isEmpty()) continue;
            timeout = (int)((long)timeout - (System.currentTimeMillis() - start));
        }
        RequestProcessor requestProcessor = (RequestProcessor)this.pool.remove(this.pool.size() - 1);
        this.activeProcessors.add(requestProcessor);
        if (this.pmListener != null) {
            this.pmListener.processorRemovedFromPool(requestProcessor, this.pool.size(), this.unused_size);
        }
        return requestProcessor;
    }

    protected void warnPoolIsEmpty() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("Thread pool exhausted, consider increasing jacorb.poa.thread_pool_max (currently: " + this.max_pool_size + ")");
        }
    }

    private void init() {
        this.pool = new Vector(this.max_pool_size);
        this.activeProcessors = new Vector(this.max_pool_size);
        for (int i = 0; i < this.min_pool_size; ++i) {
            this.addProcessor();
        }
    }

    protected synchronized void releaseProcessor(RequestProcessor rp) {
        this.activeProcessors.remove(rp);
        if (this.pool.size() < this.min_pool_size) {
            this.pool.addElement(rp);
        } else {
            --this.unused_size;
            this.current._removeContext(rp);
            rp.end();
        }
        if (this.pmListener != null) {
            this.pmListener.processorAddedToPool(rp, this.pool.size(), this.unused_size);
        }
        this.notifyAll();
    }

    protected synchronized void removeRPPoolManagerListener(RPPoolManagerListener listener) {
        this.pmListener = EventMulticaster.remove(this.pmListener, listener);
    }
}

