/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxr.extension;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.jaxr.JAXRConfiguration;
import org.jboss.as.jaxr.extension.JAXRPropertyDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class JAXRPropertyAdd
extends AbstractAddStepHandler {
    private final JAXRConfiguration config;

    public JAXRPropertyAdd(JAXRConfiguration config) {
        this.config = config;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        JAXRPropertyDefinition.VALUE.validateAndSet(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        String propertyName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        this.config.applyUpdateToConfig(propertyName, JAXRPropertyDefinition.VALUE.resolveModelAttribute(context, model).asString());
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, ModelNode model, List<ServiceController<?>> controllers) {
        String propertyName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        this.config.applyUpdateToConfig(propertyName, null);
    }
}

