/*
 * Decompiled with CFR 0.152.
 */
package io.escalante.io;

import io.escalante.io.Closeable$;
import io.escalante.io.FileSystem$$anonfun$copy$4$;
import io.escalante.logging.Log;
import io.escalante.logging.Log$class;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jboss.logging.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class FileSystem$
implements Log {
    public static final FileSystem$ MODULE$;
    private final Logger io$escalante$logging$Log$$log;
    private volatile boolean bitmap$0;

    static {
        new FileSystem$();
    }

    private Logger io$escalante$logging$Log$$log$lzycompute() {
        FileSystem$ fileSystem$ = this;
        synchronized (fileSystem$) {
            if (!this.bitmap$0) {
                this.io$escalante$logging$Log$$log = Log$class.io$escalante$logging$Log$$log(this);
                this.bitmap$0 = true;
            }
            return this.io$escalante$logging$Log$$log;
        }
    }

    @Override
    public Logger io$escalante$logging$Log$$log() {
        return this.bitmap$0 ? this.io$escalante$logging$Log$$log : this.io$escalante$logging$Log$$log$lzycompute();
    }

    @Override
    public void info(Function0<String> msg) {
        Log$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Object param1) {
        Log$class.info(this, msg, param1);
    }

    @Override
    public void info(Function0<String> msg, Object param1, Object param2) {
        Log$class.info(this, msg, param1, param2);
    }

    @Override
    public void info(Function0<String> msg, Object param1, Object param2, Object param3) {
        Log$class.info(this, msg, param1, param2, param3);
    }

    @Override
    public void warn(Function0<String> msg) {
        Log$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Object param1, Object param2, Object param3) {
        Log$class.warn(this, msg, param1, param2, param3);
    }

    @Override
    public void error(Function0<String> msg) {
        Log$class.error(this, msg);
    }

    @Override
    public void error(Throwable t, Function0<String> msg) {
        Log$class.error(this, t, msg);
    }

    @Override
    public void debug(Function0<String> msg) {
        Log$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Object param1) {
        Log$class.debug(this, msg, param1);
    }

    @Override
    public void debug(Function0<String> msg, Object param1, Object param2) {
        Log$class.debug((Log)this, msg, param1, param2);
    }

    @Override
    public void debug(Throwable t, Function0<String> msg, Object param1) {
        Log$class.debug((Log)this, t, msg, param1);
    }

    @Override
    public void trace(Function0<String> msg) {
        Log$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Object param1) {
        Log$class.trace(this, msg, param1);
    }

    public File mkDirs(File parent, String child) {
        return this.mkDirs(new File(parent, child), false);
    }

    public File mkDirs(File f, boolean deleteIfPresent) {
        if (deleteIfPresent & f.exists()) {
            this.deleteDirectory(f);
        }
        f.mkdirs();
        return f;
    }

    public File getTarget(Class<?> clazz) {
        try {
            return new File(new File(clazz.getProtectionDomain().getCodeSource().getLocation().toURI()).getParent());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException("Could not obtain the target URI", uRISyntaxException);
        }
    }

    public void copy(String srcPath, String destPath) {
        this.copy(new File(srcPath), new File(destPath));
    }

    public void copy(File src, File dest) {
        if (src.isDirectory()) {
            if (!dest.exists()) {
                dest.mkdir();
                this.debug((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Directory copied from %s to %s";
                    }
                }, src.getCanonicalPath(), (Object)dest.getCanonicalPath());
            }
            JavaConversions$.MODULE$.asScalaIterator(JavaConversions$.MODULE$.asJavaIterator(Predef$.MODULE$.refArrayOps((Object[])src.list()).iterator())).foreach((Function1)new Serializable(src, dest){
                public static final long serialVersionUID = 0L;
                private final File src$1;
                private final File dest$1;

                public final void apply(String file) {
                    FileSystem$.MODULE$.copy(new File(this.src$1, file), new File(this.dest$1, file));
                }
                {
                    this.src$1 = src$1;
                    this.dest$1 = dest$1;
                }
            });
        } else {
            this.copy(new FileInputStream(src), new FileOutputStream(dest));
            this.debug((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "File copied from %s to %s";
                }
            }, src.getCanonicalPath(), (Object)dest.getCanonicalPath());
        }
    }

    public void copy(InputStream in, OutputStream out) {
        Closeable$.MODULE$.use(in, new Serializable(out){
            public static final long serialVersionUID = 0L;
            private final OutputStream out$1;

            public final void apply(InputStream in) {
                Closeable$.MODULE$.use(this.out$1, new Serializable(this, in){
                    public static final long serialVersionUID = 0L;
                    public final InputStream in$1;

                    public final void apply(OutputStream out) {
                        byte[] buffer = new byte[1024];
                        package$.MODULE$.Iterator().continually((Function0)new Serializable(this, buffer){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$copy$4$$anonfun$apply$4 $outer;
                            private final byte[] buffer$1;

                            public final int apply() {
                                return this.apply$mcI$sp();
                            }

                            public int apply$mcI$sp() {
                                return this.$outer.in$1.read(this.buffer$1);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.buffer$1 = buffer$1;
                            }
                        }).takeWhile((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(int x$1) {
                                return this.apply$mcZI$sp(x$1);
                            }

                            public boolean apply$mcZI$sp(int x$1) {
                                return x$1 != -1;
                            }
                        }).foreach((Function1)new Serializable(this, out, buffer){
                            public static final long serialVersionUID = 0L;
                            private final OutputStream out$2;
                            private final byte[] buffer$1;

                            public final void apply(int x$2) {
                                this.apply$mcVI$sp(x$2);
                            }

                            public void apply$mcVI$sp(int x$2) {
                                this.out$2.write(this.buffer$1, 0, x$2);
                            }
                            {
                                this.out$2 = out$2;
                                this.buffer$1 = buffer$1;
                            }
                        });
                    }
                    {
                        this.in$1 = in$1;
                    }
                });
            }
            {
                this.out$1 = out$1;
            }
        });
    }

    public void deleteDirectory(File directory) {
        if (directory.isDirectory() && directory.exists()) {
            Predef$.MODULE$.refArrayOps((Object[])directory.listFiles()).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(File file) {
                    block4: {
                        block3: {
                            block2: {
                                if (!file.isDirectory()) break block2;
                                FileSystem$.MODULE$.deleteDirectory(file);
                                break block3;
                            }
                            if (!file.delete()) break block4;
                        }
                        return;
                    }
                    throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to delete file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file})));
                }
            });
            if (directory.delete()) {
                return;
            }
            throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to delete directory: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{directory})));
        }
        throw new RuntimeException(new StringOps(Predef$.MODULE$.augmentString("Unable to delete directory: %s.  It is either not a directory or does not exist.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{directory})));
    }

    public void deleteDirectoryIfPresent(File directory) {
        if (directory.exists()) {
            this.deleteDirectory(directory);
        }
    }

    public void unzip(File file, File target) {
        JarFile zip = new JarFile(file);
        JavaConversions$.MODULE$.enumerationAsScalaIterator(zip.entries()).foreach((Function1)new Serializable(target, zip){
            public static final long serialVersionUID = 0L;
            private final File target$1;
            private final JarFile zip$1;

            public final Object apply(JarEntry entry) {
                Boolean bl;
                String entryPath = entry.getName();
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Extracting to ").append((Object)this.target$1.getCanonicalPath()).append((Object)"/").append((Object)entryPath).toString());
                if (entry.isDirectory()) {
                    bl = BoxesRunTime.boxToBoolean((boolean)new File(this.target$1, entryPath).mkdirs());
                } else {
                    FileSystem$.MODULE$.copy(this.zip$1.getInputStream(entry), new FileOutputStream(new File(this.target$1, entryPath)));
                    bl = BoxedUnit.UNIT;
                }
                return bl;
            }
            {
                this.target$1 = target$1;
                this.zip$1 = zip$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public String fileToString(File file, String encoding) {
        FileInputStream inStream = new FileInputStream(file);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            boolean reading = true;
            block5: while (reading) {
                int n = inStream.read();
                switch (n) {
                    default: {
                        outStream.write(n);
                        continue block5;
                    }
                    case -1: 
                }
                reading = false;
            }
            outStream.flush();
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        inStream.close();
        return new String(outStream.toByteArray(), encoding);
    }

    public void printToFile(File f, Function1<PrintWriter, BoxedUnit> op) {
        PrintWriter p = new PrintWriter(f);
        try {
            op.apply((Object)p);
            return;
        }
        finally {
            p.close();
        }
    }

    public boolean deleteIfPresent(File f) {
        return f.exists() ? f.delete() : false;
    }

    public Option<File> findFirst(File directory, Regex regex) {
        return this.findAll(directory, regex).headOption();
    }

    public Seq<File> findAll(File directory, Regex regex) {
        return Predef$.MODULE$.wrapRefArray((Object[])directory.listFiles(new FilenameFilter(regex){
            private final Regex regex$1;

            public boolean accept(File dir, String name) {
                return this.regex$1.findFirstIn((CharSequence)name).isDefined();
            }
            {
                this.regex$1 = regex$1;
            }
        }));
    }

    private FileSystem$() {
        MODULE$ = this;
        Log$class.$init$(this);
    }
}

