/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deploymentoverlay.service;

import java.util.regex.Pattern;
import org.jboss.as.server.deploymentoverlay.service.DeploymentOverlayIndexService;
import org.jboss.as.server.deploymentoverlay.service.DeploymentOverlayPriority;
import org.jboss.as.server.deploymentoverlay.service.DeploymentOverlayService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class DeploymentOverlayLinkService
implements Service<DeploymentOverlayLinkService> {
    public static final ServiceName SERVICE_NAME = DeploymentOverlayIndexService.SERVICE_NAME.append(new String[]{"deploymentOverlayLinkService"});
    private final InjectedValue<DeploymentOverlayIndexService> deploymentOverlayIndexServiceInjectedValue = new InjectedValue();
    private final InjectedValue<DeploymentOverlayService> deploymentOverlayServiceInjectedValue = new InjectedValue();
    private final String deployment;
    private final DeploymentOverlayPriority priority;
    private final Pattern pattern;
    private final boolean wildcard;

    private static String wildcardToJavaRegexp(String expr) {
        if (expr == null) {
            throw new IllegalArgumentException("expr is null");
        }
        String regex = expr.replaceAll("([(){}\\[\\].+^$])", "\\\\$1");
        regex = regex.replaceAll("\\*", ".*");
        regex = regex.replaceAll("\\?", ".");
        return regex;
    }

    public DeploymentOverlayLinkService(String deployment, DeploymentOverlayPriority priority) {
        this.deployment = deployment;
        this.priority = priority;
        this.pattern = Pattern.compile(DeploymentOverlayLinkService.wildcardToJavaRegexp(deployment));
        this.wildcard = deployment.contains("*") || deployment.contains("?");
    }

    public void start(StartContext context) throws StartException {
        ((DeploymentOverlayIndexService)this.deploymentOverlayIndexServiceInjectedValue.getValue()).addService(this);
    }

    public void stop(StopContext context) {
        ((DeploymentOverlayIndexService)this.deploymentOverlayIndexServiceInjectedValue.getValue()).removeService(this);
    }

    public DeploymentOverlayLinkService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<DeploymentOverlayIndexService> getDeploymentOverlayIndexServiceInjectedValue() {
        return this.deploymentOverlayIndexServiceInjectedValue;
    }

    public InjectedValue<DeploymentOverlayService> getDeploymentOverlayServiceInjectedValue() {
        return this.deploymentOverlayServiceInjectedValue;
    }

    public DeploymentOverlayPriority getPriority() {
        return this.priority;
    }

    public String getDeployment() {
        return this.deployment;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public boolean isWildcard() {
        return this.wildcard;
    }
}

