/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.apt;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.jboss.logging.processor.Tools;
import org.jboss.logging.processor.apt.Annotations;
import org.jboss.logging.processor.apt.ParameterFactory;
import org.jboss.logging.processor.apt.ReturnTypeFactory;
import org.jboss.logging.processor.apt.ThrowableTypeFactory;
import org.jboss.logging.processor.model.MessageMethod;
import org.jboss.logging.processor.model.Parameter;
import org.jboss.logging.processor.model.ReturnType;
import org.jboss.logging.processor.model.ThrowableType;
import org.jboss.logging.processor.util.ElementHelper;
import org.jboss.logging.processor.util.Objects;

final class MessageMethodBuilder {
    private static final String MESSAGE_METHOD_SUFFIX = "$str";
    private final Annotations annotations = Tools.annotations();
    private final List<ExecutableElement> methods;
    private final Elements elements;
    private final Types types;

    private MessageMethodBuilder(Elements elements, Types types) {
        this.elements = elements;
        this.types = types;
        this.methods = new LinkedList<ExecutableElement>();
    }

    static MessageMethodBuilder create(Elements elements, Types types) {
        return new MessageMethodBuilder(elements, types);
    }

    MessageMethodBuilder add(ExecutableElement method) {
        this.methods.add(method);
        return this;
    }

    Set<MessageMethod> build() {
        LinkedHashSet<AptMessageMethod> result = new LinkedHashSet<AptMessageMethod>();
        for (ExecutableElement elementMethod : this.methods) {
            AptMessageMethod resultMethod = new AptMessageMethod(this.elements, elementMethod, this.annotations);
            resultMethod.inheritsMessage = ElementHelper.inheritsMessage(this.methods, elementMethod);
            resultMethod.message = this.findMessage(this.methods, elementMethod);
            resultMethod.isOverloaded = ElementHelper.isOverloaded(this.methods, elementMethod);
            for (TypeMirror typeMirror : elementMethod.getThrownTypes()) {
                resultMethod.thrownTypes.add(ThrowableTypeFactory.of(this.elements, this.types, typeMirror));
            }
            for (Parameter parameter : ParameterFactory.of(this.elements, this.types, resultMethod.method)) {
                resultMethod.add(parameter);
            }
            if (resultMethod.isOverloaded()) {
                resultMethod.messageMethodName = resultMethod.name() + resultMethod.formatParameterCount() + MESSAGE_METHOD_SUFFIX;
                resultMethod.translationKey = resultMethod.name() + "." + resultMethod.formatParameterCount();
            } else {
                resultMethod.messageMethodName = resultMethod.name() + MESSAGE_METHOD_SUFFIX;
                resultMethod.translationKey = resultMethod.name();
            }
            resultMethod.returnType = ReturnTypeFactory.of(this.elements, this.types, elementMethod.getReturnType(), resultMethod);
            result.add(resultMethod);
        }
        return Collections.unmodifiableSet(result);
    }

    private MessageMethod.Message findMessage(Collection<ExecutableElement> methods, ExecutableElement method) {
        AptMessage result;
        block4: {
            block2: {
                block3: {
                    result = null;
                    if (!this.annotations.hasMessageAnnotation(method)) break block2;
                    result = new AptMessage();
                    result.hasId = this.annotations.hasMessageId(method);
                    result.value = this.annotations.messageValue(method);
                    result.formatType = this.annotations.messageFormat(method);
                    result.inheritsId = this.annotations.inheritsMessageId(method);
                    if (!result.inheritsId()) break block3;
                    result.id = this.findMessageId(methods, method);
                    if (result.id <= 0) break block4;
                    result.hasId = true;
                    break block4;
                }
                result.id = this.annotations.messageId(method);
                break block4;
            }
            Collection<ExecutableElement> allMethods = ElementHelper.findByName(methods, method.getSimpleName(), ElementHelper.parameterCount(method.getParameters()));
            for (ExecutableElement m : allMethods) {
                if (!this.annotations.hasMessageAnnotation(m)) continue;
                result = new AptMessage();
                result.hasId = this.annotations.hasMessageId(m);
                result.value = this.annotations.messageValue(m);
                result.formatType = this.annotations.messageFormat(m);
                result.inheritsId = this.annotations.inheritsMessageId(m);
                if (result.inheritsId()) {
                    result.id = this.findMessageId(methods, m);
                    if (result.id <= 0) break;
                    result.hasId = true;
                    break;
                }
                result.id = this.annotations.messageId(m);
                break;
            }
        }
        return result;
    }

    private int findMessageId(Collection<ExecutableElement> methods, ExecutableElement method) {
        int result = -2;
        Collection<ExecutableElement> allMethods = ElementHelper.findByName(methods, method.getSimpleName());
        for (ExecutableElement m : allMethods) {
            if (!this.annotations.hasMessageAnnotation(m) || this.annotations.inheritsMessageId(m)) continue;
            result = this.annotations.messageId(m);
        }
        return result;
    }

    private static class AptMessage
    implements MessageMethod.Message {
        private boolean hasId;
        private int id;
        private boolean inheritsId;
        private String value;
        private Annotations.FormatType formatType;

        private AptMessage() {
        }

        @Override
        public int id() {
            return this.id;
        }

        @Override
        public boolean hasId() {
            return this.hasId;
        }

        @Override
        public boolean inheritsId() {
            return this.inheritsId;
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public Annotations.FormatType format() {
            return this.formatType;
        }

        public String toString() {
            return Objects.ToStringBuilder.of(this).add("hasId", this.hasId).add("id", this.id).add("inheritsId", this.inheritsId).add("value", this.value).add("formatType", (Object)this.formatType).toString();
        }
    }

    private static class AptMessageMethod
    implements MessageMethod {
        private final Annotations annotations;
        private final Elements elements;
        private ReturnType returnType;
        private Parameter cause;
        private boolean inheritsMessage;
        private boolean isOverloaded;
        private MessageMethod.Message message;
        private final Map<Parameter.ParameterType, Set<Parameter>> parameters;
        private final Set<ThrowableType> thrownTypes;
        private String messageMethodName;
        private final ExecutableElement method;
        private String translationKey;

        AptMessageMethod(Elements elements, ExecutableElement method, Annotations annotations) {
            this.annotations = annotations;
            this.elements = elements;
            this.method = method;
            this.inheritsMessage = false;
            this.isOverloaded = false;
            this.parameters = new EnumMap<Parameter.ParameterType, Set<Parameter>>(Parameter.ParameterType.class);
            this.thrownTypes = new LinkedHashSet<ThrowableType>();
        }

        void add(Parameter parameter) {
            if (this.parameters.containsKey((Object)Parameter.ParameterType.ANY)) {
                this.parameters.get((Object)Parameter.ParameterType.ANY).add(parameter);
            } else {
                LinkedHashSet<Parameter> any = new LinkedHashSet<Parameter>();
                any.add(parameter);
                this.parameters.put(Parameter.ParameterType.ANY, any);
            }
            if (this.parameters.containsKey((Object)parameter.parameterType())) {
                this.parameters.get((Object)parameter.parameterType()).add(parameter);
            } else {
                LinkedHashSet<Parameter> set = new LinkedHashSet<Parameter>();
                set.add(parameter);
                this.parameters.put(parameter.parameterType(), set);
            }
            if (parameter.parameterType() == Parameter.ParameterType.CAUSE) {
                this.cause = parameter;
            }
        }

        @Override
        public MessageMethod.Message message() {
            return this.message;
        }

        @Override
        public boolean inheritsMessage() {
            return this.inheritsMessage;
        }

        @Override
        public String messageMethodName() {
            return this.messageMethodName;
        }

        @Override
        public String translationKey() {
            return this.translationKey;
        }

        @Override
        public String name() {
            return this.method.getSimpleName().toString();
        }

        @Override
        public Set<Parameter> parameters(Parameter.ParameterType parameterType) {
            if (this.parameters.containsKey((Object)parameterType)) {
                return this.parameters.get((Object)parameterType);
            }
            return Collections.emptySet();
        }

        @Override
        public boolean hasCause() {
            return this.cause != null;
        }

        @Override
        public boolean isOverloaded() {
            return this.isOverloaded;
        }

        @Override
        public Parameter cause() {
            return this.cause;
        }

        @Override
        public ReturnType returnType() {
            return this.returnType;
        }

        @Override
        public String loggerMethod() {
            return this.annotations.loggerMethod(this.message.format());
        }

        @Override
        public String logLevel() {
            return this.annotations.logLevel(this.method);
        }

        @Override
        public int formatParameterCount() {
            if (this.parameters.containsKey((Object)Parameter.ParameterType.FORMAT)) {
                return this.parameters.get((Object)Parameter.ParameterType.FORMAT).size();
            }
            return 0;
        }

        @Override
        public boolean isLoggerMethod() {
            return this.annotations.isLoggerMethod(this.method);
        }

        @Override
        public Set<ThrowableType> thrownTypes() {
            return Collections.unmodifiableSet(this.thrownTypes);
        }

        public int hashCode() {
            return Objects.HashCodeBuilder.builder().add(this.name()).add(this.parameters(Parameter.ParameterType.ANY)).add(this.returnType()).toHashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof AptMessageMethod)) {
                return false;
            }
            AptMessageMethod other = (AptMessageMethod)obj;
            return Objects.areEqual(this.name(), other.name()) && Objects.areEqual(this.parameters, this.parameters) && Objects.areEqual(this.returnType, other.returnType);
        }

        public String toString() {
            return Objects.ToStringBuilder.of(this).add("name", this.name()).add("returnType", this.returnType()).add("parameters", this.parameters(Parameter.ParameterType.ANY)).add("loggerMethod", this.loggerMethod()).toString();
        }

        @Override
        public ExecutableElement reference() {
            return this.method;
        }

        @Override
        public int compareTo(MessageMethod o) {
            int result = this.name().compareTo(o.name());
            result = result != 0 ? result : this.returnType.name().compareTo(o.returnType().name());
            int n = result = result != 0 ? result : this.parameters(Parameter.ParameterType.ANY).size() - o.parameters(Parameter.ParameterType.ANY).size();
            if (result == 0) {
                Iterator<Parameter> params1 = this.parameters(Parameter.ParameterType.ANY).iterator();
                Iterator<Parameter> params2 = o.parameters(Parameter.ParameterType.ANY).iterator();
                while (params1.hasNext()) {
                    if (params2.hasNext()) {
                        Parameter param1 = params1.next();
                        Parameter param2 = params2.next();
                        result = param1.compareTo(param2);
                    } else {
                        result = 1;
                    }
                    if (result == 0) continue;
                    break;
                }
            }
            return result;
        }

        @Override
        public String getComment() {
            return this.elements.getDocComment(this.method);
        }
    }
}

