/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.generator.model;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.processor.generator.model.ClassModel;
import org.jboss.logging.processor.generator.model.ClassModelHelper;
import org.jboss.logging.processor.model.MessageInterface;
import org.jboss.logging.processor.model.MessageMethod;
import org.jboss.logging.processor.model.Parameter;
import org.jboss.logging.processor.model.ThrowableType;

abstract class ImplementationClassModel
extends ClassModel {
    ImplementationClassModel(MessageInterface messageInterface) {
        super(messageInterface, ClassModelHelper.implementationClassName(messageInterface), null);
    }

    @Override
    protected JCodeModel generateModel() throws IllegalStateException {
        JCodeModel codeModel = super.generateModel();
        this.getDefinedClass()._implements(codeModel.directClass(Serializable.class.getName()));
        JFieldVar serialVersionUID = this.getDefinedClass().field(28, codeModel.LONG, "serialVersionUID");
        serialVersionUID.init(JExpr.lit(1L));
        return codeModel;
    }

    void createBundleMethod(MessageMethod messageMethod, JMethod method, JMethod msgMethod) {
        JInvocation expression;
        JInvocation formatterMethod;
        this.addThrownTypes(messageMethod, method);
        JBlock body = method.body();
        JClass returnField = this.getCodeModel().directClass(method.type().fullName());
        JVar result = body.decl(returnField, "result");
        MessageMethod.Message message = messageMethod.message();
        boolean noFormatParameters = messageMethod.parameters(Parameter.ParameterType.FORMAT).isEmpty();
        switch (message.format()) {
            case MESSAGE_FORMAT: {
                JClass formatter = this.getCodeModel().directClass(message.format().formatClass().getName());
                formatterMethod = formatter.staticInvoke(message.format().staticMethod());
                if (noFormatParameters) {
                    expression = JExpr.invoke(msgMethod);
                    break;
                }
                formatterMethod.arg(JExpr.invoke(msgMethod));
                expression = formatterMethod;
                break;
            }
            case PRINTF: {
                JClass formatter = this.getCodeModel().directClass(message.format().formatClass().getName());
                expression = formatterMethod = formatter.staticInvoke(message.format().staticMethod()).arg(JExpr.invoke(msgMethod));
                break;
            }
            default: {
                formatterMethod = null;
                expression = JExpr.invoke(msgMethod);
            }
        }
        HashMap<String, JVar> fields = new HashMap<String, JVar>();
        HashMap<String, JVar> properties = new HashMap<String, JVar>();
        for (Parameter parameter : messageMethod.parameters(Parameter.ParameterType.ANY)) {
            JClass paramType = this.getCodeModel().directClass(parameter.type());
            JVar var = method.param(8, paramType, parameter.name());
            String formatterClass = parameter.formatterClass();
            switch (parameter.parameterType()) {
                case FORMAT: {
                    if (formatterMethod == null) {
                        throw new IllegalStateException("No format parameters are allowed when NO_FORMAT is specified.");
                    }
                    if (formatterClass == null) {
                        formatterMethod.arg(var);
                        break;
                    }
                    formatterMethod.arg(JExpr._new(this.getCodeModel().directClass(formatterClass)).arg(var));
                    break;
                }
                case FIELD: {
                    fields.put(parameter.targetName(), var);
                    break;
                }
                case PROPERTY: {
                    properties.put(parameter.targetName(), var);
                }
            }
        }
        if (messageMethod.returnType().isThrowable()) {
            this.initCause(result, returnField, body, messageMethod, expression);
        } else {
            result.init(expression);
        }
        for (Map.Entry entry : fields.entrySet()) {
            body.assign(result.ref((String)entry.getKey()), (JExpression)entry.getValue());
        }
        for (Map.Entry entry : properties.entrySet()) {
            body.add(result.invoke((String)entry.getKey()).arg((JExpression)entry.getValue()));
        }
        body._return(result);
    }

    private void initCause(JVar result, JClass returnField, JBlock body, MessageMethod messageMethod, JExpression format) {
        JInvocation initCause;
        ThrowableType returnType = messageMethod.returnType().throwableReturnType();
        if (returnType.useConstructionParameters()) {
            JInvocation invocation = JExpr._new(returnField);
            block3: for (Parameter param : returnType.constructionParameters()) {
                switch (param.parameterType()) {
                    case MESSAGE: {
                        invocation.arg(format);
                        continue block3;
                    }
                }
                invocation.arg(JExpr.ref(param.name()));
            }
            result.init(invocation);
        } else if (returnType.hasStringAndThrowableConstructor() && messageMethod.hasCause()) {
            result.init(JExpr._new(returnField).arg(format).arg(JExpr.ref(messageMethod.cause().name())));
        } else if (returnType.hasThrowableAndStringConstructor() && messageMethod.hasCause()) {
            result.init(JExpr._new(returnField).arg(JExpr.ref(messageMethod.cause().name())).arg(format));
        } else if (returnType.hasStringConstructor()) {
            result.init(JExpr._new(returnField).arg(format));
            if (messageMethod.hasCause()) {
                initCause = body.invoke((JExpression)result, "initCause");
                initCause.arg(JExpr.ref(messageMethod.cause().name()));
            }
        } else if (returnType.hasThrowableConstructor() && messageMethod.hasCause()) {
            result.init(JExpr._new(returnField).arg(JExpr.ref(messageMethod.cause().name())));
        } else if (returnType.hasStringAndThrowableConstructor() && !messageMethod.hasCause()) {
            result.init(JExpr._new(returnField).arg(format).arg(JExpr._null()));
        } else if (returnType.hasThrowableAndStringConstructor() && !messageMethod.hasCause()) {
            result.init(JExpr._new(returnField).arg(JExpr._null()).arg(format));
        } else if (messageMethod.hasCause()) {
            result.init(JExpr._new(returnField));
            initCause = body.invoke((JExpression)result, "initCause");
            initCause.arg(JExpr.ref(messageMethod.cause().name()));
        } else {
            result.init(JExpr._new(returnField));
        }
        JClass arrays = this.getCodeModel().directClass(Arrays.class.getName());
        JClass stClass = this.getCodeModel().directClass(StackTraceElement.class.getName()).array();
        JVar st = body.decl(stClass, "st").init(result.invoke("getStackTrace"));
        JInvocation setStackTrace = result.invoke("setStackTrace");
        setStackTrace.arg(arrays.staticInvoke("copyOfRange").arg(st).arg(JExpr.lit(1)).arg(st.ref("length")));
        body.add(setStackTrace);
    }

    protected final void addThrownTypes(MessageMethod messageMethod, JMethod jMethod) {
        for (ThrowableType thrownType : messageMethod.thrownTypes()) {
            jMethod._throws(this.getCodeModel().directClass(thrownType.name()));
        }
    }
}

