/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remotingjmx.protocol;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.management.remote.JMXServiceURL;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Channel;
import org.jboss.remotingjmx.Capability;
import org.jboss.remotingjmx.MBeanServerManager;
import org.jboss.remotingjmx.VersionedConnection;
import org.jboss.remotingjmx.protocol.v1.VersionOne;
import org.jboss.remotingjmx.protocol.v2.VersionTwo;

public class Versions {
    private static final Logger log = Logger.getLogger(Versions.class);
    private final Map<String, ?> environment;
    private final Map<Byte, Set<Capability>> supportedVersions;

    public Versions(Map<String, ?> environment) {
        this.environment = environment;
        HashMap<Byte, Set<Capability>> supportedVersions = new HashMap<Byte, Set<Capability>>();
        supportedVersions.put(VersionOne.getVersionIdentifier(), VersionOne.getCapabilites());
        supportedVersions.put(VersionTwo.getVersionIdentifier(), VersionTwo.getCapabilities());
        for (Byte current : this.getExcludedVersions()) {
            supportedVersions.remove(current);
        }
        this.supportedVersions = Collections.unmodifiableMap(supportedVersions);
    }

    private Set<Byte> getExcludedVersions() {
        Object list;
        HashSet<Byte> excluded = new HashSet<Byte>();
        if (this.environment != null && this.environment.containsKey("org.jboss.remoting-jmx.excluded-versions") && (list = this.environment.get("org.jboss.remoting-jmx.excluded-versions")) != null) {
            if (list instanceof String) {
                this.split((String)list, excluded);
            } else {
                log.warnf("Ignoring excluded versions list of type '%s'", (Object)list.getClass().getName());
            }
        }
        this.split(System.getProperty("org.jboss.remoting-jmx.excluded-versions", ""), excluded);
        return excluded;
    }

    private void split(String from, Set<Byte> to) {
        String[] values;
        for (String current : values = from.split(",")) {
            try {
                String temp = current.trim();
                if (temp.length() <= 0) continue;
                to.add(Byte.valueOf(current.trim()));
            }
            catch (NumberFormatException e) {
                log.warnf("Unrecognised version '%s' in list.", (Object)current);
            }
        }
    }

    public Set<Byte> getSupportedVersions(Capability ... capabilities) {
        if (capabilities.length > 0) {
            HashSet<Byte> filteredSupported = new HashSet<Byte>(this.supportedVersions.keySet());
            for (Byte current : this.supportedVersions.keySet()) {
                Set<Capability> currentCapabilities = this.supportedVersions.get(current);
                for (Capability toCheck : capabilities) {
                    if (currentCapabilities.contains((Object)toCheck)) continue;
                    filteredSupported.remove(current);
                }
            }
            return filteredSupported;
        }
        return this.supportedVersions.keySet();
    }

    public VersionedConnection getVersionedConnection(byte version, Channel channel, JMXServiceURL serviceURL) throws IOException {
        if (this.supportedVersions.containsKey(version)) {
            if (version == VersionOne.getVersionIdentifier()) {
                return VersionOne.getConnection(channel, this.environment);
            }
            if (version == VersionTwo.getVersionIdentifier()) {
                return VersionTwo.getConnection(channel, this.environment, serviceURL);
            }
        } else {
            log.warnf("An attempt has been made to select an unsupported version 0x0%d", (Object)version);
        }
        throw new IllegalArgumentException("Unsupported protocol version.");
    }

    public void startServer(byte version, Channel channel, MBeanServerManager serverManager, Executor executor) throws IOException {
        if (this.supportedVersions.containsKey(version)) {
            if (version == VersionOne.getVersionIdentifier()) {
                VersionOne.startServer(channel, serverManager.getDefaultMBeanServer(), executor);
            } else if (version == VersionTwo.getVersionIdentifier()) {
                VersionTwo.startServer(channel, serverManager, executor);
            }
            return;
        }
        log.warnf("An attempt has been made to select an unsupported version 0x0%d", (Object)version);
        throw new IllegalArgumentException("Unsupported protocol version.");
    }
}

