/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.commons.hash.Hash;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.ReplicatedConsistentHash;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.remoting.transport.Address;

public class ReplicatedConsistentHashFactory
implements ConsistentHashFactory<ReplicatedConsistentHash> {
    @Override
    public ReplicatedConsistentHash create(Hash hashFunction, int numOwners, int numSegments, List<Address> members) {
        return new ReplicatedConsistentHash(members);
    }

    @Override
    public ReplicatedConsistentHash updateMembers(ReplicatedConsistentHash baseCH, List<Address> newMembers) {
        if (((Object)newMembers).equals(baseCH.getMembers())) {
            return baseCH;
        }
        return new ReplicatedConsistentHash(newMembers);
    }

    @Override
    public ReplicatedConsistentHash rebalance(ReplicatedConsistentHash baseCH) {
        return baseCH;
    }

    @Override
    public ReplicatedConsistentHash union(ReplicatedConsistentHash ch1, ReplicatedConsistentHash ch2) {
        HashSet<Address> membersUnion = new HashSet<Address>(ch1.getMembers().size() + ch2.getMembers().size());
        membersUnion.addAll(ch1.getMembers());
        membersUnion.addAll(ch2.getMembers());
        return new ReplicatedConsistentHash(new ArrayList<Address>(membersUnion));
    }

    public static class Externalizer
    extends AbstractExternalizer<ReplicatedConsistentHashFactory> {
        @Override
        public void writeObject(ObjectOutput output, ReplicatedConsistentHashFactory chf) throws IOException {
        }

        @Override
        public ReplicatedConsistentHashFactory readObject(ObjectInput unmarshaller) throws IOException, ClassNotFoundException {
            return new ReplicatedConsistentHashFactory();
        }

        @Override
        public Integer getId() {
            return 92;
        }

        @Override
        public Set<Class<? extends ReplicatedConsistentHashFactory>> getTypeClasses() {
            return Collections.singleton(ReplicatedConsistentHashFactory.class);
        }
    }
}

