/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.security;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ee.component.serialization.WriteReplaceInterface;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.EJBViewDescription;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.deployment.ApplicableMethodInformation;
import org.jboss.as.ejb3.security.AuthorizationInterceptor;
import org.jboss.as.ejb3.security.EJBMethodSecurityAttribute;
import org.jboss.as.ejb3.security.SecurityContextInterceptorFactory;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndexUtil;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;

public class EJBSecurityViewConfigurator
implements ViewConfigurator {
    public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription viewDescription, ViewConfiguration viewConfiguration) throws DeploymentUnitProcessingException {
        if (!(componentConfiguration.getComponentDescription() instanceof EJBComponentDescription)) {
            throw EjbMessages.MESSAGES.invalidEjbComponent(componentConfiguration.getComponentName(), componentConfiguration.getComponentClass());
        }
        DeploymentReflectionIndex deploymentReflectionIndex = (DeploymentReflectionIndex)context.getDeploymentUnit().getAttachment(Attachments.REFLECTION_INDEX);
        EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)componentConfiguration.getComponentDescription();
        if (ejbComponentDescription.getSecurityDomain() == null) {
            EjbLogger.ROOT_LOGGER.debug("Security is *not* enabled on EJB: " + ejbComponentDescription.getEJBName() + ", since no explicit security domain is configured for the bean, nor is there any default security domain configured in the EJB3 subsystem");
            return;
        }
        String viewClassName = viewDescription.getViewClassName();
        EJBViewDescription ejbViewDescription = (EJBViewDescription)viewDescription;
        DeploymentUnit deploymentUnit = context.getDeploymentUnit();
        String contextID = deploymentUnit.getName();
        if (deploymentUnit.getParent() != null) {
            contextID = deploymentUnit.getParent().getName() + "!" + contextID;
        }
        boolean beanHasMethodLevelSecurityMetadata = false;
        List viewMethods = viewConfiguration.getProxyFactory().getCachedMethods();
        for (Method viewMethod : viewMethods) {
            if (!Modifier.isPublic(viewMethod.getModifiers()) || viewMethod.getDeclaringClass() == WriteReplaceInterface.class) continue;
            ApplicableMethodInformation<EJBMethodSecurityAttribute> permissions = ejbComponentDescription.getDescriptorMethodPermissions();
            boolean methodHasSecurityMetadata = this.handlePermissions(contextID, componentConfiguration, viewConfiguration, deploymentReflectionIndex, viewClassName, ejbViewDescription, viewMethod, permissions, false);
            if (!methodHasSecurityMetadata) {
                methodHasSecurityMetadata = this.handlePermissions(contextID, componentConfiguration, viewConfiguration, deploymentReflectionIndex, viewClassName, ejbViewDescription, viewMethod, ejbComponentDescription.getAnnotationMethodPermissions(), true);
            }
            if (!methodHasSecurityMetadata) continue;
            beanHasMethodLevelSecurityMetadata = true;
        }
        if (!beanHasMethodLevelSecurityMetadata && !this.hasSecurityMetaData(ejbComponentDescription)) {
            EjbLogger.ROOT_LOGGER.debug("Security is *not* enabled on EJB: " + ejbComponentDescription.getEJBName() + ", no security interceptors will apply");
            return;
        }
        viewConfiguration.addViewInterceptor((InterceptorFactory)new SecurityContextInterceptorFactory(), 592);
    }

    private boolean handlePermissions(String contextID, ComponentConfiguration componentConfiguration, ViewConfiguration viewConfiguration, DeploymentReflectionIndex deploymentReflectionIndex, String viewClassName, EJBViewDescription ejbViewDescription, Method viewMethod, ApplicableMethodInformation<EJBMethodSecurityAttribute> permissions, boolean annotations) {
        EJBMethodSecurityAttribute ejbMethodSecurityMetaData = permissions.getViewAttribute(ejbViewDescription.getMethodIntf(), viewMethod.getName(), MethodIdentifier.getIdentifierForMethod((Method)viewMethod).getParameterTypes());
        ArrayList<EJBMethodSecurityAttribute> allAttributes = new ArrayList<EJBMethodSecurityAttribute>();
        allAttributes.addAll(permissions.getAllAttributes(ejbViewDescription.getMethodIntf(), viewMethod.getDeclaringClass().getName(), viewMethod.getName(), MethodIdentifier.getIdentifierForMethod((Method)viewMethod).getParameterTypes()));
        if (ejbMethodSecurityMetaData == null) {
            ejbMethodSecurityMetaData = permissions.getViewAttribute(MethodIntf.BEAN, viewMethod.getName(), MethodIdentifier.getIdentifierForMethod((Method)viewMethod).getParameterTypes());
        }
        allAttributes.addAll(permissions.getAllAttributes(MethodIntf.BEAN, viewMethod.getDeclaringClass().getName(), viewMethod.getName(), MethodIdentifier.getIdentifierForMethod((Method)viewMethod).getParameterTypes()));
        Method classMethod = ClassReflectionIndexUtil.findMethod((DeploymentReflectionIndex)deploymentReflectionIndex, (Class)componentConfiguration.getComponentClass(), (Method)viewMethod);
        if (ejbMethodSecurityMetaData == null && classMethod != null && (ejbMethodSecurityMetaData = permissions.getAttribute(ejbViewDescription.getMethodIntf(), classMethod.getDeclaringClass().getName(), classMethod.getName(), MethodIdentifier.getIdentifierForMethod((Method)classMethod).getParameterTypes())) == null) {
            ejbMethodSecurityMetaData = permissions.getAttribute(MethodIntf.BEAN, classMethod.getDeclaringClass().getName(), classMethod.getName(), MethodIdentifier.getIdentifierForMethod((Method)classMethod).getParameterTypes());
        }
        if (classMethod != null) {
            allAttributes.addAll(permissions.getAllAttributes(ejbViewDescription.getMethodIntf(), classMethod.getDeclaringClass().getName(), classMethod.getName(), MethodIdentifier.getIdentifierForMethod((Method)classMethod).getParameterTypes()));
            allAttributes.addAll(permissions.getAllAttributes(MethodIntf.BEAN, classMethod.getDeclaringClass().getName(), classMethod.getName(), MethodIdentifier.getIdentifierForMethod((Method)classMethod).getParameterTypes()));
        }
        if (ejbMethodSecurityMetaData != null) {
            if (!(annotations || ejbMethodSecurityMetaData.isDenyAll() || ejbMethodSecurityMetaData.isPermitAll())) {
                HashSet<String> rolesAllowed = new HashSet<String>();
                for (EJBMethodSecurityAttribute attr : allAttributes) {
                    rolesAllowed.addAll(attr.getRolesAllowed());
                }
                ejbMethodSecurityMetaData = EJBMethodSecurityAttribute.rolesAllowed(rolesAllowed);
            }
            AuthorizationInterceptor authorizationInterceptor = new AuthorizationInterceptor(ejbMethodSecurityMetaData, viewClassName, viewMethod, contextID);
            viewConfiguration.addViewInterceptor(viewMethod, (InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)authorizationInterceptor), 768);
            return true;
        }
        return false;
    }

    private boolean hasSecurityMetaData(EJBComponentDescription ejbComponentDescription) {
        if (ejbComponentDescription.isExplicitSecurityDomainConfigured()) {
            return true;
        }
        if (ejbComponentDescription.getRunAs() != null) {
            return true;
        }
        if (ejbComponentDescription.getRunAsPrincipal() != null) {
            return true;
        }
        SecurityRolesMetaData securityRoles = ejbComponentDescription.getSecurityRoles();
        if (securityRoles != null && !securityRoles.isEmpty()) {
            return true;
        }
        Map<String, Collection<String>> securityRoleLinks = ejbComponentDescription.getSecurityRoleLinks();
        if (securityRoleLinks != null && !securityRoleLinks.isEmpty()) {
            return true;
        }
        Set<String> declaredRoles = ejbComponentDescription.getDeclaredRoles();
        return declaredRoles != null && !declaredRoles.isEmpty();
    }
}

