/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.connections.ldap;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionAddHandler;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionManagerService;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class LdapConnectionWriteAttributeHandler
extends AbstractWriteAttributeHandler<Void> {
    public LdapConnectionWriteAttributeHandler() {
        super(LdapConnectionResourceDefinition.ATTRIBUTE_DEFINITIONS);
    }

    void registerAttributes(ManagementResourceRegistration registration) {
        for (AttributeDefinition attr : LdapConnectionResourceDefinition.ATTRIBUTE_DEFINITIONS) {
            registration.registerReadWriteAttribute(attr, null, (OperationStepHandler)this);
        }
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        this.updateLdapConnectionService(context, operation, model);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        ModelNode restored = context.readResource(PathAddress.EMPTY_ADDRESS).getModel().clone();
        restored.get(attributeName).set(valueToRestore);
        this.updateLdapConnectionService(context, operation, restored);
    }

    private void updateLdapConnectionService(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String name = address.getLastElement().getValue();
        ServiceName svcName = LdapConnectionManagerService.BASE_SERVICE_NAME.append(new String[]{name});
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController controller = registry.getService(svcName);
        if (controller != null) {
            ModelNode resolvedConfig = LdapConnectionAddHandler.createResolvedLdapConfiguration(context, model);
            LdapConnectionManagerService service = (LdapConnectionManagerService)LdapConnectionManagerService.class.cast(controller.getValue());
            service.setResolvedConfiguration(resolvedConfig);
        }
    }
}

