/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.password;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.security.password.Keyboard;
import org.jboss.as.domain.management.security.password.PasswordCheckResult;
import org.jboss.as.domain.management.security.password.PasswordRestriction;
import org.jboss.as.domain.management.security.password.PasswordStrength;
import org.jboss.as.domain.management.security.password.PasswordStrengthCheckResult;
import org.jboss.as.domain.management.security.password.PasswordStrengthChecker;
import org.jboss.as.domain.management.security.password.ValueRestriction;
import org.jboss.as.domain.management.security.password.simple.SimplePasswordStrengthChecker;

public class PasswordCheckUtil {
    public static final String _PROPERTY_CHECKER = "checker";
    public static final String _PROPERTY_STRENGTH = "strength";
    public static final String _PROPERTY_FORBIDDEN = "forbidden";
    public static final PasswordCheckUtil INSTANCE = new PasswordCheckUtil();
    private PasswordStrengthChecker passwordStrengthChecker;
    private PasswordStrength acceptable = PasswordStrength.MODERATE;
    private List<PasswordRestriction> passwordValuesRestrictions = new ArrayList<PasswordRestriction>();

    private PasswordCheckUtil() {
        InputStream is = Keyboard.class.getResourceAsStream("utility.properties");
        if (is != null) {
            this.init(is);
        } else {
            this.simple();
        }
    }

    private void simple() {
        this.passwordStrengthChecker = new SimplePasswordStrengthChecker();
    }

    private void init(InputStream is) {
        try {
            Properties props = new Properties();
            props.load(is);
            this.initDefaultStrength(props);
            this.initStrengthChecker(props);
            this.initPasswordRestrictions(props);
        }
        catch (Exception e) {
            this.simple();
        }
    }

    private void initPasswordRestrictions(Properties props) {
        try {
            String[] values;
            String forbiddens = props.getProperty(_PROPERTY_FORBIDDEN);
            if (forbiddens == null) {
                return;
            }
            for (String v : values = forbiddens.split(",")) {
                if (v == null || v.length() <= 0) continue;
                this.passwordValuesRestrictions.add(new ValueRestriction(v));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initStrengthChecker(Properties props) {
        try {
            String stringClassName = (String)props.get(_PROPERTY_CHECKER);
            if (stringClassName == null) {
                this.simple();
                return;
            }
            Class<?> clazz = Class.forName(stringClassName);
            this.passwordStrengthChecker = (PasswordStrengthChecker)clazz.newInstance();
        }
        catch (Exception e) {
            this.simple();
        }
    }

    private void initDefaultStrength(Properties props) {
        try {
            this.acceptable = PasswordStrength.valueOf(props.getProperty(_PROPERTY_STRENGTH).toUpperCase());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean assertStrength(PasswordStrength result) {
        return result.getStrength() >= this.acceptable.getStrength();
    }

    public PasswordCheckResult check(boolean isAdminitrative, String userName, String password) {
        ArrayList<PasswordRestriction> passwordValuesRestrictions = new ArrayList<PasswordRestriction>(this.passwordValuesRestrictions);
        passwordValuesRestrictions.add(new ValueRestriction(userName));
        PasswordStrengthCheckResult strengthResult = this.passwordStrengthChecker.check(password, passwordValuesRestrictions);
        int failedRestrictions = strengthResult.getFailedRestrictions().size();
        PasswordStrength strength = strengthResult.getStrength();
        boolean strongEnough = this.assertStrength(strength);
        PasswordCheckResult.Result resultAction = null;
        String resultMessage = null;
        if (isAdminitrative) {
            if (strongEnough) {
                if (failedRestrictions > 0) {
                    resultAction = PasswordCheckResult.Result.WARN;
                    resultMessage = strengthResult.getFailedRestrictions().get(0).getMessage();
                } else {
                    resultAction = PasswordCheckResult.Result.ACCEPT;
                }
            } else {
                resultAction = PasswordCheckResult.Result.WARN;
                resultMessage = DomainManagementMessages.MESSAGES.passwordNotStrongEnough(strength.toString(), this.acceptable.toString());
            }
        } else if (strongEnough) {
            if (failedRestrictions > 0) {
                resultAction = PasswordCheckResult.Result.REJECT;
                resultMessage = strengthResult.getFailedRestrictions().get(0).getMessage();
            } else {
                resultAction = PasswordCheckResult.Result.ACCEPT;
            }
        } else if (failedRestrictions > 0) {
            resultAction = PasswordCheckResult.Result.REJECT;
            resultMessage = strengthResult.getFailedRestrictions().get(0).getMessage();
        } else {
            resultAction = PasswordCheckResult.Result.REJECT;
            resultMessage = DomainManagementMessages.MESSAGES.passwordNotStrongEnough(strength.toString(), this.acceptable.toString());
        }
        return new PasswordCheckResult(resultAction, resultMessage);
    }
}

