/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.configuration;

import org.infinispan.configuration.BuiltBy;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.CacheStoreConfiguration;
import org.infinispan.configuration.cache.LegacyConfigurationAdaptor;
import org.infinispan.configuration.cache.LegacyLoaderAdapter;
import org.infinispan.configuration.cache.SingletonStoreConfiguration;
import org.infinispan.loaders.CacheStoreConfig;
import org.infinispan.loaders.jdbc.DatabaseType;
import org.infinispan.loaders.jdbc.configuration.AbstractJdbcCacheStoreConfiguration;
import org.infinispan.loaders.jdbc.configuration.ConnectionFactoryConfiguration;
import org.infinispan.loaders.jdbc.configuration.JdbcMixedCacheStoreConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.LegacyConnectionFactoryAdaptor;
import org.infinispan.loaders.jdbc.configuration.TableManipulationConfiguration;
import org.infinispan.loaders.jdbc.mixed.JdbcMixedCacheStoreConfig;
import org.infinispan.util.TypedProperties;

@BuiltBy(value=JdbcMixedCacheStoreConfigurationBuilder.class)
public class JdbcMixedCacheStoreConfiguration
extends AbstractJdbcCacheStoreConfiguration
implements LegacyLoaderAdapter<JdbcMixedCacheStoreConfig> {
    private final int batchSize;
    private final int fetchSize;
    private final DatabaseType databaseType;
    private final TableManipulationConfiguration binaryTable;
    private final TableManipulationConfiguration stringTable;
    private final String key2StringMapper;

    protected JdbcMixedCacheStoreConfiguration(int batchSize, int fetchSize, DatabaseType databaseType, String key2StringMapper, TableManipulationConfiguration binaryTable, TableManipulationConfiguration stringTable, ConnectionFactoryConfiguration connectionFactory, long lockAcquistionTimeout, int lockConcurrencyLevel, boolean purgeOnStartup, boolean purgeSynchronously, int purgerThreads, boolean fetchPersistentState, boolean ignoreModifications, TypedProperties properties, AsyncStoreConfiguration async, SingletonStoreConfiguration singletonStore) {
        super(connectionFactory, lockAcquistionTimeout, lockConcurrencyLevel, purgeOnStartup, purgeSynchronously, purgerThreads, fetchPersistentState, ignoreModifications, properties, async, singletonStore);
        this.databaseType = databaseType;
        this.batchSize = batchSize;
        this.fetchSize = fetchSize;
        this.key2StringMapper = key2StringMapper;
        this.binaryTable = binaryTable;
        this.stringTable = stringTable;
    }

    public String key2StringMapper() {
        return this.key2StringMapper;
    }

    public TableManipulationConfiguration binaryTable() {
        return this.binaryTable;
    }

    public TableManipulationConfiguration stringTable() {
        return this.stringTable;
    }

    public int batchSize() {
        return this.batchSize;
    }

    public int fetchSize() {
        return this.fetchSize;
    }

    public DatabaseType databaseType() {
        return this.databaseType;
    }

    public JdbcMixedCacheStoreConfig adapt() {
        JdbcMixedCacheStoreConfig config = new JdbcMixedCacheStoreConfig();
        LegacyConfigurationAdaptor.adapt((CacheStoreConfiguration)this, (CacheStoreConfig)config);
        ((LegacyConnectionFactoryAdaptor)((Object)this.connectionFactory())).adapt(config);
        config.setKey2StringMapperClass(this.key2StringMapper);
        config.setCreateTableOnStartForBinary(this.binaryTable().createOnStart());
        config.setDropTableOnExitForBinary(this.binaryTable().dropOnExit());
        config.setTableNamePrefixForBinary(this.binaryTable().tableNamePrefix());
        config.setDataColumnNameForBinary(this.binaryTable().dataColumnName());
        config.setDataColumnTypeForBinary(this.binaryTable().dataColumnType());
        config.setIdColumnNameForBinary(this.binaryTable().idColumnName());
        config.setIdColumnTypeForBinary(this.binaryTable().idColumnType());
        config.setTimestampColumnNameForBinary(this.binaryTable().timestampColumnName());
        config.setTimestampColumnTypeForBinary(this.binaryTable().timestampColumnType());
        config.setCreateTableOnStartForStrings(this.stringTable().createOnStart());
        config.setDropTableOnExitForStrings(this.stringTable().dropOnExit());
        config.setTableNamePrefixForStrings(this.stringTable().tableNamePrefix());
        config.setDataColumnNameForStrings(this.stringTable().dataColumnName());
        config.setDataColumnTypeForStrings(this.stringTable().dataColumnType());
        config.setIdColumnNameForStrings(this.stringTable().idColumnName());
        config.setIdColumnTypeForStrings(this.stringTable().idColumnType());
        config.setTimestampColumnNameForStrings(this.stringTable().timestampColumnName());
        config.setTimestampColumnTypeForStrings(this.stringTable().timestampColumnType());
        config.setBatchSize(this.batchSize);
        config.setFetchSize(this.fetchSize);
        config.setDatabaseType(this.databaseType);
        return config;
    }

    public String toString() {
        return "JdbcMixedCacheStoreConfiguration [binaryTable=" + this.binaryTable + ", stringTable=" + this.stringTable + ", key2StringMapper=" + this.key2StringMapper + ", connectionFactory()=" + this.connectionFactory() + ", lockAcquistionTimeout()=" + this.lockAcquistionTimeout() + ", lockConcurrencyLevel()=" + this.lockConcurrencyLevel() + ", async()=" + this.async() + ", singletonStore()=" + this.singletonStore() + ", purgeOnStartup()=" + this.purgeOnStartup() + ", purgeSynchronously()=" + this.purgeSynchronously() + ", purgerThreads()=" + this.purgerThreads() + ", fetchPersistentState()=" + this.fetchPersistentState() + ", ignoreModifications()=" + this.ignoreModifications() + ", properties()=" + this.properties() + "]";
    }
}

