/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.token.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.sts.STSPropertiesMBean;
import org.apache.cxf.sts.SignatureProperties;
import org.apache.cxf.sts.claims.ClaimsAttributeStatementProvider;
import org.apache.cxf.sts.request.KeyRequirements;
import org.apache.cxf.sts.request.Renewing;
import org.apache.cxf.sts.request.TokenRequirements;
import org.apache.cxf.sts.token.provider.AttributeStatementProvider;
import org.apache.cxf.sts.token.provider.AuthDecisionStatementProvider;
import org.apache.cxf.sts.token.provider.AuthenticationStatementProvider;
import org.apache.cxf.sts.token.provider.ConditionsProvider;
import org.apache.cxf.sts.token.provider.DefaultAttributeStatementProvider;
import org.apache.cxf.sts.token.provider.DefaultConditionsProvider;
import org.apache.cxf.sts.token.provider.DefaultSubjectProvider;
import org.apache.cxf.sts.token.provider.SamlCallbackHandler;
import org.apache.cxf.sts.token.provider.SubjectProvider;
import org.apache.cxf.sts.token.provider.SymmetricKeyHandler;
import org.apache.cxf.sts.token.provider.TokenProvider;
import org.apache.cxf.sts.token.provider.TokenProviderParameters;
import org.apache.cxf.sts.token.provider.TokenProviderResponse;
import org.apache.cxf.sts.token.realm.SAMLRealm;
import org.apache.cxf.ws.security.sts.provider.STSException;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.apache.ws.security.saml.ext.SAMLParms;
import org.apache.ws.security.saml.ext.bean.AttributeStatementBean;
import org.apache.ws.security.saml.ext.bean.AuthDecisionStatementBean;
import org.apache.ws.security.saml.ext.bean.AuthenticationStatementBean;
import org.apache.ws.security.saml.ext.bean.ConditionsBean;
import org.apache.ws.security.saml.ext.bean.SubjectBean;
import org.joda.time.DateTime;
import org.opensaml.common.SAMLVersion;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMLTokenProvider
implements TokenProvider {
    private static final Logger LOG = LogUtils.getL7dLogger(SAMLTokenProvider.class);
    private List<AttributeStatementProvider> attributeStatementProviders;
    private List<AuthenticationStatementProvider> authenticationStatementProviders;
    private List<AuthDecisionStatementProvider> authDecisionStatementProviders;
    private SubjectProvider subjectProvider = new DefaultSubjectProvider();
    private ConditionsProvider conditionsProvider = new DefaultConditionsProvider();
    private boolean signToken = true;
    private Map<String, SAMLRealm> realmMap = new HashMap<String, SAMLRealm>();

    @Override
    public boolean canHandleToken(String tokenType) {
        return this.canHandleToken(tokenType, null);
    }

    @Override
    public boolean canHandleToken(String tokenType, String realm) {
        if (realm != null && !this.realmMap.containsKey(realm)) {
            return false;
        }
        return "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0".equals(tokenType) || "urn:oasis:names:tc:SAML:2.0:assertion".equals(tokenType) || "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1".equals(tokenType) || "urn:oasis:names:tc:SAML:1.0:assertion".equals(tokenType);
    }

    @Override
    public TokenProviderResponse createToken(TokenProviderParameters tokenParameters) {
        this.testKeyType(tokenParameters);
        byte[] secret = null;
        byte[] entropyBytes = null;
        long keySize = 0L;
        boolean computedKey = false;
        KeyRequirements keyRequirements = tokenParameters.getKeyRequirements();
        TokenRequirements tokenRequirements = tokenParameters.getTokenRequirements();
        LOG.fine("Handling token of type: " + tokenRequirements.getTokenType());
        if ("http://docs.oasis-open.org/ws-sx/ws-trust/200512/SymmetricKey".equals(keyRequirements.getKeyType())) {
            SymmetricKeyHandler keyHandler = new SymmetricKeyHandler(tokenParameters);
            keyHandler.createSymmetricKey();
            secret = keyHandler.getSecret();
            entropyBytes = keyHandler.getEntropyBytes();
            keySize = keyHandler.getKeySize();
            computedKey = keyHandler.isComputedKey();
        }
        try {
            Document doc = DOMUtils.createDocument();
            AssertionWrapper assertion = this.createSamlToken(tokenParameters, secret, doc);
            Element token = assertion.toDOM(doc);
            byte[] signatureValue = assertion.getSignatureValue();
            if (tokenParameters.getTokenStore() != null && signatureValue != null && signatureValue.length > 0) {
                Renewing renewing;
                Date expires = new Date();
                long currentTime = expires.getTime();
                expires.setTime(currentTime + this.conditionsProvider.getLifetime() * 1000L);
                SecurityToken securityToken = new SecurityToken(assertion.getId(), null, expires);
                securityToken.setToken(token);
                securityToken.setPrincipal(tokenParameters.getPrincipal());
                Properties props = securityToken.getProperties();
                if (props == null) {
                    props = new Properties();
                }
                securityToken.setProperties(props);
                if (tokenParameters.getRealm() != null) {
                    props.setProperty("org.apache.cxf.sts.token.realm", tokenParameters.getRealm());
                }
                if ((renewing = tokenParameters.getTokenRequirements().getRenewing()) != null) {
                    props.put("org.apache.cxf.sts.token.renewing.allow", String.valueOf(renewing.isAllowRenewing()));
                    props.put("org.apache.cxf.sts.token.renewing.allow.after.expiry", String.valueOf(renewing.isAllowRenewingAfterExpiry()));
                } else {
                    props.setProperty("org.apache.cxf.sts.token.renewing.allow", "true");
                    props.setProperty("org.apache.cxf.sts.token.renewing.allow.after.expiry", "false");
                }
                int hash = Arrays.hashCode(signatureValue);
                securityToken.setTokenHash(hash);
                String identifier = Integer.toString(hash);
                tokenParameters.getTokenStore().add(identifier, securityToken);
            }
            TokenProviderResponse response = new TokenProviderResponse();
            response.setToken(token);
            String tokenType = tokenRequirements.getTokenType();
            if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0".equals(tokenType) || "urn:oasis:names:tc:SAML:2.0:assertion".equals(tokenType)) {
                response.setTokenId(token.getAttribute("ID"));
            } else {
                response.setTokenId(token.getAttribute("AssertionID"));
            }
            DateTime validFrom = null;
            DateTime validTill = null;
            long lifetime = 0L;
            if (assertion.getSamlVersion().equals(SAMLVersion.VERSION_20)) {
                validFrom = assertion.getSaml2().getConditions().getNotBefore();
                validTill = assertion.getSaml2().getConditions().getNotOnOrAfter();
                lifetime = validTill.getMillis() - validFrom.getMillis();
            } else {
                validFrom = assertion.getSaml1().getConditions().getNotBefore();
                validTill = assertion.getSaml1().getConditions().getNotOnOrAfter();
                lifetime = validTill.getMillis() - validFrom.getMillis();
            }
            response.setLifetime(lifetime / 1000L);
            response.setEntropy(entropyBytes);
            if (keySize > 0L) {
                response.setKeySize(keySize);
            }
            response.setComputedKey(computedKey);
            return response;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "", e);
            throw new STSException("Can't serialize SAML assertion", (Throwable)e, STSException.REQUEST_FAILED);
        }
    }

    public void setAttributeStatementProviders(List<AttributeStatementProvider> attributeStatementProviders) {
        this.attributeStatementProviders = attributeStatementProviders;
    }

    public List<AttributeStatementProvider> getAttributeStatementProviders() {
        return this.attributeStatementProviders;
    }

    public void setAuthenticationStatementProviders(List<AuthenticationStatementProvider> authnStatementProviders) {
        this.authenticationStatementProviders = authnStatementProviders;
    }

    public List<AuthenticationStatementProvider> getAuthenticationStatementProviders() {
        return this.authenticationStatementProviders;
    }

    public void setAuthDecisionStatementProviders(List<AuthDecisionStatementProvider> authDecisionStatementProviders) {
        this.authDecisionStatementProviders = authDecisionStatementProviders;
    }

    public List<AuthDecisionStatementProvider> getAuthDecisionStatementProviders() {
        return this.authDecisionStatementProviders;
    }

    public void setSubjectProvider(SubjectProvider subjectProvider) {
        this.subjectProvider = subjectProvider;
    }

    public SubjectProvider getSubjectProvider() {
        return this.subjectProvider;
    }

    public void setConditionsProvider(ConditionsProvider conditionsProvider) {
        this.conditionsProvider = conditionsProvider;
    }

    public ConditionsProvider getConditionsProvider() {
        return this.conditionsProvider;
    }

    public boolean isSignToken() {
        return this.signToken;
    }

    public void setSignToken(boolean signToken) {
        this.signToken = signToken;
    }

    public void setRealmMap(Map<String, SAMLRealm> realms) {
        this.realmMap = realms;
    }

    public Map<String, SAMLRealm> getRealmMap() {
        return this.realmMap;
    }

    private AssertionWrapper createSamlToken(TokenProviderParameters tokenParameters, byte[] secret, Document doc) throws Exception {
        String realm = tokenParameters.getRealm();
        SAMLRealm samlRealm = null;
        if (realm != null && this.realmMap.containsKey(realm)) {
            samlRealm = this.realmMap.get(realm);
        }
        SamlCallbackHandler handler = this.createCallbackHandler(tokenParameters, secret, samlRealm, doc);
        SAMLParms samlParms = new SAMLParms();
        samlParms.setCallbackHandler((CallbackHandler)handler);
        AssertionWrapper assertion = new AssertionWrapper(samlParms);
        if (this.signToken) {
            String signatureAlgorithm;
            STSPropertiesMBean stsProperties = tokenParameters.getStsProperties();
            Crypto signatureCrypto = stsProperties.getSignatureCrypto();
            CallbackHandler callbackHandler = stsProperties.getCallbackHandler();
            SignatureProperties signatureProperties = stsProperties.getSignatureProperties();
            String alias = stsProperties.getSignatureUsername();
            if (samlRealm != null) {
                if (samlRealm.getSignatureCrypto() != null) {
                    LOG.fine("SAMLRealm signature keystore used");
                    signatureCrypto = samlRealm.getSignatureCrypto();
                    callbackHandler = samlRealm.getCallbackHandler();
                    alias = samlRealm.getSignatureAlias();
                }
                if (samlRealm.getSignatureProperties() != null) {
                    signatureProperties = samlRealm.getSignatureProperties();
                }
            }
            if ((signatureAlgorithm = tokenParameters.getKeyRequirements().getSignatureAlgorithm()) == null) {
                signatureAlgorithm = signatureProperties.getSignatureAlgorithm();
            } else {
                List<String> supportedAlgorithms = signatureProperties.getAcceptedSignatureAlgorithms();
                if (!supportedAlgorithms.contains(signatureAlgorithm)) {
                    signatureAlgorithm = signatureProperties.getSignatureAlgorithm();
                    LOG.fine("SignatureAlgorithm not supported, defaulting to: " + signatureAlgorithm);
                }
            }
            String c14nAlgorithm = tokenParameters.getKeyRequirements().getC14nAlgorithm();
            if (c14nAlgorithm == null) {
                c14nAlgorithm = signatureProperties.getC14nAlgorithm();
            } else {
                List<String> supportedAlgorithms = signatureProperties.getAcceptedC14nAlgorithms();
                if (!supportedAlgorithms.contains(c14nAlgorithm)) {
                    c14nAlgorithm = signatureProperties.getC14nAlgorithm();
                    LOG.fine("C14nAlgorithm not supported, defaulting to: " + c14nAlgorithm);
                }
            }
            if ((alias == null || "".equals(alias)) && signatureCrypto != null) {
                alias = signatureCrypto.getDefaultX509Identifier();
                LOG.fine("Signature alias is null so using default alias: " + alias);
            }
            WSPasswordCallback[] cb = new WSPasswordCallback[]{new WSPasswordCallback(alias, 3)};
            LOG.fine("Creating SAML Token");
            callbackHandler.handle((Callback[])cb);
            String password = cb[0].getPassword();
            LOG.fine("Signing SAML Token");
            boolean useKeyValue = signatureProperties.isUseKeyValue();
            assertion.signAssertion(alias, password, signatureCrypto, useKeyValue, c14nAlgorithm, signatureAlgorithm);
        }
        return assertion;
    }

    public SamlCallbackHandler createCallbackHandler(TokenProviderParameters tokenParameters, byte[] secret, SAMLRealm samlRealm, Document doc) throws Exception {
        ArrayList<AttributeStatementBean> attrBeanList = null;
        if (this.attributeStatementProviders != null && this.attributeStatementProviders.size() > 0) {
            attrBeanList = new ArrayList<AttributeStatementBean>();
            for (AttributeStatementProvider statementProvider : this.attributeStatementProviders) {
                AttributeStatementBean statementBean = statementProvider.getStatement(tokenParameters);
                if (statementBean == null) continue;
                LOG.fine("AttributeStatements" + statementBean.toString() + "returned by AttributeStatementProvider " + statementProvider.getClass().getName());
                attrBeanList.add(statementBean);
            }
        }
        ArrayList<AuthenticationStatementBean> authBeanList = null;
        if (this.authenticationStatementProviders != null && this.authenticationStatementProviders.size() > 0) {
            authBeanList = new ArrayList<AuthenticationStatementBean>();
            for (AuthenticationStatementProvider statementProvider : this.authenticationStatementProviders) {
                AuthenticationStatementBean statementBean = statementProvider.getStatement(tokenParameters);
                if (statementBean == null) continue;
                LOG.fine("AuthenticationStatement" + statementBean.toString() + "returned by AuthenticationStatementProvider " + statementProvider.getClass().getName());
                authBeanList.add(statementBean);
            }
        }
        ArrayList<AuthDecisionStatementBean> authDecisionBeanList = null;
        if (this.authDecisionStatementProviders != null && this.authDecisionStatementProviders.size() > 0) {
            authDecisionBeanList = new ArrayList<AuthDecisionStatementBean>();
            for (AuthDecisionStatementProvider statementProvider : this.authDecisionStatementProviders) {
                AuthDecisionStatementBean statementBean = statementProvider.getStatement(tokenParameters);
                if (statementBean == null) continue;
                LOG.fine("AuthDecisionStatement" + statementBean.toString() + "returned by AuthDecisionStatementProvider " + statementProvider.getClass().getName());
                authDecisionBeanList.add(statementBean);
            }
        }
        if (!(this.attributeStatementProviders != null && !this.attributeStatementProviders.isEmpty() || this.authenticationStatementProviders != null && !this.authenticationStatementProviders.isEmpty() || this.authDecisionStatementProviders != null && !this.authDecisionStatementProviders.isEmpty())) {
            attrBeanList = new ArrayList();
            AttributeStatementProvider attributeProvider = new DefaultAttributeStatementProvider();
            AttributeStatementBean attributeBean = attributeProvider.getStatement(tokenParameters);
            attrBeanList.add(attributeBean);
            attributeProvider = new ClaimsAttributeStatementProvider();
            attributeBean = attributeProvider.getStatement(tokenParameters);
            if (attributeBean != null) {
                attrBeanList.add(attributeBean);
            }
        }
        SubjectBean subjectBean = this.subjectProvider.getSubject(tokenParameters, doc, secret);
        ConditionsBean conditionsBean = this.conditionsProvider.getConditions(tokenParameters);
        SamlCallbackHandler handler = new SamlCallbackHandler();
        handler.setTokenProviderParameters(tokenParameters);
        handler.setSubjectBean(subjectBean);
        handler.setConditionsBean(conditionsBean);
        handler.setAttributeBeans(attrBeanList);
        handler.setAuthenticationBeans(authBeanList);
        handler.setAuthDecisionStatementBeans(authDecisionBeanList);
        if (samlRealm != null) {
            handler.setIssuer(samlRealm.getIssuer());
        }
        return handler;
    }

    private void testKeyType(TokenProviderParameters tokenParameters) {
        KeyRequirements keyRequirements = tokenParameters.getKeyRequirements();
        String keyType = keyRequirements.getKeyType();
        if ("http://docs.oasis-open.org/ws-sx/ws-trust/200512/PublicKey".equals(keyType)) {
            if (keyRequirements.getReceivedKey() == null || keyRequirements.getReceivedKey().getX509Cert() == null && keyRequirements.getReceivedKey().getPublicKey() == null) {
                LOG.log(Level.WARNING, "A PublicKey Keytype is requested, but no certificate is provided");
                throw new STSException("No client certificate for PublicKey KeyType", STSException.INVALID_REQUEST);
            }
        } else if (!"http://docs.oasis-open.org/ws-sx/ws-trust/200512/SymmetricKey".equals(keyType) && !"http://docs.oasis-open.org/ws-sx/ws-trust/200512/Bearer".equals(keyType) && keyType != null) {
            LOG.log(Level.WARNING, "An unknown KeyType was requested: " + keyType);
            throw new STSException("Unknown KeyType", STSException.INVALID_REQUEST);
        }
    }
}

