/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import java.util.Collections;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.CombinedTransformer;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescription;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.as.security.ACLResourceDefinition;
import org.jboss.as.security.AuditResourceDefinition;
import org.jboss.as.security.AuthorizationResourceDefinition;
import org.jboss.as.security.ClassicAuthenticationResourceDefinition;
import org.jboss.as.security.IdentityTrustResourceDefinition;
import org.jboss.as.security.JASPIAuthenticationResourceDefinition;
import org.jboss.as.security.JSSEResourceDefinition;
import org.jboss.as.security.LoginModuleStackResourceDefinition;
import org.jboss.as.security.MappingResourceDefinition;
import org.jboss.as.security.Namespace;
import org.jboss.as.security.SecurityDomainResourceDefinition;
import org.jboss.as.security.SecuritySubsystemParser;
import org.jboss.as.security.SecuritySubsystemRootResourceDefinition;
import org.jboss.as.security.VaultResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class SecurityExtension
implements Extension {
    public static final ServiceName JBOSS_SECURITY = ServiceName.JBOSS.append(new String[]{"security"});
    public static final String SUBSYSTEM_NAME = "security";
    static final PathElement PATH_SUBSYSTEM = PathElement.pathElement((String)"subsystem", (String)"security");
    private static final String RESOURCE_NAME = SecurityExtension.class.getPackage().getName() + ".LocalDescriptions";
    private static final int MANAGEMENT_API_MAJOR_VERSION = 1;
    private static final int MANAGEMENT_API_MINOR_VERSION = 2;
    private static final int MANAGEMENT_API_MICRO_VERSION = 0;
    private static final SecuritySubsystemParser PARSER = SecuritySubsystemParser.getInstance();
    static final PathElement ACL_PATH = PathElement.pathElement((String)"acl", (String)"classic");
    static final PathElement PATH_JASPI_AUTH = PathElement.pathElement((String)"authentication", (String)"jaspi");
    static final PathElement PATH_CLASSIC_AUTHENTICATION = PathElement.pathElement((String)"authentication", (String)"classic");
    static final PathElement SECURITY_DOMAIN_PATH = PathElement.pathElement((String)"security-domain");
    static final PathElement PATH_AUTHORIZATION_CLASSIC = PathElement.pathElement((String)"authorization", (String)"classic");
    static final PathElement PATH_MAPPING_CLASSIC = PathElement.pathElement((String)"mapping", (String)"classic");
    static final PathElement PATH_AUDIT_CLASSIC = PathElement.pathElement((String)"audit", (String)"classic");
    static final PathElement PATH_LOGIN_MODULE_STACK = PathElement.pathElement((String)"login-module-stack");
    static final PathElement VAULT_PATH = PathElement.pathElement((String)"vault", (String)"classic");
    static final PathElement JSSE_PATH = PathElement.pathElement((String)"jsse", (String)"classic");

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String keyPrefix) {
        return new StandardResourceDescriptionResolver(keyPrefix, RESOURCE_NAME, SecurityExtension.class.getClassLoader(), true, true);
    }

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder();
        for (String kp : keyPrefix) {
            if (prefix.length() > 0) {
                prefix.append('.');
            }
            prefix.append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, SecurityExtension.class.getClassLoader(), true, false);
    }

    public void initialize(ExtensionContext context) {
        boolean registerRuntimeOnly = context.isRuntimeOnlyRegistrationValid();
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, 1, 2, 0);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)SecuritySubsystemRootResourceDefinition.INSTANCE);
        registration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
        ManagementResourceRegistration securityDomain = registration.registerSubModel((ResourceDefinition)new SecurityDomainResourceDefinition(registerRuntimeOnly));
        ManagementResourceRegistration jaspi = securityDomain.registerSubModel((ResourceDefinition)JASPIAuthenticationResourceDefinition.INSTANCE);
        jaspi.registerSubModel((ResourceDefinition)LoginModuleStackResourceDefinition.INSTANCE);
        securityDomain.registerSubModel((ResourceDefinition)ClassicAuthenticationResourceDefinition.INSTANCE);
        securityDomain.registerSubModel((ResourceDefinition)AuthorizationResourceDefinition.INSTANCE);
        securityDomain.registerSubModel((ResourceDefinition)MappingResourceDefinition.INSTANCE);
        securityDomain.registerSubModel((ResourceDefinition)ACLResourceDefinition.INSTANCE);
        securityDomain.registerSubModel((ResourceDefinition)AuditResourceDefinition.INSTANCE);
        securityDomain.registerSubModel((ResourceDefinition)IdentityTrustResourceDefinition.INSTANCE);
        securityDomain.registerSubModel((ResourceDefinition)JSSEResourceDefinition.INSTANCE);
        registration.registerSubModel((ResourceDefinition)VaultResourceDefinition.INSTANCE);
        subsystem.registerXMLElementWriter((XMLElementWriter)PARSER);
        if (context.isRegisterTransformers()) {
            this.registerTransformers(subsystem);
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.SECURITY_1_0.getUriString(), (XMLElementReader)PARSER);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.SECURITY_1_1.getUriString(), (XMLElementReader)PARSER);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.SECURITY_1_2.getUriString(), (XMLElementReader)PARSER);
    }

    private void registerTransformers(SubsystemRegistration subsystemRegistration) {
        ResourceTransformationDescriptionBuilder builder = TransformationDescriptionBuilder.Factory.createSubsystemInstance();
        ResourceTransformationDescriptionBuilder securityDomain = builder.addChildResource(SECURITY_DOMAIN_PATH);
        ModulesToAttributeTransformer loginModule = new ModulesToAttributeTransformer("login-module", "login-modules");
        ResourceTransformationDescriptionBuilder child = securityDomain.addChildResource(PATH_CLASSIC_AUTHENTICATION).setCustomResourceTransformer((ResourceTransformer)loginModule).addOperationTransformationOverride("add").setCustomOperationTransformer((OperationTransformer)loginModule).inheritResourceAttributeDefinitions().end();
        child.discardChildResource(PathElement.pathElement((String)"login-module"));
        ModulesToAttributeTransformer policyModule = new ModulesToAttributeTransformer("policy-module", "policy-modules");
        child = securityDomain.addChildResource(PATH_AUTHORIZATION_CLASSIC).setCustomResourceTransformer((ResourceTransformer)policyModule).addOperationTransformationOverride("add").setCustomOperationTransformer((OperationTransformer)policyModule).inheritResourceAttributeDefinitions().end();
        child.discardChildResource(PathElement.pathElement((String)"policy-module"));
        ModulesToAttributeTransformer mappingModule = new ModulesToAttributeTransformer("mapping-module", "mapping-modules");
        child = securityDomain.addChildResource(PATH_MAPPING_CLASSIC).setCustomResourceTransformer((ResourceTransformer)mappingModule).addOperationTransformationOverride("add").setCustomOperationTransformer((OperationTransformer)mappingModule).inheritResourceAttributeDefinitions().end();
        child.discardChildResource(PathElement.pathElement((String)"mapping-module"));
        ModulesToAttributeTransformer providerModule = new ModulesToAttributeTransformer("provider-module", "provider-modules");
        child = securityDomain.addChildResource(PATH_AUDIT_CLASSIC).setCustomResourceTransformer((ResourceTransformer)providerModule).addOperationTransformationOverride("add").setCustomOperationTransformer((OperationTransformer)providerModule).inheritResourceAttributeDefinitions().end();
        child.discardChildResource(PathElement.pathElement((String)"provider-module"));
        ModulesToAttributeTransformer authModule = new ModulesToAttributeTransformer("auth-module", "auth-modules");
        ResourceTransformationDescriptionBuilder jaspiReg = securityDomain.addChildResource(PATH_JASPI_AUTH);
        jaspiReg.setCustomResourceTransformer((ResourceTransformer)authModule).addOperationTransformationOverride("add").setCustomOperationTransformer((OperationTransformer)authModule).inheritResourceAttributeDefinitions().end();
        jaspiReg.discardChildResource(PathElement.pathElement((String)"auth-module"));
        child = jaspiReg.addChildResource(PATH_LOGIN_MODULE_STACK).setCustomResourceTransformer((ResourceTransformer)loginModule).addOperationTransformationOverride("add").setCustomOperationTransformer((OperationTransformer)loginModule).inheritResourceAttributeDefinitions().end();
        child.discardChildResource(PathElement.pathElement((String)"login-module"));
        ((AttributeTransformationDescriptionBuilder)securityDomain.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{SecurityDomainResourceDefinition.CACHE_TYPE})).end();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.addChildResource(VAULT_PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{VaultResourceDefinition.CODE})).addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{VaultResourceDefinition.OPTIONS})).end();
        ((AttributeTransformationDescriptionBuilder)builder.addChildResource(JSSE_PATH).getAttributeBuilder().addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.ObjectFieldsRejectAttributeChecker(Collections.singletonMap(JSSEResourceDefinition.ADDITIONAL_PROPERTIES.getName(), RejectAttributeChecker.SIMPLE_EXPRESSIONS)), new AttributeDefinition[]{JSSEResourceDefinition.ADDITIONAL_PROPERTIES})).end();
        TransformationDescription.Tools.register((TransformationDescription)builder.build(), (SubsystemRegistration)subsystemRegistration, (ModelVersionRange)ModelVersion.create((int)1, (int)1, (int)0));
    }

    private static void transformModulesToAttributes(PathAddress address, String newName, String oldName, TransformationContext context, ModelNode model) {
        ModelNode modules = model.get(oldName).setEmptyList();
        for (Resource.ResourceEntry entry : context.readResourceFromRoot(address).getChildren(newName)) {
            Resource moduleResource = context.readResourceFromRoot(address.append(new PathElement[]{entry.getPathElement()}));
            modules.add(moduleResource.getModel());
        }
    }

    private static class ModulesToAttributeTransformer
    implements CombinedTransformer {
        private final String resourceName;
        private final String oldName;

        ModulesToAttributeTransformer(String resourceName, String oldName) {
            this.resourceName = resourceName;
            this.oldName = oldName;
        }

        public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
            SecurityExtension.transformModulesToAttributes(address, this.resourceName, this.oldName, context, operation);
            return new OperationTransformer.TransformedOperation(operation, OperationResultTransformer.ORIGINAL_RESULT);
        }

        public void transformResource(ResourceTransformationContext context, PathAddress address, Resource resource) throws OperationFailedException {
            ModelNode model = new ModelNode();
            SecurityExtension.transformModulesToAttributes(address, this.resourceName, this.oldName, (TransformationContext)context, model);
            resource.writeModel(model);
            ResourceTransformationContext childContext = context.addTransformedResource(PathAddress.EMPTY_ADDRESS, resource);
            childContext.processChildren(resource);
        }
    }
}

