/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import org.jboss.as.naming.NamingMessages;
import org.jboss.as.naming.ServiceAwareObjectFactory;
import org.jboss.as.naming.context.ModularReference;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceNotFoundException;
import org.jboss.msc.service.ServiceRegistry;

public class ServiceReferenceObjectFactory
implements ServiceAwareObjectFactory {
    private volatile ServiceRegistry serviceRegistry;

    public static Reference createReference(ServiceName service, Class<? extends ServiceReferenceObjectFactory> factory) {
        return ModularReference.create(Context.class, (RefAddr)new ServiceNameRefAdr("srof", service), factory);
    }

    @Override
    public void injectServiceRegistry(ServiceRegistry registry) {
        this.serviceRegistry = registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        ServiceController controller;
        Reference reference = (Reference)obj;
        ServiceNameRefAdr nameAdr = (ServiceNameRefAdr)reference.get("srof");
        if (nameAdr == null) {
            throw NamingMessages.MESSAGES.invalidContextReference("srof");
        }
        ServiceName serviceName = (ServiceName)nameAdr.getContent();
        try {
            controller = this.serviceRegistry.getRequiredService(serviceName);
        }
        catch (ServiceNotFoundException e) {
            throw NamingMessages.MESSAGES.cannotResolveService(serviceName);
        }
        ServiceReferenceListener listener = new ServiceReferenceListener();
        controller.addListener((ServiceListener)listener);
        ServiceReferenceListener serviceReferenceListener = listener;
        synchronized (serviceReferenceListener) {
            while (!listener.finished) {
                try {
                    ((Object)((Object)listener)).wait();
                }
                catch (InterruptedException e) {
                    throw NamingMessages.MESSAGES.threadInterrupt(serviceName);
                }
            }
        }
        switch (listener.getState()) {
            case UP: {
                return this.getObjectInstance(listener.getValue(), obj, name, nameCtx, environment);
            }
            case START_FAILED: {
                throw NamingMessages.MESSAGES.cannotResolveService(serviceName, this.getClass().getName(), "START_FAILED");
            }
            case REMOVED: {
                throw NamingMessages.MESSAGES.cannotResolveService(serviceName, this.getClass().getName(), "START_FAILED");
            }
        }
        throw NamingMessages.MESSAGES.cannotResolveServiceBug(serviceName, this.getClass().getName(), listener.getState().toString());
    }

    public Object getObjectInstance(Object serviceValue, Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        return serviceValue;
    }

    private static final class ServiceNameRefAdr
    extends RefAddr {
        private static final long serialVersionUID = 3677121114687908679L;
        private final ServiceName serviceName;

        private ServiceNameRefAdr(String s, ServiceName serviceName) {
            super(s);
            this.serviceName = serviceName;
        }

        @Override
        public Object getContent() {
            return this.serviceName;
        }
    }

    private class ServiceReferenceListener
    extends AbstractServiceListener {
        private ServiceController.State state;
        private boolean finished = false;
        private Object value;

        private ServiceReferenceListener() {
        }

        public synchronized void listenerAdded(ServiceController controller) {
            this.handleStateChange(controller);
        }

        public synchronized void dependencyFailed(ServiceController controller) {
            this.handleStateChange(controller);
        }

        public synchronized void transition(ServiceController controller, ServiceController.Transition transition) {
            switch (transition) {
                case STARTING_to_START_FAILED: 
                case STARTING_to_UP: 
                case REMOVING_to_REMOVED: {
                    this.handleStateChange(controller);
                }
            }
        }

        private void handleStateChange(ServiceController controller) {
            this.state = controller.getState();
            if (this.state == ServiceController.State.UP) {
                this.value = controller.getValue();
            }
            if (this.state == ServiceController.State.UP || this.state == ServiceController.State.START_FAILED || this.state == ServiceController.State.REMOVED) {
                controller.removeListener((ServiceListener)this);
                this.finished = true;
                ((Object)((Object)this)).notifyAll();
            }
        }

        public ServiceController.State getState() {
            return this.state;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean isFinished() {
            return this.finished;
        }
    }
}

