/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.subsystem;

import java.net.URL;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.CombinedTransformer;
import org.jboss.as.controller.transform.OperationRejectionPolicy;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.naming.NamingMessages;
import org.jboss.dmr.ModelNode;

public class Naming11Transformer
implements CombinedTransformer {
    public void transformResource(ResourceTransformationContext context, PathAddress address, Resource resource) throws OperationFailedException {
        resource.getModel().remove("environment");
    }

    public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
        ModelNode resolvedModel = operation.clone();
        if (resolvedModel.hasDefined("binding-type")) {
            String type = resolvedModel.get("binding-type").asString();
            if (type.equals("simple") && resolvedModel.hasDefined("type")) {
                if (URL.class.getName().equals(resolvedModel.get("type").asString())) {
                    return new OperationTransformer.TransformedOperation(operation, this.rejectOperation(NamingMessages.MESSAGES.failedToTransformSimpleURLNameBindingAddOperation("1.1.0")), OperationResultTransformer.ORIGINAL_RESULT);
                }
            } else if (type.equals("object-factory") && resolvedModel.hasDefined("environment")) {
                operation.remove("environment");
                return new OperationTransformer.TransformedOperation(operation, this.rejectOperation(NamingMessages.MESSAGES.failedToTransformObjectFactoryWithEnvironmentNameBindingAddOperation("1.1.0")), OperationResultTransformer.ORIGINAL_RESULT);
            }
        }
        return new OperationTransformer.TransformedOperation(operation, OperationResultTransformer.ORIGINAL_RESULT);
    }

    private OperationRejectionPolicy rejectOperation(final String failureMessage) {
        return new OperationRejectionPolicy(){

            public boolean rejectOperation(ModelNode preparedResult) {
                return true;
            }

            public String getFailureDescription() {
                return failureMessage;
            }
        };
    }
}

