/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.spi;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.spi.AbstractHostedCapability;
import org.jboss.osgi.resolver.spi.AbstractWiring;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Wire;
import org.osgi.service.resolver.HostedCapability;

public class AbstractBundleWiring
extends AbstractWiring
implements BundleWiring {
    public AbstractBundleWiring(XBundleRevision brev, List<Wire> required, List<Wire> provided) {
        super((XResource)brev, required, provided);
    }

    protected HostedCapability getHostedCapability(XCapability cap) {
        return new AbstractHostedBundleCapability((XResource)this.getResource(), cap);
    }

    public boolean isCurrent() {
        return true;
    }

    public boolean isInUse() {
        for (Wire wire : this.getProvidedResourceWires(null)) {
            BundleRevision requirer = (BundleRevision)wire.getRequirer();
            if (requirer.getBundle().getState() == 1) continue;
            return true;
        }
        return false;
    }

    public List<BundleCapability> getCapabilities(String namespace) {
        ArrayList<BundleCapability> result = new ArrayList<BundleCapability>();
        for (Capability cap : this.getResourceCapabilities(namespace)) {
            result.add((BundleCapability)cap);
        }
        return Collections.unmodifiableList(result);
    }

    public List<BundleRequirement> getRequirements(String namespace) {
        ArrayList<BundleRequirement> result = new ArrayList<BundleRequirement>();
        for (Requirement req : this.getResourceRequirements(namespace)) {
            result.add((BundleRequirement)req);
        }
        return Collections.unmodifiableList(result);
    }

    public List<BundleWire> getProvidedWires(String namespace) {
        ArrayList<BundleWire> providedWires = new ArrayList<BundleWire>();
        for (Wire wire : super.getProvidedResourceWires(namespace)) {
            providedWires.add((BundleWire)wire);
        }
        return Collections.unmodifiableList(providedWires);
    }

    public List<BundleWire> getRequiredWires(String namespace) {
        ArrayList<BundleWire> requiredWires = new ArrayList<BundleWire>();
        for (Wire wire : super.getRequiredResourceWires(namespace)) {
            requiredWires.add((BundleWire)wire);
        }
        return Collections.unmodifiableList(requiredWires);
    }

    public BundleRevision getRevision() {
        return this.getResource();
    }

    public BundleRevision getResource() {
        return (BundleRevision)super.getResource();
    }

    public ClassLoader getClassLoader() {
        XBundleRevision brev = (XBundleRevision)this.getRevision();
        return brev.getModuleClassLoader();
    }

    public List<URL> findEntries(String path, String filePattern, int options) {
        ArrayList result = new ArrayList();
        XBundleRevision brev = (XBundleRevision)this.getRevision();
        Enumeration entries = brev.findEntries(path, filePattern, options == 1);
        while (entries.hasMoreElements()) {
            result.add(entries.nextElement());
        }
        return Collections.unmodifiableList(result);
    }

    public Collection<String> listResources(String path, String filePattern, int options) {
        throw new UnsupportedOperationException();
    }

    public Bundle getBundle() {
        return this.getRevision().getBundle();
    }

    static class AbstractHostedBundleCapability
    extends AbstractHostedCapability
    implements BundleCapability {
        AbstractHostedBundleCapability(XResource resource, XCapability capability) {
            super(resource, capability);
        }

        public BundleRevision getRevision() {
            return (BundleRevision)super.getResource();
        }

        public BundleRevision getResource() {
            return (BundleRevision)super.getResource();
        }
    }
}

