/*
 * Decompiled with CFR 0.152.
 */
package scalax.file.ramfs;

import java.net.URI;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.WeakHashMap;
import scala.collection.mutable.WeakHashMap$;
import scala.runtime.BoxesRunTime;
import scalax.file.ramfs.RamFileSystem;
import scalax.file.ramfs.RamFileSystem$RamFsId$;
import scalax.file.ramfs.RamPath;
import scalax.io.DefaultResourceContext$;
import scalax.io.ResourceContext;

public final class RamFileSystem$ {
    public static final RamFileSystem$ MODULE$;
    private final String protocol;
    private final WeakHashMap<RamFileSystem.RamFsId, RamFileSystem> fileSystems;

    static {
        new RamFileSystem$();
    }

    public String protocol() {
        return this.protocol;
    }

    private WeakHashMap<RamFileSystem.RamFsId, RamFileSystem> fileSystems() {
        return this.fileSystems;
    }

    public RamFileSystem apply(String separator) {
        String x$4 = separator;
        RamFileSystem.RamFsId x$5 = this.$lessinit$greater$default$1();
        ResourceContext x$6 = this.$lessinit$greater$default$3();
        return new RamFileSystem(x$5, x$4, x$6);
    }

    public synchronized RamFileSystem apply(RamFileSystem.RamFsId fsId) {
        return (RamFileSystem)this.fileSystems().get((Object)fsId).getOrElse((Function0)new Serializable(fsId){
            public static final long serialVersionUID = 0L;
            private final RamFileSystem.RamFsId fsId$1;

            public final RamFileSystem apply() {
                return new RamFileSystem(this.fsId$1, RamFileSystem$.MODULE$.$lessinit$greater$default$2(), RamFileSystem$.MODULE$.$lessinit$greater$default$3());
            }
            {
                this.fsId$1 = fsId$1;
            }
        });
    }

    public RamPath apply(URI uri) {
        Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(uri.toString())).contains((Object)BoxesRunTime.boxToCharacter((char)'!')), (Function0)new Serializable(uri){
            public static final long serialVersionUID = 0L;
            private final URI uri$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Ramfile system URIs must be of form: ramfs://fsId!path, was: ").append((Object)this.uri$1).append((Object)" (did not contain a !)").toString();
            }
            {
                this.uri$1 = uri$1;
            }
        });
        Predef$.MODULE$.require(uri.getScheme().equalsIgnoreCase("ramfs"), (Function0)new Serializable(uri){
            public static final long serialVersionUID = 0L;
            private final URI uri$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Ramfile system URIs must start with ramfs, was: ").append((Object)this.uri$1).toString();
            }
            {
                this.uri$1 = uri$1;
            }
        });
        RamFileSystem.RamFsId id = new RamFileSystem.RamFsId((String)new StringOps(Predef$.MODULE$.augmentString(uri.getAuthority())).takeWhile((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(char x$1) {
                return x$1 != '!';
            }
        }));
        RamFileSystem fs = this.apply(id);
        String path = uri.getRawPath().replace("/", fs.separator());
        return fs.fromString(path);
    }

    public String apply$default$1() {
        return "/";
    }

    public synchronized void scalax$file$ramfs$RamFileSystem$$register(RamFileSystem.RamFsId fsId, RamFileSystem fs) {
        this.fileSystems().update((Object)fsId, (Object)fs);
    }

    public RamFileSystem.RamFsId $lessinit$greater$default$1() {
        return new RamFileSystem.RamFsId(RamFileSystem$RamFsId$.MODULE$.apply$default$1());
    }

    public String $lessinit$greater$default$2() {
        return "/";
    }

    public ResourceContext $lessinit$greater$default$3() {
        return DefaultResourceContext$.MODULE$;
    }

    private RamFileSystem$() {
        MODULE$ = this;
        this.protocol = "ramfs";
        this.fileSystems = (WeakHashMap)WeakHashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

