/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.client;

import org.hornetq.api.core.HornetQAddressFullException;
import org.hornetq.api.core.HornetQConnectionTimedOutException;
import org.hornetq.api.core.HornetQDisconnectedException;
import org.hornetq.api.core.HornetQIllegalStateException;
import org.hornetq.api.core.HornetQInterceptorRejectedPacketException;
import org.hornetq.api.core.HornetQInternalErrorException;
import org.hornetq.api.core.HornetQLargeMessageException;
import org.hornetq.api.core.HornetQNotConnectedException;
import org.hornetq.api.core.HornetQObjectClosedException;
import org.hornetq.api.core.HornetQTransactionOutcomeUnknownException;
import org.hornetq.api.core.HornetQTransactionRolledBackException;
import org.hornetq.api.core.HornetQUnBlockedException;
import org.hornetq.core.cluster.DiscoveryGroup;
import org.hornetq.spi.core.remoting.Connection;
import org.jboss.logging.Cause;
import org.jboss.logging.Message;
import org.jboss.logging.MessageBundle;
import org.jboss.logging.Messages;
import org.w3c.dom.Node;

@MessageBundle(projectCode="HQ")
public interface HornetQClientMessageBundle {
    public static final HornetQClientMessageBundle BUNDLE = (HornetQClientMessageBundle)Messages.getBundle(HornetQClientMessageBundle.class);

    @Message(id=119006, value="ClientSession closed while creating session", format=Message.Format.MESSAGE_FORMAT)
    public HornetQInternalErrorException clientSessionClosed();

    @Message(id=119007, value="Failed to create session", format=Message.Format.MESSAGE_FORMAT)
    public HornetQInternalErrorException failedToCreateSession(@Cause Throwable var1);

    @Message(id=119008, value="Internal Error! ClientSessionFactoryImpl::createSessionInternal just reached a condition that was not supposed to happen. Please inform this condition to the HornetQ team", format=Message.Format.MESSAGE_FORMAT)
    public HornetQInternalErrorException clietSessionInternal();

    @Message(id=119009, value="Queue can not be both durable and temporary", format=Message.Format.MESSAGE_FORMAT)
    public HornetQInternalErrorException queueMisConfigured();

    @Message(id=119011, value="Failed to initialise session factory", format=Message.Format.MESSAGE_FORMAT)
    public HornetQInternalErrorException failedToInitialiseSessionFactory(@Cause Exception var1);

    @Message(id=119015, value="Exception in Netty transport", format=Message.Format.MESSAGE_FORMAT)
    public HornetQInternalErrorException nettyError();

    @Message(id=119025, value="Channel disconnected", format=Message.Format.MESSAGE_FORMAT)
    public HornetQNotConnectedException channelDisconnected();

    @Message(id=119026, value="Cannot connect to server(s). Tried with all available servers.", format=Message.Format.MESSAGE_FORMAT)
    public HornetQNotConnectedException cannotConnectToServers();

    @Message(id=119027, value="Failed to connect to any static connectors", format=Message.Format.MESSAGE_FORMAT)
    public HornetQNotConnectedException cannotConnectToStaticConnectors(@Cause Exception var1);

    @Message(id=119028, value="Failed to connect to any static connectors", format=Message.Format.MESSAGE_FORMAT)
    public HornetQNotConnectedException cannotConnectToStaticConnectors2();

    @Message(id=119029, value="Connection is destroyed", format=Message.Format.MESSAGE_FORMAT)
    public HornetQNotConnectedException connectionDestroyed();

    @Message(id=119030, value="Did not receive data from server for {0}", format=Message.Format.MESSAGE_FORMAT)
    public HornetQConnectionTimedOutException connectionTimedOut(Connection var1);

    @Message(id=119031, value="Timed out waiting to receive initial broadcast from cluster", format=Message.Format.MESSAGE_FORMAT)
    public HornetQConnectionTimedOutException connectionTimedOutInInitialBroadcast();

    @Message(id=119032, value="Timed out waiting to receive cluster topology. Group:{0}", format=Message.Format.MESSAGE_FORMAT)
    public HornetQConnectionTimedOutException connectionTimedOutOnReceiveTopology(DiscoveryGroup var1);

    @Message(id=119033, value="Timed out waiting for response when sending packet {0}", format=Message.Format.MESSAGE_FORMAT)
    public HornetQConnectionTimedOutException timedOutSendingPacket(Byte var1);

    @Message(id=119035, value="The connection was disconnected because of server shutdown", format=Message.Format.MESSAGE_FORMAT)
    public HornetQDisconnectedException disconnected();

    @Message(id=119036, value="Connection failure detected. Unblocking a blocking call that will never get a response", format=Message.Format.MESSAGE_FORMAT)
    public HornetQUnBlockedException unblockingACall();

    @Message(id=119042, value="Consumer is closed", format=Message.Format.MESSAGE_FORMAT)
    public HornetQObjectClosedException consumerClosed();

    @Message(id=119043, value="Producer is closed", format=Message.Format.MESSAGE_FORMAT)
    public HornetQObjectClosedException producerClosed();

    @Message(id=119044, value="Session is closed", format=Message.Format.MESSAGE_FORMAT)
    public HornetQObjectClosedException sessionClosed();

    @Message(id=119046, value="Cannot call receive(...) - a MessageHandler is set", format=Message.Format.MESSAGE_FORMAT)
    public HornetQIllegalStateException messageHandlerSet();

    @Message(id=119047, value="Cannot set MessageHandler - consumer is in receive(...)", format=Message.Format.MESSAGE_FORMAT)
    public HornetQIllegalStateException inReceive();

    @Message(id=119048, value="Header size ({0}) is too big, use the messageBody for large data, or increase minLargeMessageSize", format=Message.Format.MESSAGE_FORMAT)
    public HornetQIllegalStateException headerSizeTooBig(Integer var1);

    @Message(id=119049, value="The large message lost connection with its session, either because of a rollback or a closed session", format=Message.Format.MESSAGE_FORMAT)
    public HornetQIllegalStateException largeMessageLostSession();

    @Message(id=119050, value="Couldn't select a TransportConfiguration to create SessionFactory", format=Message.Format.MESSAGE_FORMAT)
    public HornetQIllegalStateException noTCForSessionFactory();

    @Message(id=119064, value="Error saving the message body", format=Message.Format.MESSAGE_FORMAT)
    public HornetQLargeMessageException errorSavingBody(@Cause Exception var1);

    @Message(id=119065, value="Error reading the LargeMessageBody", format=Message.Format.MESSAGE_FORMAT)
    public HornetQLargeMessageException errorReadingBody(@Cause Exception var1);

    @Message(id=119066, value="Error closing stream from LargeMessageBody", format=Message.Format.MESSAGE_FORMAT)
    public HornetQLargeMessageException errorClosingLargeMessage(@Cause Exception var1);

    @Message(id=119067, value="Timeout waiting for LargeMessage Body", format=Message.Format.MESSAGE_FORMAT)
    public HornetQLargeMessageException timeoutOnLargeMessage();

    @Message(id=119069, value="Error writing body of message", format=Message.Format.MESSAGE_FORMAT)
    public HornetQLargeMessageException errorWritingLargeMessage(@Cause Exception var1);

    @Message(id=119070, value="The transaction was rolled back on failover to a backup server", format=Message.Format.MESSAGE_FORMAT)
    public HornetQTransactionRolledBackException txRolledBack();

    @Message(id=119073, value="The transaction was rolled back on failover however commit may have been succesful", format=Message.Format.MESSAGE_FORMAT)
    public HornetQTransactionOutcomeUnknownException txOutcomeUnknown();

    @Message(id=119074, value="Invalid type: {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException invalidType(Object var1);

    @Message(id=119075, value="Invalid type: {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException invalidEncodeType(Object var1);

    @Message(id=119076, value="Params for management operations must be of the following type: int long double String boolean Map or array thereof but found {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException invalidManagementParam(Object var1);

    @Message(id=119077, value="Invalid window size {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException invalidWindowSize(Integer var1);

    @Message(id=119087, value="No operation mapped to int {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException noOperationMapped(Integer var1);

    @Message(id=119103, value="Invalid last Received Command ID: {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException invalidCommandID(Integer var1);

    @Message(id=119104, value="Cannot find channel with id {0} to close", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException noChannelToClose(Long var1);

    @Message(id=119105, value="Close Listener cannot be null", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException closeListenerCannotBeNull();

    @Message(id=119106, value="Fail Listener cannot be null", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException failListenerCannotBeNull();

    @Message(id=119107, value="Connection already exists with id {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException connectionExists(Object var1);

    @Message(id=119110, value="Invalid argument null listener", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException nullListener();

    @Message(id=119111, value="Invalid argument null handler", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException nullHandler();

    @Message(id=119123, value="No available codec to decode password!", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException noCodec();

    @Message(id=119124, value="the first node to be compared is null", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException firstNodeNull();

    @Message(id=119125, value="the second node to be compared is null", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException secondNodeNull();

    @Message(id=119126, value="nodes have different node names", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException nodeHaveDifferentNames();

    @Message(id=119127, value="nodes hava a different number of attributes", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException nodeHaveDifferentAttNumber();

    @Message(id=119128, value="attribute {0}={1} doesn't match", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException attsDontMatch(String var1, String var2);

    @Message(id=119129, value="one node has children and the other doesn't", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException oneNodeHasChildren();

    @Message(id=119130, value="nodes hava a different number of children", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException nodeHasDifferentChildNumber();

    @Message(id=119131, value="Element {0} requires a valid Boolean value, but '{1}' cannot be parsed as a Boolean", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException mustBeBoolean(Node var1, String var2);

    @Message(id=119132, value="Element {0} requires a valid Double value, but '{1}' cannot be parsed as a Double", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException mustBeDouble(Node var1, String var2);

    @Message(id=119133, value="Element {0} requires a valid Integer value, but '{1}' cannot be parsed as a Integer", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException mustBeInteger(Node var1, String var2);

    @Message(id=119134, value="Element {0} requires a valid Long value, but '{1}' cannot be parsed as a Long", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException mustBeLong(Node var1, String var2);

    @Message(id=119135, value="Failed to get decoder", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException failedToGetDecoder(@Cause Exception var1);

    @Message(id=119136, value="Error decoding password", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException errordecodingPassword(@Cause Exception var1);

    @Message(id=119139, value="Address \"{0}\" is full. Message encode size = {1}B", format=Message.Format.MESSAGE_FORMAT)
    public HornetQAddressFullException addressIsFull(String var1, int var2);

    @Message(id=119140, value="Interceptor {0} rejected packet in a blocking call. This call will never complete.", format=Message.Format.MESSAGE_FORMAT)
    public HornetQInterceptorRejectedPacketException interceptorRejectedPacket(String var1);
}

