/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.openshift.txrecovery;

import io.narayana.openshift.txrecovery.ApplicationRecoveryPod;
import io.narayana.openshift.txrecovery.ApplicationRecoveryPodDAO;
import io.narayana.openshift.txrecovery.HibernateSetup;
import io.narayana.openshift.txrecovery.cliargs.ArgumentParserException;
import io.narayana.openshift.txrecovery.cliargs.ParsedArguments;
import io.narayana.openshift.txrecovery.types.CommandType;
import io.narayana.openshift.txrecovery.types.OutputFormatType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.service.ServiceRegistry;
import org.jboss.logging.Logger;

public class Main {
    private static final Logger log = Logger.getLogger(Main.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ParsedArguments parsedArguments = null;
        try {
            parsedArguments = ParsedArguments.parse(args);
        }
        catch (ArgumentParserException ape) {
            log.debugf((Throwable)ape, "Error on parsing arguments: %s", Arrays.asList(args));
            System.exit(1);
        }
        Properties setupProperties = HibernateSetup.getConfigurationProperties(parsedArguments);
        StandardServiceRegistry standardRegistry = HibernateSetup.getStandardRegistry(setupProperties);
        Metadata metadata = HibernateSetup.getHibernateStartupMetadata(setupProperties, (ServiceRegistry)standardRegistry);
        SessionFactory sessionFactory = metadata.buildSessionFactory();
        Session session = sessionFactory.openSession();
        String podTableName = HibernateSetup.getTableName(setupProperties);
        List<String> outputListing = null;
        try {
            outputListing = Main.processDatabaseUpdate(parsedArguments, podTableName, session, metadata);
        }
        finally {
            HibernateSetup.close(sessionFactory, session);
            if (standardRegistry != null) {
                StandardServiceRegistryBuilder.destroy((ServiceRegistry)standardRegistry);
            }
        }
        Main.printToStandardOutput(outputListing, parsedArguments.getFormat());
    }

    private static List<String> processDatabaseUpdate(ParsedArguments parsedArguments, String tableName, Session session, Metadata metadata) {
        ArrayList<String> outputListing = new ArrayList<String>();
        ApplicationRecoveryPodDAO dtoService = new ApplicationRecoveryPodDAO(session);
        switch (parsedArguments.getCommand()) {
            case CREATE: {
                if (dtoService.tableExists(tableName)) break;
                HibernateSetup.createTable(metadata);
                break;
            }
            case INSERT: {
                String appPod = parsedArguments.getApplicationPodName();
                String recPod = parsedArguments.getRecoveryPodName();
                if (appPod == null || appPod.isEmpty()) {
                    throw new IllegalArgumentException("For command '" + parsedArguments.getCommand().name() + "' application pod name has to be specified. Use cli argument '-a/--application_pod_name'");
                }
                if (recPod == null || recPod.isEmpty()) {
                    throw new IllegalArgumentException("For command '" + parsedArguments.getCommand().name() + "' recovery pod name has to be specified. Use cli argument '-r/--recovery_pod_name'");
                }
                if (!dtoService.tableExists(tableName)) {
                    HibernateSetup.createTable(metadata);
                }
                if (dtoService.saveRecord(appPod, recPod)) break;
                throw new IllegalStateException("Error on saving data [" + appPod + "," + recPod + "] to db " + parsedArguments.getJdbcUrl() + " and table " + parsedArguments.getTableName());
            }
            case DELETE: {
                String appPod = parsedArguments.getApplicationPodName();
                String recPod = parsedArguments.getRecoveryPodName();
                int numberDeleted = dtoService.delete(appPod, recPod);
                log.info((Object)("Number [" + numberDeleted + "] of records deleted while filtered at [application pod: " + appPod + ", recovery pod: " + recPod + "]"));
                break;
            }
            case SELECT_APPLICATION: 
            case SELECT_RECOVERY: {
                String appPod = parsedArguments.getApplicationPodName();
                String recPod = parsedArguments.getRecoveryPodName();
                Collection<ApplicationRecoveryPod> dtos = dtoService.getRecords(appPod, recPod);
                for (ApplicationRecoveryPod dto : dtos) {
                    if (parsedArguments.getCommand() == CommandType.SELECT_APPLICATION) {
                        outputListing.add(dto.getApplicationPodName());
                    }
                    if (parsedArguments.getCommand() != CommandType.SELECT_RECOVERY) continue;
                    outputListing.add(dto.getRecoveryPodName());
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown handler for command '" + (Object)((Object)parsedArguments.getCommand()) + "'");
            }
        }
        return outputListing;
    }

    private static void printToStandardOutput(List<String> dataToPrint, OutputFormatType printingFormat) {
        switch (printingFormat) {
            case LIST_COMMA: {
                System.out.println(dataToPrint.stream().collect(Collectors.joining(", ")));
                break;
            }
            case RAW: {
                System.out.println(dataToPrint);
                break;
            }
            default: {
                System.out.println(dataToPrint.stream().collect(Collectors.joining(" ")));
            }
        }
    }
}

