/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.openshift.txrecovery.cliargs;

import io.narayana.openshift.txrecovery.cliargs.ArgumentParserException;
import io.narayana.openshift.txrecovery.cliargs.Options;
import java.util.HashSet;
import java.util.Set;

class ArgumentParser {
    private Set<Options.OptionsData> optionsDeclared = new HashSet<Options.OptionsData>();

    ArgumentParser() {
    }

    void parse(Options options, String[] args) throws ArgumentParserException {
        if (options == null) {
            throw new NullPointerException("options");
        }
        if (args == null) {
            return;
        }
        Options.OptionsData currentOptionData = null;
        for (String arg : args) {
            if (currentOptionData == null) {
                Options.OptionsData data = options.getOption(arg);
                if (data == null) {
                    throw new ArgumentParserException("Unknown argument '" + arg + "'");
                }
                this.optionsDeclared.add(data);
                if (!data.withArgument) continue;
                currentOptionData = data;
                continue;
            }
            currentOptionData.setValue(arg);
            currentOptionData = null;
        }
        for (Options.OptionsData optionData : options.getAllOptions()) {
            if (!optionData.isRequired || this.optionsDeclared.contains(optionData)) continue;
            throw new ArgumentParserException("The argument '" + optionData + "' is required");
        }
    }

    String getOptionValue(String name) {
        for (Options.OptionsData option : this.optionsDeclared) {
            if (!option.getLongName().equals(name) && !option.getShortName().equals(name)) continue;
            return option.getValue();
        }
        return null;
    }

    String getOptionValue(String name, String defaultValue) {
        String value = this.getOptionValue(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    boolean hasOption(String name) {
        for (Options.OptionsData option : this.optionsDeclared) {
            if (!option.getLongName().equals(name) && !option.getShortName().equals(name)) continue;
            return true;
        }
        return false;
    }
}

