/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.openshift.txrecovery;

import io.narayana.openshift.txrecovery.ApplicationRecoveryPodHibernate5DAO;
import io.narayana.openshift.txrecovery.Hibernate5Setup;
import io.narayana.openshift.txrecovery.cliargs.ParsedArguments;
import io.narayana.openshift.txrecovery.hibernate.ApplicationRecoveryPod;
import io.narayana.openshift.txrecovery.hibernate.HibernateProperties;
import io.narayana.openshift.txrecovery.main.ProcessorMethods;
import io.narayana.openshift.txrecovery.types.CommandType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.hibernate.boot.Metadata;
import org.jboss.logging.Logger;

public class Hibernate5ProcessorMethods
implements ProcessorMethods {
    private static final Logger log = Logger.getLogger(Hibernate5ProcessorMethods.class);
    private static final List<String> EMPTY_RETURN = Collections.unmodifiableList(new ArrayList());
    private ApplicationRecoveryPodHibernate5DAO dao;
    private Properties hibernateSetupProperties;
    private Metadata metadata;
    private ParsedArguments parsedArguments;

    public Hibernate5ProcessorMethods(ApplicationRecoveryPodHibernate5DAO dao, ParsedArguments parsedArguments, Properties hibernateProps, Metadata metadata) {
        this.dao = dao;
        this.hibernateSetupProperties = hibernateProps;
        this.metadata = metadata;
        this.parsedArguments = parsedArguments;
    }

    public List<String> create() {
        String podTableName = HibernateProperties.getTableName((Properties)this.hibernateSetupProperties);
        if (!this.dao.tableExists(podTableName)) {
            Hibernate5Setup.createTable(this.metadata);
        }
        return EMPTY_RETURN;
    }

    public List<String> drop() {
        String tableName = this.parsedArguments.getTableName();
        int numberDropped = this.dao.dropTable(tableName);
        log.info((Object)("Number [" + numberDropped + "] of table names dropped. The table name to drop was: " + tableName));
        return EMPTY_RETURN;
    }

    public List<String> insert() {
        String podTableName = HibernateProperties.getTableName((Properties)this.hibernateSetupProperties);
        String appPod = this.parsedArguments.getApplicationPodName();
        String recPod = this.parsedArguments.getRecoveryPodName();
        if (!this.dao.tableExists(podTableName)) {
            Hibernate5Setup.createTable(this.metadata);
        }
        if (!this.dao.saveRecord(appPod, recPod)) {
            throw new IllegalStateException("Error on saving data [" + appPod + "," + recPod + "] to db " + this.parsedArguments.getJdbcUrl() + " and table " + this.parsedArguments.getTableName());
        }
        return EMPTY_RETURN;
    }

    public List<String> delete() {
        String appPod = this.parsedArguments.getApplicationPodName();
        String recPod = this.parsedArguments.getRecoveryPodName();
        int numberDeleted = this.dao.delete(appPod, recPod);
        log.info((Object)("Number [" + numberDeleted + "] of records deleted while filtered at [application pod: " + appPod + ", recovery pod: " + recPod + "]"));
        return EMPTY_RETURN;
    }

    public List<String> selectApplication() {
        String appPod = this.parsedArguments.getApplicationPodName();
        String recPod = this.parsedArguments.getRecoveryPodName();
        ArrayList<String> outputListing = new ArrayList<String>();
        Collection<ApplicationRecoveryPod> dtos = this.dao.getRecords(appPod, recPod);
        for (ApplicationRecoveryPod dto : dtos) {
            if (this.parsedArguments.getCommand() == CommandType.SELECT_APPLICATION) {
                outputListing.add(dto.getApplicationPodName());
            }
            if (this.parsedArguments.getCommand() != CommandType.SELECT_RECOVERY) continue;
            outputListing.add(dto.getRecoveryPodName());
        }
        return outputListing;
    }

    public List<String> selectRecovery() {
        return this.selectApplication();
    }
}

