/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.UndertowLogger;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.protocol.http.HttpAttachments;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.ContentTypeInfo;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.servlet.spec.RequestDispatcherImpl;
import io.undertow.servlet.spec.ServletContextImpl;
import io.undertow.servlet.spec.ServletCookieAdaptor;
import io.undertow.servlet.spec.ServletOutputStreamImpl;
import io.undertow.servlet.spec.ServletPrintWriter;
import io.undertow.servlet.spec.ServletPrintWriterDelegate;
import io.undertow.util.CanonicalPathUtils;
import io.undertow.util.DateUtils;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Protocols;
import io.undertow.util.RedirectBuilder;
import io.undertow.util.StatusCodes;
import io.undertow.util.URLUtils;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.SessionTrackingMode;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;

public final class HttpServletResponseImpl
implements HttpServletResponse {
    private final HttpServerExchange exchange;
    private final ServletContextImpl originalServletContext;
    private volatile ServletContextImpl servletContext;
    private ServletOutputStreamImpl servletOutputStream;
    private ResponseState responseState = ResponseState.NONE;
    private PrintWriter writer;
    private Integer bufferSize;
    private long contentLength = -1L;
    private boolean insideInclude = false;
    private Locale locale;
    private boolean responseDone = false;
    private boolean ignoredFlushPerformed = false;
    private boolean treatAsCommitted = false;
    private boolean charsetSet = false;
    private String contentType;
    private String charset;
    private Supplier<Map<String, String>> trailerSupplier;

    public HttpServletResponseImpl(HttpServerExchange exchange, ServletContextImpl servletContext) {
        this.exchange = exchange;
        this.servletContext = servletContext;
        this.originalServletContext = servletContext;
    }

    public HttpServerExchange getExchange() {
        return this.exchange;
    }

    public void addCookie(Cookie newCookie) {
        if (this.insideInclude) {
            return;
        }
        ServletCookieAdaptor servletCookieAdaptor = new ServletCookieAdaptor(newCookie);
        if (newCookie.getVersion() == 0) {
            servletCookieAdaptor.setVersion(this.servletContext.getDeployment().getDeploymentInfo().getDefaultCookieVersion());
        }
        this.exchange.setResponseCookie((io.undertow.server.handlers.Cookie)servletCookieAdaptor);
    }

    public boolean containsHeader(String name) {
        return this.exchange.getResponseHeaders().contains(name);
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public void sendError(int sc, String msg) throws IOException {
        if (this.insideInclude) {
            return;
        }
        ServletRequestContext src = (ServletRequestContext)this.exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        if (this.responseStarted()) {
            if (src.getErrorCode() > 0) {
                return;
            }
            throw UndertowServletMessages.MESSAGES.responseAlreadyCommited();
        }
        if (this.servletContext.getDeployment().getDeploymentInfo().isSendCustomReasonPhraseOnError()) {
            this.exchange.setReasonPhrase(msg);
        }
        this.writer = null;
        this.responseState = ResponseState.NONE;
        this.exchange.setStatusCode(sc);
        if (src.isRunningInsideHandler()) {
            this.treatAsCommitted = true;
            src.setError(sc, msg);
        } else {
            this.doErrorDispatch(sc, msg);
        }
    }

    public void doErrorDispatch(int sc, String error) throws IOException {
        this.writer = null;
        this.responseState = ResponseState.NONE;
        this.resetBuffer();
        this.treatAsCommitted = false;
        String location = this.servletContext.getDeployment().getErrorPages().getErrorLocation(sc);
        if (location != null) {
            RequestDispatcherImpl requestDispatcher = new RequestDispatcherImpl(location, this.servletContext);
            ServletRequestContext servletRequestContext = (ServletRequestContext)this.exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
            try {
                requestDispatcher.error(servletRequestContext, servletRequestContext.getServletRequest(), servletRequestContext.getServletResponse(), ((ServletRequestContext)this.exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY)).getCurrentServlet().getManagedServlet().getServletInfo().getName(), error);
            }
            catch (ServletException e) {
                throw new RuntimeException(e);
            }
        } else if (error != null) {
            this.setContentType("text/html");
            this.setCharacterEncoding("UTF-8");
            if (this.servletContext.getDeployment().getDeploymentInfo().isEscapeErrorMessage()) {
                this.getWriter().write("<html><head><title>Error</title></head><body>" + HttpServletResponseImpl.escapeHtml(error) + "</body></html>");
            } else {
                this.getWriter().write("<html><head><title>Error</title></head><body>" + error + "</body></html>");
            }
            this.getWriter().close();
        }
        this.responseDone();
    }

    public void sendError(int sc) throws IOException {
        this.sendError(sc, StatusCodes.getReason((int)sc));
    }

    public void sendRedirect(String location) throws IOException {
        if (this.responseStarted()) {
            throw UndertowServletMessages.MESSAGES.responseAlreadyCommited();
        }
        this.resetBuffer();
        this.setStatus(302);
        if (URLUtils.isAbsoluteUrl((String)location)) {
            this.exchange.getResponseHeaders().put(Headers.LOCATION, location);
        } else {
            String realPath;
            if (location.startsWith("/")) {
                realPath = location;
            } else {
                String current = this.exchange.getRequestURI().substring(this.getServletContext().getContextPath().length());
                int lastSlash = current.lastIndexOf("/");
                current = lastSlash != -1 ? current.substring(0, lastSlash + 1) : "";
                realPath = CanonicalPathUtils.canonicalize((String)(this.servletContext.getContextPath() + current + location));
            }
            String loc = this.exchange.getRequestScheme() + "://" + this.exchange.getHostAndPort() + realPath;
            this.exchange.getResponseHeaders().put(Headers.LOCATION, loc);
        }
        this.responseDone();
    }

    public void setDateHeader(String name, long date) {
        this.setHeader(name, DateUtils.toDateString((Date)new Date(date)));
    }

    public void addDateHeader(String name, long date) {
        this.addHeader(name, DateUtils.toDateString((Date)new Date(date)));
    }

    public void setHeader(String name, String value) {
        if (name == null) {
            throw UndertowServletMessages.MESSAGES.headerNameWasNull();
        }
        this.setHeader(HttpString.tryFromString((String)name), value);
    }

    public void setHeader(HttpString name, String value) {
        if (name == null) {
            throw UndertowServletMessages.MESSAGES.headerNameWasNull();
        }
        if (this.insideInclude || this.ignoredFlushPerformed) {
            return;
        }
        if (name.equals(Headers.CONTENT_TYPE)) {
            this.setContentType(value);
        } else {
            this.exchange.getResponseHeaders().put(name, value);
        }
    }

    public void addHeader(String name, String value) {
        if (name == null) {
            throw UndertowServletMessages.MESSAGES.headerNameWasNull();
        }
        this.addHeader(HttpString.tryFromString((String)name), value);
    }

    public void addHeader(HttpString name, String value) {
        if (name == null) {
            throw UndertowServletMessages.MESSAGES.headerNameWasNull();
        }
        if (this.insideInclude || this.ignoredFlushPerformed || this.treatAsCommitted) {
            return;
        }
        if (name.equals(Headers.CONTENT_TYPE) && !this.exchange.getResponseHeaders().contains(Headers.CONTENT_TYPE)) {
            this.setContentType(value);
        } else {
            this.exchange.getResponseHeaders().add(name, value);
        }
    }

    public void setIntHeader(String name, int value) {
        this.setHeader(name, Integer.toString(value));
    }

    public void addIntHeader(String name, int value) {
        this.addHeader(name, Integer.toString(value));
    }

    public void setStatus(int sc) {
        if (this.insideInclude || this.treatAsCommitted) {
            return;
        }
        if (this.responseStarted()) {
            return;
        }
        this.exchange.setStatusCode(sc);
    }

    public void setStatus(int sc, String sm) {
        this.setStatus(sc);
        if (!this.insideInclude && this.servletContext.getDeployment().getDeploymentInfo().isSendCustomReasonPhraseOnError()) {
            this.exchange.setReasonPhrase(sm);
        }
    }

    public int getStatus() {
        return this.exchange.getStatusCode();
    }

    public String getHeader(String name) {
        return this.exchange.getResponseHeaders().getFirst(name);
    }

    public Collection<String> getHeaders(String name) {
        HeaderValues headers = this.exchange.getResponseHeaders().get(name);
        if (headers == null) {
            return Collections.emptySet();
        }
        return new ArrayList<String>((Collection<String>)headers);
    }

    public Collection<String> getHeaderNames() {
        HashSet<String> headers = new HashSet<String>();
        for (HttpString i : this.exchange.getResponseHeaders().getHeaderNames()) {
            headers.add(i.toString());
        }
        return headers;
    }

    public String getCharacterEncoding() {
        if (this.charset != null) {
            return this.charset;
        }
        if (this.servletContext.getDeployment().getDeploymentInfo().getDefaultResponseEncoding() != null) {
            return this.servletContext.getDeployment().getDeploymentInfo().getDefaultResponseEncoding();
        }
        if (this.servletContext.getDeployment().getDeploymentInfo().getDefaultEncoding() != null) {
            return this.servletContext.getDeployment().getDeploymentInfo().getDefaultEncoding();
        }
        return StandardCharsets.ISO_8859_1.name();
    }

    public String getContentType() {
        if (this.contentType != null) {
            if (this.charsetSet) {
                return this.contentType + ";charset=" + this.getCharacterEncoding();
            }
            return this.contentType;
        }
        return null;
    }

    public ServletOutputStream getOutputStream() {
        if (this.responseState == ResponseState.WRITER) {
            throw UndertowServletMessages.MESSAGES.getWriterAlreadyCalled();
        }
        this.responseState = ResponseState.STREAM;
        this.createOutputStream();
        return this.servletOutputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            if (!this.charsetSet) {
                this.setCharacterEncoding(this.getCharacterEncoding());
            }
            if (this.responseState == ResponseState.STREAM) {
                throw UndertowServletMessages.MESSAGES.getOutputStreamAlreadyCalled();
            }
            this.responseState = ResponseState.WRITER;
            this.createOutputStream();
            ServletPrintWriter servletPrintWriter = new ServletPrintWriter(this.servletOutputStream, this.getCharacterEncoding());
            this.writer = ServletPrintWriterDelegate.newInstance(servletPrintWriter);
        }
        return this.writer;
    }

    private void createOutputStream() {
        if (this.servletOutputStream == null) {
            this.servletOutputStream = this.bufferSize == null ? new ServletOutputStreamImpl((ServletRequestContext)this.exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY)) : new ServletOutputStreamImpl((ServletRequestContext)this.exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY), this.bufferSize);
        }
    }

    public void setCharacterEncoding(String charset) {
        if (this.insideInclude || this.responseStarted() || this.writer != null || this.isCommitted()) {
            return;
        }
        this.charsetSet = charset != null;
        this.charset = charset;
        if (this.contentType != null) {
            this.exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, this.getContentType());
        }
    }

    public void setContentLength(int len) {
        this.setContentLengthLong(len);
    }

    public void setContentLengthLong(long len) {
        if (this.insideInclude || this.responseStarted()) {
            return;
        }
        if (len >= 0L) {
            this.exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, Long.toString(len));
        } else {
            this.exchange.getResponseHeaders().remove(Headers.CONTENT_LENGTH);
        }
        this.contentLength = len;
    }

    boolean isIgnoredFlushPerformed() {
        return this.ignoredFlushPerformed;
    }

    void setIgnoredFlushPerformed(boolean ignoredFlushPerformed) {
        this.ignoredFlushPerformed = ignoredFlushPerformed;
    }

    private boolean responseStarted() {
        return this.exchange.isResponseStarted() || this.ignoredFlushPerformed || this.treatAsCommitted;
    }

    public void setContentType(String type) {
        if (type == null || this.insideInclude || this.responseStarted()) {
            return;
        }
        ContentTypeInfo ct = this.servletContext.parseContentType(type);
        this.contentType = ct.getContentType();
        boolean useCharset = false;
        if (ct.getCharset() != null && this.writer == null && !this.isCommitted()) {
            this.charset = ct.getCharset();
            this.charsetSet = true;
            useCharset = true;
        }
        if (useCharset || !this.charsetSet) {
            this.exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, ct.getHeader());
        } else if (ct.getCharset() == null) {
            this.exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, ct.getHeader() + "; charset=" + this.charset);
        } else {
            this.exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, ct.getContentType() + "; charset=" + this.charset);
        }
    }

    public void setBufferSize(int size) {
        if (this.servletOutputStream != null) {
            this.servletOutputStream.setBufferSize(size);
        }
        this.bufferSize = size;
    }

    public int getBufferSize() {
        if (this.bufferSize == null) {
            return this.exchange.getConnection().getBufferSize();
        }
        return this.bufferSize;
    }

    public void flushBuffer() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        } else if (this.servletOutputStream != null) {
            this.servletOutputStream.flush();
        } else {
            this.createOutputStream();
            this.servletOutputStream.flush();
        }
    }

    public void closeStreamAndWriter() throws IOException {
        if (this.treatAsCommitted) {
            return;
        }
        if (this.writer != null) {
            this.writer.close();
        } else {
            if (this.servletOutputStream == null) {
                this.createOutputStream();
            }
            this.servletOutputStream.close();
        }
    }

    public void freeResources() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
        if (this.servletOutputStream != null) {
            this.servletOutputStream.close();
        }
    }

    public void resetBuffer() {
        if (this.servletOutputStream != null) {
            this.servletOutputStream.resetBuffer();
        }
        if (this.writer != null) {
            try {
                ServletPrintWriter servletPrintWriter = new ServletPrintWriter(this.servletOutputStream, this.getCharacterEncoding());
                this.writer = ServletPrintWriterDelegate.newInstance(servletPrintWriter);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean isCommitted() {
        return this.responseStarted();
    }

    public void reset() {
        if (this.servletOutputStream != null) {
            this.servletOutputStream.resetBuffer();
        }
        this.writer = null;
        this.responseState = ResponseState.NONE;
        this.exchange.getResponseHeaders().clear();
        this.exchange.setStatusCode(200);
        this.treatAsCommitted = false;
    }

    public void setLocale(Locale loc) {
        if (this.insideInclude || this.responseStarted()) {
            return;
        }
        this.locale = loc;
        this.exchange.getResponseHeaders().put(Headers.CONTENT_LANGUAGE, loc.getLanguage() + "-" + loc.getCountry());
        if (!this.charsetSet && this.writer == null) {
            Map<String, String> localeCharsetMapping = this.servletContext.getDeployment().getDeploymentInfo().getLocaleCharsetMapping();
            String charset = localeCharsetMapping.get(this.locale.toString());
            if (charset == null && (charset = localeCharsetMapping.get(this.locale.getLanguage() + "_" + this.locale.getCountry())) == null) {
                charset = localeCharsetMapping.get(this.locale.getLanguage());
            }
            if (charset != null) {
                this.charset = charset;
                if (this.contentType != null) {
                    this.exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, this.getContentType());
                }
            }
        }
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return Locale.getDefault();
    }

    public void responseDone() {
        if (this.responseDone || this.treatAsCommitted) {
            return;
        }
        this.responseDone = true;
        try {
            this.closeStreamAndWriter();
        }
        catch (IOException e) {
            UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
        }
        finally {
            this.servletContext.updateSessionAccessTime(this.exchange);
        }
    }

    public boolean isInsideInclude() {
        return this.insideInclude;
    }

    public void setInsideInclude(boolean insideInclude) {
        this.insideInclude = insideInclude;
    }

    public void setServletContext(ServletContextImpl servletContext) {
        this.servletContext = servletContext;
    }

    public ServletContextImpl getServletContext() {
        return this.servletContext;
    }

    public String encodeURL(String url) {
        String absolute = this.toAbsolute(url);
        if (this.isEncodeable(absolute)) {
            if (url.equalsIgnoreCase("")) {
                url = absolute;
            }
            return this.originalServletContext.getSessionConfig().rewriteUrl(url, this.servletContext.getSession(this.originalServletContext, this.exchange, true).getId());
        }
        return url;
    }

    public String encodeRedirectURL(String url) {
        if (this.isEncodeable(this.toAbsolute(url))) {
            return this.originalServletContext.getSessionConfig().rewriteUrl(url, this.servletContext.getSession(this.originalServletContext, this.exchange, true).getId());
        }
        return url;
    }

    private String toAbsolute(String location) {
        if (location == null) {
            return location;
        }
        boolean leadingSlash = location.startsWith("/");
        if (leadingSlash || !this.hasScheme(location)) {
            return RedirectBuilder.redirect((HttpServerExchange)this.exchange, (String)location, (boolean)false);
        }
        return location;
    }

    private boolean hasScheme(String uri) {
        int len = uri.length();
        for (int i = 0; i < len; ++i) {
            char c = uri.charAt(i);
            if (c == ':') {
                return i > 0;
            }
            if (Character.isLetterOrDigit(c) || c == '+' || c == '-' || c == '.') continue;
            return false;
        }
        return false;
    }

    private boolean isEncodeable(String location) {
        if (location == null) {
            return false;
        }
        if (location.startsWith("#")) {
            return false;
        }
        HttpServletRequestImpl hreq = ((ServletRequestContext)this.exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY)).getOriginalRequest();
        if (!this.originalServletContext.getEffectiveSessionTrackingModes().contains(SessionTrackingMode.URL)) {
            return false;
        }
        HttpSession session = hreq.getSession(false);
        if (session == null) {
            return false;
        }
        if (hreq.isRequestedSessionIdFromCookie()) {
            return false;
        }
        if (!hreq.isRequestedSessionIdFromURL() && !session.isNew()) {
            return false;
        }
        return this.doIsEncodeable(hreq, session, location);
    }

    private boolean doIsEncodeable(HttpServletRequestImpl hreq, HttpSession session, String location) {
        int urlPort;
        URL url = null;
        try {
            url = new URL(location);
        }
        catch (MalformedURLException e) {
            return false;
        }
        if (!hreq.getScheme().equalsIgnoreCase(url.getProtocol())) {
            return false;
        }
        if (!hreq.getServerName().equalsIgnoreCase(url.getHost())) {
            return false;
        }
        int serverPort = hreq.getServerPort();
        if (serverPort == -1) {
            serverPort = "https".equals(hreq.getScheme()) ? 443 : 80;
        }
        if ((urlPort = url.getPort()) == -1) {
            urlPort = "https".equals(url.getProtocol()) ? 443 : 80;
        }
        if (serverPort != urlPort) {
            return false;
        }
        String file = url.getFile();
        if (file == null) {
            return false;
        }
        String tok = this.originalServletContext.getSessionCookieConfig().getName().toLowerCase() + "=" + session.getId();
        return !file.contains(tok);
    }

    public long getContentLength() {
        return this.contentLength;
    }

    private static String escapeHtml(String msg) {
        return msg.replace("<", "&lt;").replace(">", "&gt;").replace("&", "&amp;");
    }

    public boolean isTreatAsCommitted() {
        return this.treatAsCommitted;
    }

    public void setTrailerFields(Supplier<Map<String, String>> supplier) {
        if (this.exchange.isResponseStarted()) {
            throw UndertowServletMessages.MESSAGES.responseAlreadyCommited();
        }
        if (this.exchange.getProtocol() == Protocols.HTTP_1_0) {
            throw UndertowServletMessages.MESSAGES.trailersNotSupported("HTTP/1.0 request");
        }
        if (this.exchange.getProtocol() == Protocols.HTTP_1_1 && this.exchange.getResponseHeaders().contains(Headers.CONTENT_LENGTH)) {
            throw UndertowServletMessages.MESSAGES.trailersNotSupported("not chunked");
        }
        this.trailerSupplier = supplier;
        this.exchange.putAttachment(HttpAttachments.RESPONSE_TRAILER_SUPPLIER, () -> {
            HeaderMap trailers = new HeaderMap();
            Map map = (Map)supplier.get();
            for (Map.Entry e : map.entrySet()) {
                trailers.put(new HttpString((String)e.getKey()), (String)e.getValue());
            }
            return trailers;
        });
    }

    public Supplier<Map<String, String>> getTrailerFields() {
        return this.trailerSupplier;
    }

    public static enum ResponseState {
        NONE,
        STREAM,
        WRITER;

    }
}

