/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.deployers;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import javax.management.JMException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.jboss.aop.AspectManager;
import org.jboss.aop.AspectXmlLoader;
import org.jboss.aop.deployment.AspectManagerService;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.logging.Logger;
import org.w3c.dom.Document;

public abstract class AbstractAspectManager {
    static final String BASE_ASPECTS_XML = "base-aspects.xml";
    AspectManagerService delegate = null;
    String bootstrapXml;

    public AbstractAspectManager(String bootstrapXml) {
        this.bootstrapXml = bootstrapXml;
    }

    public AspectManager getAspectManager() {
        return AspectManager.getTopLevelAspectManager();
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        this.delegate.addNotificationListener(listener, filter, handback);
    }

    public String aspectDefinitions() {
        return this.delegate.aspectDefinitions();
    }

    public void attachClass(String classname) {
        this.delegate.attachClass(classname);
    }

    public String bindings() {
        return this.delegate.bindings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create() throws Exception {
        block6: {
            try {
                if (this.bootstrapXml == null || this.bootstrapXml.trim().length() <= 0) break block6;
                BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(this.bootstrapXml.getBytes()));
                try {
                    Document doc = AspectXmlLoader.loadDocument((InputStream)new BufferedInputStream(in));
                    AspectXmlLoader loader = new AspectXmlLoader();
                    loader.setManager(this.getAspectManager());
                    loader.deployXML(doc, null);
                }
                finally {
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Problem starting AspectManager", e);
            }
        }
        this.delegate.create();
    }

    public void start() throws Exception {
        this.delegate.start();
    }

    public void stop() {
        this.delegate.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        block6: {
            try {
                if (this.bootstrapXml == null) break block6;
                BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(this.bootstrapXml.getBytes()));
                try {
                    Document doc = AspectXmlLoader.loadDocument((InputStream)new BufferedInputStream(in));
                    AspectXmlLoader loader = new AspectXmlLoader();
                    loader.setManager(this.getAspectManager());
                    loader.deployXML(doc, null);
                }
                finally {
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Problem destroying AspectManager", e);
            }
        }
        this.delegate.destroy();
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public DeploymentInfo getDeploymentInfo() throws JMException {
        return this.delegate.getDeploymentInfo();
    }

    public boolean getEnableLoadtimeWeaving() {
        return this.delegate.getEnableLoadtimeWeaving();
    }

    public boolean getEnableTransformer() {
        return this.delegate.getEnableTransformer();
    }

    public String getExclude() {
        return this.delegate.getExclude();
    }

    public String getIgnore() {
        return this.delegate.getIgnore();
    }

    public String getInclude() {
        return this.delegate.getInclude();
    }

    public String getInstrumentor() {
        return this.delegate.getInstrumentor();
    }

    public Logger getLog() {
        return this.delegate.getLog();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.delegate.getNotificationInfo();
    }

    public boolean getOptimized() {
        return this.delegate.getOptimized();
    }

    public boolean getPrune() {
        return this.delegate.getPrune();
    }

    public MBeanServer getServer() {
        return this.delegate.getServer();
    }

    public ObjectName getServiceName() {
        return this.delegate.getServiceName();
    }

    public int getState() {
        return this.delegate.getState();
    }

    public String getStateString() {
        return this.delegate.getStateString();
    }

    public boolean getSuppressReferenceErrors() {
        return this.delegate.getSuppressReferenceErrors();
    }

    public boolean getSuppressTransformationErrors() {
        return this.delegate.getSuppressTransformationErrors();
    }

    public File getTmpClassesDir() {
        return this.delegate.getTmpClassesDir();
    }

    public boolean getVerbose() {
        return this.delegate.getVerbose();
    }

    public void handleNotification(NotificationListener listener, Notification notification, Object handback) {
        this.delegate.handleNotification(listener, notification, handback);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String interceptorFactories() {
        return this.delegate.interceptorFactories();
    }

    public String introductions() {
        return this.delegate.introductions();
    }

    public void jbossInternalLifecycle(String method) throws Exception {
        this.delegate.jbossInternalLifecycle(method);
    }

    public long nextNotificationSequenceNumber() {
        return this.delegate.nextNotificationSequenceNumber();
    }

    public void postDeregister() {
        this.delegate.postDeregister();
    }

    public void postRegister(Boolean registrationDone) {
        this.delegate.postRegister(registrationDone);
    }

    public void preDeregister() throws Exception {
        this.delegate.preDeregister();
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        return this.delegate.preRegister(server, name);
    }

    public String registeredClassLoaders() {
        return this.delegate.registeredClassLoaders();
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.delegate.removeNotificationListener(listener, filter, handback);
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.delegate.removeNotificationListener(listener);
    }

    public void sendNotification(Notification notification) {
        this.delegate.sendNotification(notification);
    }

    public void setEnableLoadtimeWeaving(boolean enableTransformer) {
        this.delegate.setEnableLoadtimeWeaving(enableTransformer);
    }

    public void setEnableTransformer(boolean enableTransformer) {
        this.delegate.setEnableTransformer(enableTransformer);
    }

    public void setExclude(String exclude) {
        this.delegate.setExclude(exclude);
    }

    public void setIgnore(String ignore) {
        this.delegate.setIgnore(ignore);
    }

    public void setInclude(String include) {
        this.delegate.setInclude(include);
    }

    public void setInstrumentor(String instrumentor) {
        this.delegate.setInstrumentor(instrumentor);
    }

    public void setOptimized(boolean verbose) {
        this.delegate.setOptimized(verbose);
    }

    public void setPrune(boolean prune) {
        this.delegate.setPrune(prune);
    }

    public void setSuppressReferenceErrors(boolean suppressReferenceErrors) {
        this.delegate.setSuppressReferenceErrors(suppressReferenceErrors);
    }

    public void setSuppressTransformationErrors(boolean suppressTransformationErrors) {
        this.delegate.setSuppressTransformationErrors(suppressTransformationErrors);
    }

    public void setTmpClassesDir(File tmpClassesDir) {
        this.delegate.setTmpClassesDir(tmpClassesDir);
    }

    public void setVerbose(boolean verbose) {
        this.delegate.setVerbose(verbose);
    }

    public String stacks() {
        return this.delegate.stacks();
    }

    public void deployBaseAspects() {
        this.delegate.baseAop(BASE_ASPECTS_XML);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

