/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.deployment;

import java.io.File;
import java.net.URL;
import java.util.Iterator;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;
import org.jboss.aop.AspectAnnotationLoader;
import org.jboss.aop.AspectManager;
import org.jboss.aop.AspectXmlLoader;
import org.jboss.aop.deployment.AspectDeployerMBean;
import org.jboss.aop.deployment.JBossScopedClassLoaderHelper;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.DeploymentState;
import org.jboss.deployment.SubDeployer;
import org.jboss.deployment.SubDeployerSupport;
import org.jboss.mx.loading.HeirarchicalLoaderRepository3;
import org.jboss.mx.loading.LoaderRepository;
import org.jboss.util.file.ArchiveBrowser;
import org.jboss.util.file.ClassFileFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AspectDeployer
extends SubDeployerSupport
implements SubDeployer,
AspectDeployerMBean {
    public AspectDeployer() {
        this.initializeMainDeployer();
    }

    protected void initializeMainDeployer() {
        this.setSuffixes(new String[]{".aop", "-aop.xml"});
        this.setRelativeOrder(100);
    }

    public boolean accepts(DeploymentInfo di) {
        String urlStr = di.url.toString();
        return urlStr.endsWith(".aop") || urlStr.endsWith(".aop/") || urlStr.endsWith("-aop.xml");
    }

    public void init(DeploymentInfo di) throws DeploymentException {
        try {
            if (di.watch == null) {
                File file;
                di.watch = di.url.getProtocol().equals("file") ? (!(file = new File(di.url.getFile())).isDirectory() ? di.url : new URL(di.url, "META-INF/jboss-aop.xml")) : di.url;
            }
        }
        catch (Exception e) {
            this.log.error((Object)"failed to parse AOP document: ", (Throwable)e);
            throw new DeploymentException((Throwable)e);
        }
        super.init(di);
    }

    public void create(DeploymentInfo di) throws DeploymentException {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            URL docURL = this.getDocUrl(di);
            ClassLoader scl = this.getScopedClassLoader(di, docURL);
            if (scl != null) {
                this.log.info((Object)("AOP deployment is scoped using classloader " + scl));
            }
            Thread.currentThread().setContextClassLoader((ClassLoader)di.ucl);
            if (!di.isXML) {
                Iterator it = ArchiveBrowser.getBrowser((URL)di.localUrl, (ArchiveBrowser.Filter)new ClassFileFilter());
                AspectManager manager = scl != null ? AspectManager.instance((ClassLoader)scl) : AspectManager.instance();
                AspectAnnotationLoader loader = new AspectAnnotationLoader(manager);
                loader.setClassLoader(scl);
                loader.deployInputStreamIterator(it);
            }
            AspectXmlLoader.deployXML((URL)docURL, (ClassLoader)scl);
            Notification msg = new Notification("AOP Deploy", this, this.getNextNotificationSequenceNumber());
            this.sendNotification(msg);
            this.log.debug((Object)("Deployed AOP: " + di.url));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new DeploymentException((Throwable)ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public void start(DeploymentInfo di) throws DeploymentException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(DeploymentInfo di) {
        if (di.state != DeploymentState.STARTED) {
            this.log.debug((Object)("Ignoring request to stop '" + di.url + "', current state: " + di.state));
            return;
        }
        this.log.debug((Object)("undeploying document " + di.url));
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)di.ucl);
            if (!di.isXML) {
                Iterator it = ArchiveBrowser.getBrowser((URL)di.localUrl, (ArchiveBrowser.Filter)new ClassFileFilter());
                AspectAnnotationLoader loader = new AspectAnnotationLoader(AspectManager.instance());
                loader.undeployInputStreamIterator(it);
            }
            URL docURL = this.getDocUrl(di);
            AspectXmlLoader.undeployXML((URL)docURL);
            AspectManager.instance().unregisterClassLoader((ClassLoader)di.ucl);
            Notification msg = new Notification("AOP Undeploy", this, this.getNextNotificationSequenceNumber());
            this.sendNotification(msg);
        }
        catch (Exception ex) {
            this.log.error((Object)"failed to stop", (Throwable)ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public void destroy(DeploymentInfo di) {
    }

    protected void startService() throws Exception {
        super.startService();
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return name == null ? OBJECT_NAME : name;
    }

    private URL getDocUrl(DeploymentInfo di) throws DeploymentException {
        URL docURL = di.localUrl;
        if (!di.isXML) {
            docURL = di.localCl.findResource("META-INF/jboss-aop.xml");
        }
        if (docURL == null) {
            throw new DeploymentException("Failed to find META-INF/jboss-aop.xml");
        }
        return docURL;
    }

    private ClassLoader getScopedClassLoader(DeploymentInfo di, URL docUrl) throws Exception {
        if (JBossScopedClassLoaderHelper.isScopedClassLoader((ClassLoader)di.ucl)) {
            return di.ucl;
        }
        LoaderRepository attachToRepository = this.getLoaderRepositoryIfAttaching(di, docUrl);
        if (attachToRepository != null) {
            di.ucl.setRepository(attachToRepository);
            attachToRepository.addClassLoader((ClassLoader)di.ucl);
            return di.ucl;
        }
        return null;
    }

    private LoaderRepository getLoaderRepositoryIfAttaching(DeploymentInfo di, URL docUrl) throws Exception {
        if (di.parent == null) {
            Document doc = AspectXmlLoader.loadURL((URL)docUrl);
            Element top = doc.getDocumentElement();
            NodeList children = top.getChildNodes();
            int childlength = children.getLength();
            for (int i = 0; i < childlength; ++i) {
                ObjectName on;
                Element element;
                Node child = children.item(i);
                if (child.getNodeType() != 1 || !(element = (Element)child).getTagName().equals("loader-repository")) continue;
                String repositoryName = null;
                NodeList nestedChildren = child.getChildNodes();
                int nestedChildLength = nestedChildren.getLength();
                for (int j = 0; j < nestedChildLength; ++j) {
                    Node nestedChild = nestedChildren.item(j);
                    if (nestedChild.getNodeType() != 3 && nestedChild.getNodeType() != 4) continue;
                    repositoryName = nestedChild.getNodeValue().trim();
                    break;
                }
                this.log.info((Object)("Should attach deployment to loader repository " + repositoryName));
                try {
                    on = new ObjectName(repositoryName);
                }
                catch (MalformedObjectNameException e) {
                    throw new RuntimeException("loader-repository='" + repositoryName + "' is not a valid object name", e);
                }
                try {
                    MBeanInfo info = this.server.getMBeanInfo(on);
                }
                catch (InstanceNotFoundException e) {
                    this.log.warn((Object)("No scoped loader repository exists with the name " + on));
                }
                LoaderRepository repository = (LoaderRepository)this.server.getAttribute(on, "Instance");
                if (repository instanceof HeirarchicalLoaderRepository3) {
                    return repository;
                }
                this.log.warn((Object)("Loader repository " + on + " is not a isolated loader repository. Deploying aspects in default domain."));
            }
        }
        return null;
    }
}

