/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.deployment;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class SecurityActions {
    public static ClassLoader getParent(ClassLoader loader) {
        if (System.getSecurityManager() == null) {
            return GetParentAction.NON_PRIVILEGED.getParent(loader);
        }
        return GetParentAction.PRIVILEGED.getParent(loader);
    }

    static interface GetParentAction {
        public static final GetParentAction NON_PRIVILEGED = new GetParentAction(){

            public ClassLoader getParent(ClassLoader loader) {
                return loader.getParent();
            }
        };
        public static final GetParentAction PRIVILEGED = new GetParentAction(){

            public ClassLoader getParent(final ClassLoader loader) {
                try {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

                        @Override
                        public ClassLoader run() throws Exception {
                            return loader.getParent();
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw new RuntimeException(e.getException());
                }
            }
        };

        public ClassLoader getParent(ClassLoader var1);
    }
}

