/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.optimistic.FqnComparator;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;

public class TransactionWorkspaceImpl
implements TransactionWorkspace {
    private static FqnComparator fqnComparator = new FqnComparator();
    private Map nodes = new ConcurrentHashMap();
    private TreeCache cache;
    private boolean versioningImplicit = true;

    public void setCache(TreeCache cache) {
        this.cache = cache;
    }

    public TreeCache getCache() {
        return this.cache;
    }

    public Map getNodes() {
        return this.nodes;
    }

    public void setNodes(Map nodes) {
        this.nodes = nodes;
    }

    public WorkspaceNode getNode(Fqn fqn) {
        return (WorkspaceNode)this.nodes.get(fqn);
    }

    public void addNode(WorkspaceNode node) {
        this.nodes.put(node.getFqn(), node);
    }

    public Object removeNode(Fqn fqn) {
        return this.nodes.remove(fqn);
    }

    public SortedMap getNodesAfter(Fqn fqn) {
        TreeMap sm = new TreeMap(fqnComparator);
        sm.putAll(this.nodes);
        return sm.tailMap(fqn);
    }

    public boolean isVersioningImplicit() {
        return this.versioningImplicit;
    }

    public void setVersioningImplicit(boolean versioningImplicit) {
        this.versioningImplicit = versioningImplicit;
    }

    public String toString() {
        return "Workspace nodes=" + this.nodes;
    }
}

