/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.DataNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeNode;

public abstract class AbstractNode
implements DataNode {
    private static Log log = LogFactory.getLog((Class)AbstractNode.class);
    protected static final int INDENT = 4;
    protected Fqn fqn;
    protected Map children;
    protected Map data;

    public Object getName() {
        return this.fqn.getLast();
    }

    public Fqn getFqn() {
        return this.fqn;
    }

    public TreeNode getChild(Object child_name) {
        if (child_name == null) {
            return null;
        }
        return this.children == null ? null : (DataNode)this.children.get(child_name);
    }

    public TreeNode getParent() {
        return null;
    }

    public boolean childExists(Object child_name) {
        if (child_name == null) {
            return false;
        }
        return this.children != null && this.children.containsKey(child_name);
    }

    public Map getChildren() {
        return this.children;
    }

    public void setChildren(Map children) {
        this.children = children;
    }

    public boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    public void put(Map data) {
        this.put(data, false);
    }

    public void removeChild(Object child_name) {
        if (this.children != null) {
            this.children.remove(child_name);
            if (log.isTraceEnabled()) {
                log.trace((Object)("removed child " + child_name));
            }
        }
    }

    public void removeAllChildren() {
        if (this.children != null) {
            this.children.clear();
        }
    }

    public void print(StringBuffer sb, int indent) {
        this.printIndent(sb, indent);
        sb.append("/").append(this.getName());
        if (this.children != null && this.children.size() > 0) {
            Collection values = this.children.values();
            Iterator it = values.iterator();
            while (it.hasNext()) {
                sb.append("\n");
                ((DataNode)it.next()).print(sb, indent + 4);
            }
        }
    }

    public void printIndent(StringBuffer sb, int indent) {
        if (sb != null) {
            for (int i = 0; i < indent; ++i) {
                sb.append(" ");
            }
        }
    }

    public void addChild(Object child_name, TreeNode n) {
        if (child_name != null) {
            this.children().put(child_name, n);
        }
    }

    protected final Map data() {
        if (this.data == null) {
            this.data = new HashMap();
        }
        return this.data;
    }

    protected Map children() {
        if (this.children == null) {
            this.children = new HashMap();
        }
        return this.children;
    }

    protected void printDetailsInMap(StringBuffer sb, int indent, Map map) {
        this.printIndent(sb, indent);
        indent += 2;
        sb.append("/").append(this.getName());
        sb.append("\n");
        if (map != null) {
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
            }
        }
        if (this.children != null && this.children.size() > 0) {
            Collection values = this.children.values();
            Iterator it = values.iterator();
            while (it.hasNext()) {
                sb.append("\n");
                ((DataNode)it.next()).printDetails(sb, indent);
            }
        }
    }

    public abstract Object clone() throws CloneNotSupportedException;
}

