/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.StreamCorruptedException;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.ObjectName;
import org.jboss.mx.util.Serialization;

public class MBeanServerNotificationFilter
extends NotificationFilterSupport {
    private HashSet enabled = new HashSet();
    private HashSet disabled = null;
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;

    public synchronized void disableAllObjectNames() {
        this.enabled = new HashSet();
        this.disabled = null;
    }

    public synchronized void disableObjectName(ObjectName objectName) throws IllegalArgumentException {
        if (objectName == null) {
            throw new IllegalArgumentException("null object name");
        }
        if (this.enabled != null) {
            this.enabled.remove(objectName);
        }
        if (this.disabled != null && !this.disabled.contains(objectName)) {
            this.disabled.add(objectName);
        }
    }

    public synchronized void enableAllObjectNames() {
        this.enabled = null;
        this.disabled = new HashSet();
    }

    public synchronized void enableObjectName(ObjectName objectName) throws IllegalArgumentException {
        if (objectName == null) {
            throw new IllegalArgumentException("null object name");
        }
        if (this.disabled != null) {
            this.disabled.remove(objectName);
        }
        if (this.enabled != null && !this.enabled.contains(objectName)) {
            this.enabled.add(objectName);
        }
    }

    public synchronized Vector getDisabledObjectNames() {
        if (this.disabled == null) {
            return null;
        }
        return new Vector(this.disabled);
    }

    public synchronized Vector getEnabledObjectNames() {
        if (this.enabled == null) {
            return null;
        }
        return new Vector(this.enabled);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append(this.getClass().getName()).append(":");
        buffer.append(" enabledTypes=").append(this.getEnabledTypes());
        buffer.append(" enabledObjectNames=").append(this.getEnabledObjectNames());
        buffer.append(" disabledObjectNames=").append(this.getDisabledObjectNames());
        return buffer.toString();
    }

    public synchronized boolean isNotificationEnabled(Notification notification) throws IllegalArgumentException {
        if (notification == null) {
            throw new IllegalArgumentException("null notification");
        }
        if (!super.isNotificationEnabled(notification)) {
            return false;
        }
        MBeanServerNotification mbsNotification = (MBeanServerNotification)notification;
        ObjectName objectName = mbsNotification.getMBeanName();
        if (this.enabled != null) {
            return this.enabled.contains(objectName);
        }
        return !this.disabled.contains(objectName);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        List selectedNames;
        List deselectedNames;
        ObjectInputStream.GetField getField = ois.readFields();
        switch (Serialization.version) {
            case 10: {
                deselectedNames = (List)getField.get("myDeselectObjNameList", null);
                selectedNames = (List)getField.get("mySelectObjNameList", null);
                break;
            }
            default: {
                deselectedNames = (List)getField.get("deselectedNames", null);
                selectedNames = (List)getField.get("selectedNames", null);
            }
        }
        if (deselectedNames == null && selectedNames == null) {
            throw new StreamCorruptedException("Nothing enabled or disabled?");
        }
        this.disabled = deselectedNames == null ? null : new HashSet(deselectedNames);
        this.enabled = selectedNames == null ? null : new HashSet(selectedNames);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        ObjectOutputStream.PutField putField = oos.putFields();
        switch (Serialization.version) {
            case 10: {
                putField.put("myDeselectObjNameList", this.getDisabledObjectNames());
                putField.put("mySelectObjNameList", this.getEnabledObjectNames());
                break;
            }
            default: {
                putField.put("deselectedNames", this.getDisabledObjectNames());
                putField.put("selectedNames", this.getEnabledObjectNames());
            }
        }
        oos.writeFields();
    }

    static {
        switch (Serialization.version) {
            case 10: {
                serialVersionUID = 6001782699077323605L;
                serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("myDeselectObjNameList", Vector.class), new ObjectStreamField("mySelectObjNameList", Vector.class)};
                break;
            }
            default: {
                serialVersionUID = 2605900539589789736L;
                serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("deselectedNames", List.class), new ObjectStreamField("selectedNames", List.class)};
            }
        }
    }
}

