/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.interceptor;

import java.lang.reflect.Method;
import javax.management.Descriptor;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.ServiceNotFoundException;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import org.jboss.mx.interceptor.ReflectedDispatcher;
import org.jboss.mx.server.Invocation;
import org.jboss.mx.server.MBeanInvoker;

public class AttributeDispatcher
extends ReflectedDispatcher {
    private Method getter;
    private Method setter;

    public AttributeDispatcher(Method getter, Method setter, boolean dynamic) {
        super(dynamic);
        this.setName("Attribute Dispatcher");
        this.getter = getter;
        this.setter = setter;
    }

    public Object invoke(Invocation invocation) throws Throwable {
        Descriptor d;
        Object target = invocation.getTarget();
        Object value = null;
        Object[] args = invocation.getArgs();
        if (args == null) {
            Descriptor d2;
            Method getMethod = this.getter;
            if (this.dynamic && (d2 = invocation.getDescriptor()) != null) {
                String getMethodString;
                Object descriptorTarget = d2.getFieldValue("targetObject");
                if (descriptorTarget != null) {
                    String targetType = (String)d2.getFieldValue("targetType");
                    if (!"ObjectReference".equalsIgnoreCase(targetType)) {
                        throw new InvalidTargetObjectTypeException("Target type is " + targetType);
                    }
                    target = descriptorTarget;
                }
                if (!((getMethodString = (String)d2.getFieldValue("getMethod")) == null || getMethod != null && getMethodString.equals(getMethod.getName()))) {
                    MBeanInvoker invoker = invocation.getInvoker();
                    Object object = invoker.invoke(getMethodString, new Object[0], new String[0]);
                    this.checkAssignable(getMethodString, invocation.getAttributeTypeClass(), object);
                    return object;
                }
            }
            if (target == null) {
                throw new MBeanException(new ServiceNotFoundException("No Target"));
            }
            try {
                value = getMethod.invoke(target, args);
            }
            catch (Throwable t) {
                this.handleInvocationExceptions(t);
                return null;
            }
        }
        Method setMethod = this.setter;
        if (this.dynamic && (d = invocation.getDescriptor()) != null) {
            String setMethodString;
            Object descriptorTarget = d.getFieldValue("targetObject");
            if (descriptorTarget != null) {
                String targetType = (String)d.getFieldValue("targetType");
                if (!"ObjectReference".equalsIgnoreCase(targetType)) {
                    throw new InvalidTargetObjectTypeException("Target type is " + targetType);
                }
                target = descriptorTarget;
            }
            if (!((setMethodString = (String)d.getFieldValue("setMethod")) == null || setMethod != null && setMethodString.equals(setMethod.getName()))) {
                MBeanInvoker invoker = invocation.getInvoker();
                return invoker.invoke(setMethodString, new Object[]{args[0]}, new String[]{invocation.getAttributeType()});
            }
        }
        if (target == null) {
            throw new MBeanException(new ServiceNotFoundException("No Target"));
        }
        try {
            value = setMethod.invoke(target, args);
        }
        catch (Throwable t) {
            this.handleInvocationExceptions(t);
            return null;
        }
        return value;
    }

    protected void checkAssignable(String context, Class clazz, Object value) throws InvalidAttributeValueException, ClassNotFoundException {
        if (value != null && !clazz.isAssignableFrom(value.getClass())) {
            throw new InvalidAttributeValueException(context + " has class " + value.getClass() + " loaded from " + value.getClass().getClassLoader() + " that is not assignable to attribute class " + clazz + " loaded from " + clazz.getClassLoader());
        }
    }
}

