/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.MBeanElement;
import org.jboss.mx.loading.MBeanFileParser;

public class MLetParser
implements MBeanFileParser {
    private static final Logger log = Logger.getLogger(MLetParser.class);

    public Set parseMBeanFile(String url) throws ParseException, MalformedURLException {
        return this.parseMBeanFile(new URL(url));
    }

    public Set parseMBeanFile(URL url) throws ParseException {
        HashSet<MBeanElement> mlets = new HashSet<MBeanElement>();
        MBeanElement element = null;
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            int c = -1;
            while ((c = reader.read()) != -1) {
                if (c != 60) continue;
                StringBuffer buf = new StringBuffer(1000);
                boolean readMore = true;
                while (readMore) {
                    c = reader.read();
                    if (c == -1) {
                        throw new ParseException("Unexpected end of file. Tag was not closed: " + buf.toString().replace('\t', ' ').replace('\n', ' ').replace('\r', ' ').trim(), 0);
                    }
                    if (c == 62) {
                        readMore = false;
                        break;
                    }
                    buf.append((char)c);
                }
                StringTokenizer tokenizer = new StringTokenizer(buf.toString(), "= \n\t\r");
                String tagName = null;
                String attributeName = null;
                String attributeValue = null;
                if (tokenizer.hasMoreTokens()) {
                    tagName = tokenizer.nextToken().trim();
                }
                if (tagName.equals("MLET")) {
                    element = new MBeanElement();
                    while (tokenizer.hasMoreTokens()) {
                        try {
                            attributeName = tokenizer.nextToken("= \n\t\r").trim();
                            attributeValue = tokenizer.nextToken(" \n\t\r").trim();
                            if (attributeValue.equals("=")) {
                                attributeValue = tokenizer.nextToken();
                            }
                            if (attributeName.equals("CODE")) {
                                element.setCode(attributeValue);
                                continue;
                            }
                            if (attributeName.equals("OBJECT")) {
                                element.setObject(attributeValue);
                                continue;
                            }
                            if (attributeName.equals("ARCHIVE")) {
                                element.setArchive(attributeValue);
                                continue;
                            }
                            if (attributeName.equals("CODEBASE")) {
                                element.setCodebase(attributeValue);
                                continue;
                            }
                            if (attributeName.equals("NAME")) {
                                element.setName(attributeValue);
                                continue;
                            }
                            if (!attributeName.equals("VERSION")) continue;
                            element.setVersion(attributeValue);
                        }
                        catch (NoSuchElementException e) {
                            log.warn((Object)("No value found for attribute '" + attributeName));
                        }
                    }
                    if (element.getCode() == null && element.getObject() == null) {
                        throw new ParseException("<" + buf.toString().replace('\n', ' ').replace('\r', ' ').replace('\t', ' ').trim() + "> is missing mandatory CODE | OBJECT attribute", 0);
                    }
                    if (element.getArchives().size() != 0) continue;
                    throw new ParseException("<" + buf.toString().replace('\n', ' ').replace('\r', ' ').replace('\t', ' ').trim() + "> is missing mandatory ARCHIVE attribute", 0);
                }
                if (tagName.equals("/MLET")) {
                    mlets.add(element);
                    element = null;
                    continue;
                }
                if (!tagName.equals("ARG")) continue;
                try {
                    if (!tokenizer.nextToken().equals("TYPE")) continue;
                    String type = tokenizer.nextToken();
                    if (!tokenizer.nextToken().equals("VALUE")) continue;
                    String value = tokenizer.nextToken(" \n\t\r");
                    if (element == null) continue;
                    element.addArg(type, value);
                }
                catch (NoSuchElementException e) {
                    element = null;
                    log.warn((Object)("Malformed element: <" + buf.toString() + ">"));
                }
            }
            mlets.remove(null);
            return mlets;
        }
        catch (IOException e) {
            throw new ParseException(e.toString(), 0);
        }
    }
}

