/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.protocol.vfsfile;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jboss.virtual.plugins.vfs.VirtualFileURLConnection;

public class Handler
extends URLStreamHandler {
    protected URLConnection openConnection(URL u) throws IOException {
        String relative;
        String file = u.toString().substring(8);
        URL vfsurl = null;
        File fp = new File(file);
        if (fp.exists()) {
            vfsurl = fp.getParentFile().toURL();
            relative = fp.getName();
        } else {
            File curr = fp;
            relative = fp.getName();
            while ((curr = curr.getParentFile()) != null) {
                if (curr.exists()) {
                    vfsurl = curr.toURL();
                    break;
                }
                relative = String.valueOf(curr.getName()) + "/" + relative;
            }
        }
        if (vfsurl == null) {
            throw new IOException("vfsfile does not exist: " + u.toString());
        }
        return new VirtualFileURLConnection(u, vfsurl, relative);
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("java.protocol.handler.pkgs", "org.jboss.virtual.protocol");
        URL furl = new URL("file:/c:/tmp/parent.jar");
        System.out.println("urlpath: " + furl.getPath());
        URL url = new URL("vfsfile:/c:/tmp/parent.jar/foo.jar/urlstream.java");
        InputStream is = url.openStream();
        char curr = '\u0000';
        while (is.available() != 0) {
            curr = (char)is.read();
            System.out.print(curr);
        }
        is.close();
        File fp = new File("c:/jboss/geronimo-1.1.1/lib/geronimo-kernel-1.1.1.jar");
        JarFile jf = new JarFile(fp);
        Enumeration<JarEntry> entries = jf.entries();
        HashSet<String> set = new HashSet<String>();
        while (entries.hasMoreElements()) {
            String name = entries.nextElement().getName();
            if (!name.endsWith(".class")) continue;
            set.add(name.replace('/', '.').substring(0, name.length() - 6));
        }
        jf.close();
        URL[] urls = new URL[]{new URL("vfsfile:/c:/tmp/wrap.jar/geronimo-kernel-1.1.1.jar"), new URL("file:/c:/jboss/geronimo-1.1.1/lib/xstream-1.1.3.jar")};
        URLClassLoader loader = new URLClassLoader(urls);
        for (String name : set) {
            System.out.println("loading: " + name);
            loader.loadClass(name);
        }
    }
}

