/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.hasessionstate.server;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.jboss.ha.hasessionstate.interfaces.PackagedSession;

public class PackagedSessionImpl
implements PackagedSession {
    private static final long serialVersionUID = 4162160242862877223L;
    protected byte[] state;
    protected long versionId;
    protected String owner;
    protected Serializable key;
    protected transient long lastModificationTimeInVM;

    public PackagedSessionImpl() {
        this.lastModificationTimeInVM = System.currentTimeMillis();
    }

    public PackagedSessionImpl(Serializable key, byte[] state, String owner) {
        this.key = key;
        this.setState(state);
        this.owner = owner;
        this.lastModificationTimeInVM = System.currentTimeMillis();
    }

    public byte[] getState() {
        return this.state;
    }

    public boolean setState(byte[] state) {
        this.lastModificationTimeInVM = System.currentTimeMillis();
        if (this.isStateIdentical(state)) {
            return true;
        }
        this.state = state;
        ++this.versionId;
        return false;
    }

    public boolean isStateIdentical(byte[] state) {
        return Arrays.equals(state, this.state);
    }

    public void update(PackagedSession clone) {
        this.state = (byte[])clone.getState().clone();
        this.versionId = clone.getVersion();
        this.owner = clone.getOwner();
        this.lastModificationTimeInVM = System.currentTimeMillis();
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public long getVersion() {
        return this.versionId;
    }

    public Serializable getKey() {
        return this.key;
    }

    public void setKey(Serializable key) {
        this.key = key;
    }

    public long unmodifiedExistenceInVM() {
        return this.lastModificationTimeInVM;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.lastModificationTimeInVM = System.currentTimeMillis();
    }
}

