/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.jrmp.server;

import java.rmi.MarshalledObject;
import java.util.ArrayList;
import java.util.HashMap;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jboss.ha.framework.interfaces.GenericClusteringException;
import org.jboss.ha.framework.interfaces.HARMIResponse;
import org.jboss.ha.framework.interfaces.LoadBalancePolicy;
import org.jboss.ha.framework.server.HATarget;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.Invoker;
import org.jboss.invocation.InvokerHA;
import org.jboss.invocation.MarshalledInvocation;
import org.jboss.invocation.jrmp.interfaces.JRMPInvokerProxyHA;
import org.jboss.invocation.jrmp.server.JRMPInvoker;
import org.jboss.mx.util.JMXExceptionDecoder;
import org.jboss.system.Registry;
import org.jboss.util.UnreachableStatementException;

public class JRMPInvokerHA
extends JRMPInvoker
implements InvokerHA {
    private static final long serialVersionUID = -7657305823982668529L;
    protected HashMap beanMap = new HashMap();

    protected void startService() throws Exception {
        this.loadCustomSocketFactories();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("RMI Port='" + (this.rmiPort == 0 ? "Anonymous" : Integer.toString(this.rmiPort) + "'")));
            this.log.debug((Object)("Client SocketFactory='" + (this.clientSocketFactory == null ? "Default" : this.clientSocketFactory.toString() + "'")));
            this.log.debug((Object)("Server SocketFactory='" + (this.serverSocketFactory == null ? "Default" : this.serverSocketFactory.toString() + "'")));
            this.log.debug((Object)("Server SocketAddr='" + (this.serverAddress == null ? "Default" : this.serverAddress + "'")));
            this.log.debug((Object)("SecurityDomain='" + (this.sslDomain == null ? "None" : this.sslDomain + "'")));
        }
        this.exportCI();
        Registry.bind((Object)this.support.getServiceName(), (Object)this);
    }

    protected void stopService() throws Exception {
        this.unexportCI();
    }

    public void registerBean(ObjectName beanName, HATarget target) throws Exception {
        Integer hash = new Integer(beanName.hashCode());
        this.log.debug((Object)("registerBean: " + beanName));
        if (this.beanMap.containsKey(hash)) {
            throw new IllegalStateException("Trying to register bean with the existing hashCode");
        }
        this.beanMap.put(hash, target);
    }

    public Invoker createProxy(ObjectName beanName, LoadBalancePolicy policy, String proxyFamilyName) throws Exception {
        Integer hash = new Integer(beanName.hashCode());
        HATarget target = (HATarget)this.beanMap.get(hash);
        if (target == null) {
            throw new IllegalStateException("The bean hashCode not found");
        }
        String familyName = proxyFamilyName;
        if (familyName == null) {
            familyName = target.getAssociatedPartition().getPartitionName() + "/" + beanName;
        }
        return this.createProxy(target.getReplicants(), policy, familyName, target.getCurrentViewId());
    }

    public void unregisterBean(ObjectName beanName) throws Exception {
        Integer hash = new Integer(beanName.hashCode());
        this.beanMap.remove(hash);
    }

    public Object invoke(Invocation invocation) throws Exception {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            invocation.setTransaction(this.importTPC(((MarshalledInvocation)invocation).getTransactionPropagationContext()));
            ObjectName mbean = (ObjectName)Registry.lookup((Object)invocation.getObjectName());
            long clientViewId = (Long)invocation.getValue((Object)"CLUSTER_VIEW_ID");
            HATarget target = (HATarget)this.beanMap.get(invocation.getObjectName());
            if (target == null) {
                throw new GenericClusteringException(1, "target is not/no more registered on this node");
            }
            if (!target.invocationsAllowed()) {
                throw new GenericClusteringException(1, "invocations are currently not allowed on this target");
            }
            Object rtn = this.support.getServer().invoke(mbean, "invoke", new Object[]{invocation}, Invocation.INVOKE_SIGNATURE);
            HARMIResponse rsp = new HARMIResponse();
            if (clientViewId != target.getCurrentViewId()) {
                rsp.newReplicants = new ArrayList(target.getReplicants());
                rsp.currentViewId = target.getCurrentViewId();
            }
            rsp.response = rtn;
            MarshalledObject<HARMIResponse> marshalledObject = new MarshalledObject<HARMIResponse>(rsp);
            return marshalledObject;
        }
        catch (InstanceNotFoundException e) {
            throw new GenericClusteringException(1, e);
        }
        catch (ReflectionException e) {
            throw new GenericClusteringException(1, e);
        }
        catch (Exception e) {
            JMXExceptionDecoder.rethrow((Exception)e);
            throw new UnreachableStatementException();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    protected Invoker createProxy(ArrayList targets, LoadBalancePolicy policy, String proxyFamilyName, long viewId) {
        return new JRMPInvokerProxyHA(targets, policy, proxyFamilyName, viewId);
    }
}

