/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.tools;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.gandiva.ClassName;
import com.arjuna.ats.arjuna.objectstore.ObjectStore;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.tools.DirEntry;
import com.arjuna.ats.arjuna.tools.MonitorThread;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class OTM
extends JSplitPane {
    private static Vector _machines = new Vector();
    private static Vector _dirs = new Vector();
    private static DefaultMutableTreeNode topMachine = null;
    private static DefaultMutableTreeNode topTran = null;
    private static DefaultMutableTreeNode scanningNode = null;
    private static DefaultMutableTreeNode emptyTx = new DefaultMutableTreeNode("No transactions.");
    private static JTree tree = null;
    private static JTree transactions = null;
    private static String pollingTimeout = "MONITORING_TIMEOUT";
    private static long sleepTime = -1L;

    public OTM() {
        super(1);
        String localHost = null;
        try {
            InetAddress myAddress = InetAddress.getLocalHost();
            localHost = myAddress.getHostName();
        }
        catch (UnknownHostException e) {
            localHost = "LocalHostUnknown";
        }
        _machines.addElement(localHost);
        localHost = null;
        topMachine = new DefaultMutableTreeNode("Registered machines.");
        topTran = new DefaultMutableTreeNode("Running transactions.");
        this.createNodes(topMachine);
        tree = new JTree(topMachine);
        transactions = new JTree(topTran);
        tree.getSelectionModel().setSelectionMode(1);
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int selRow = tree.getRowForLocation(e.getX(), e.getY());
                TreePath selPath = tree.getPathForLocation(e.getX(), e.getY());
                if (selRow != -1) {
                    if (e.getClickCount() == 2 && (e.getModifiers() & 0x10) == 16) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getPathComponent(selRow);
                        if (node.isLeaf()) {
                            OTM.this.getTransactions(node);
                        } else {
                            OTM.this.removeTransactions();
                        }
                    }
                    if (e.getClickCount() == 1 && (e.getModifiers() & 4) == 4) {
                        OTM.this.removeTransactions();
                    }
                }
            }
        };
        tree.addMouseListener(ml);
        JScrollPane treeView = new JScrollPane(tree);
        JScrollPane tranView = new JScrollPane(transactions);
        this.add(treeView);
        this.add(tranView);
        Dimension minimumSize = new Dimension(100, 100);
        treeView.setMinimumSize(minimumSize);
        tranView.setMinimumSize(minimumSize);
        treeView.setPreferredSize(new Dimension(200, 200));
        this.setPreferredSize(new Dimension(500, 300));
    }

    public synchronized void updateTransactions() {
        if (scanningNode != null) {
            String root = null;
            Object storeImple = null;
            DefaultMutableTreeNode top = (DefaultMutableTreeNode)topTran.getFirstChild();
            DefaultTreeModel model = (DefaultTreeModel)transactions.getModel();
            try {
                ClassName actionStoreType = new ClassName(arjPropertyManager.getCoordinatorEnvironmentBean().getActionStore());
                ObjectStore imple = new ObjectStore(actionStoreType, root);
                InputObjectState types = new InputObjectState();
                this.startSweep();
                if (imple.allTypes(types)) {
                    String fullPathName = null;
                    boolean found = false;
                    try {
                        boolean endOfList = false;
                        DefaultMutableTreeNode currentNode = null;
                        DefaultMutableTreeNode currentRoot = top;
                        while (!endOfList) {
                            fullPathName = types.unpackString();
                            if (fullPathName.compareTo("") == 0) {
                                endOfList = true;
                            } else {
                                found = true;
                                InputObjectState uids = new InputObjectState();
                                String nodeName = this.stripName(fullPathName);
                                boolean added = false;
                                currentNode = this.findNode(fullPathName);
                                if (currentNode == null) {
                                    currentNode = new DefaultMutableTreeNode(nodeName);
                                    this.addDirectory(currentNode, fullPathName);
                                    currentRoot.add(currentNode);
                                    int[] i = new int[]{currentRoot.getChildCount() - 1};
                                    model.nodesWereInserted(currentRoot, i);
                                    added = true;
                                }
                                currentRoot = this.findRoot(top, currentNode);
                                if (added) {
                                    currentRoot.add(currentNode);
                                }
                                if (imple.allObjUids(fullPathName, uids)) {
                                    Uid theUid = new Uid(Uid.nullUid());
                                    try {
                                        boolean endOfUids = false;
                                        boolean first = true;
                                        boolean haveUids = false;
                                        while (!endOfUids) {
                                            theUid.unpack(uids);
                                            if (theUid.equals(Uid.nullUid())) {
                                                if (!haveUids && this.emptyDirectory(currentNode)) {
                                                    currentNode.removeAllChildren();
                                                    model.nodeChanged(currentNode);
                                                }
                                                endOfUids = true;
                                                continue;
                                            }
                                            haveUids = true;
                                            if (first) {
                                                currentNode.removeAllChildren();
                                                first = false;
                                            }
                                            DefaultMutableTreeNode tranID = new DefaultMutableTreeNode(theUid.stringForm());
                                            tranID.add(new DefaultMutableTreeNode(new String("status: " + OTM.statusToString(imple.currentState(theUid, fullPathName)))));
                                            currentNode.add(tranID);
                                            added = true;
                                        }
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                    if (added) {
                                        model.nodeChanged(currentNode);
                                    }
                                }
                            }
                            if (found) continue;
                            currentRoot.add(emptyTx);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                try {
                    this.endSweep();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(0);
                }
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
    }

    private boolean emptyDirectory(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode status;
        DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getFirstChild();
        if (child != null && (status = (DefaultMutableTreeNode)child.getFirstChild()) != null) {
            return status.isLeaf();
        }
        return true;
    }

    private void createNodes(DefaultMutableTreeNode topMachine) {
        int number = _machines.size();
        DefaultMutableTreeNode machine = null;
        if (number == 0) {
            topMachine.add(new DefaultMutableTreeNode("No machines registered."));
        } else {
            String machineName = null;
            for (int i = 0; i < number; ++i) {
                machineName = (String)_machines.elementAt(i);
                machine = new DefaultMutableTreeNode(machineName);
                topMachine.add(machine);
            }
        }
    }

    private void modifyTransactionView() {
        if (transactions.isCollapsed(1)) {
            transactions.expandRow(1);
        } else {
            transactions.collapseRow(1);
        }
    }

    private void removeTransactions() {
        int count;
        for (int i = count = transactions.getRowCount(); i > 0; --i) {
            transactions.collapseRow(i);
            transactions.removeSelectionRow(i);
        }
        topTran.removeAllChildren();
        transactions.repaint();
        _dirs = new Vector();
        DefaultTreeModel model = (DefaultTreeModel)transactions.getModel();
        model.reload();
        transactions.repaint();
        scanningNode = null;
    }

    private synchronized void getTransactions(DefaultMutableTreeNode machineName) {
        block12: {
            this.removeTransactions();
            scanningNode = machineName;
            String root = null;
            Object storeImple = null;
            DefaultMutableTreeNode top = new DefaultMutableTreeNode(scanningNode);
            try {
                ClassName actionStoreType = new ClassName(arjPropertyManager.getCoordinatorEnvironmentBean().getActionStore());
                ObjectStore imple = new ObjectStore(actionStoreType, root);
                InputObjectState types = new InputObjectState();
                if (!imple.allTypes(types)) break block12;
                String fullPathName = null;
                boolean found = false;
                try {
                    boolean endOfList = false;
                    DefaultMutableTreeNode currentNode = null;
                    DefaultMutableTreeNode currentRoot = top;
                    topTran.add(currentRoot);
                    while (!endOfList) {
                        fullPathName = types.unpackString();
                        if (fullPathName.compareTo("") == 0) {
                            endOfList = true;
                        } else {
                            found = true;
                            InputObjectState uids = new InputObjectState();
                            String nodeName = this.stripName(fullPathName);
                            currentNode = new DefaultMutableTreeNode(nodeName);
                            this.addDirectory(currentNode, fullPathName);
                            currentRoot = this.findRoot(top, currentNode);
                            currentRoot.add(currentNode);
                            if (imple.allObjUids(fullPathName, uids)) {
                                Uid theUid = new Uid(Uid.nullUid());
                                try {
                                    boolean endOfUids = false;
                                    while (!endOfUids) {
                                        theUid.unpack(uids);
                                        if (theUid.equals(Uid.nullUid())) {
                                            endOfUids = true;
                                            continue;
                                        }
                                        DefaultMutableTreeNode tranID = new DefaultMutableTreeNode(theUid.stringForm());
                                        tranID.add(new DefaultMutableTreeNode(new String("status: " + OTM.statusToString(imple.currentState(theUid, fullPathName)))));
                                        currentNode.add(tranID);
                                    }
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                        }
                        if (found) continue;
                        currentRoot.add(emptyTx);
                    }
                }
                catch (Exception e) {
                }
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
        DefaultTreeModel model = (DefaultTreeModel)transactions.getModel();
        model.reload();
        transactions.repaint();
    }

    private void startSweep() {
        int number = _dirs.size();
        if (number != 0) {
            for (int i = 0; i < number; ++i) {
                DirEntry dirEntry = (DirEntry)_dirs.elementAt(i);
                if (dirEntry == null) continue;
                dirEntry.present = false;
            }
        }
    }

    private void endSweep() {
        int number = _dirs.size();
        if (number != 0) {
            for (int i = 0; i < number; ++i) {
                DirEntry dirEntry = (DirEntry)_dirs.elementAt(i);
                if (dirEntry == null || dirEntry.present) continue;
                DefaultMutableTreeNode top = (DefaultMutableTreeNode)topTran.getFirstChild();
                DefaultTreeModel model = (DefaultTreeModel)transactions.getModel();
                DefaultMutableTreeNode root = this.findRoot(top, dirEntry.node);
                int index = root.getIndex(dirEntry.node);
                int[] j = new int[1];
                Object[] o = new Object[1];
                j[0] = root.getIndex(dirEntry.node);
                o[0] = dirEntry.node;
                root.remove(dirEntry.node);
                model.nodesWereRemoved(root, j, o);
                _dirs.removeElement(dirEntry);
                dirEntry.node = null;
                j = null;
                o = null;
            }
        }
    }

    private synchronized DefaultMutableTreeNode findNode(String fullPathName) {
        int number;
        if (fullPathName != null && (number = _dirs.size()) != 0) {
            for (int i = 0; i < number; ++i) {
                DirEntry dirEntry = (DirEntry)_dirs.elementAt(i);
                if (dirEntry == null || dirEntry.fullPathName.compareTo(fullPathName) != 0) continue;
                dirEntry.present = true;
                return dirEntry.node;
            }
        }
        return null;
    }

    private synchronized DefaultMutableTreeNode findRoot(DefaultMutableTreeNode top, DefaultMutableTreeNode curr) {
        DefaultMutableTreeNode root = top;
        if (curr != null) {
            int number = _dirs.size();
            String name = this.fullNodeName(curr);
            if (number != 0) {
                for (int i = 0; i < number; ++i) {
                    DirEntry dirEntry = (DirEntry)_dirs.elementAt(i);
                    if (dirEntry == null) continue;
                    DefaultMutableTreeNode node = dirEntry.node;
                    String dirName = dirEntry.fullPathName;
                    if (name.indexOf(dirName) == -1 || node == curr) continue;
                    root = node;
                }
            }
        }
        return root;
    }

    private void addDirectory(DefaultMutableTreeNode node, String path) {
        _dirs.addElement(new DirEntry(node, path));
    }

    private void removeDirectory(String path) {
        Enumeration elements = _dirs.elements();
        while (elements.hasMoreElements()) {
            DirEntry e = (DirEntry)elements.nextElement();
            if (e.fullPathName.compareTo(path) != 0) continue;
            _dirs.removeElement(e);
            return;
        }
    }

    private String fullNodeName(DefaultMutableTreeNode curr) {
        int number;
        String root = "StateManager";
        if (curr != null && (number = _dirs.size()) != 0) {
            for (int i = 0; i < number; ++i) {
                DirEntry dirEntry = (DirEntry)_dirs.elementAt(i);
                if (dirEntry == null || dirEntry.node != curr) continue;
                return dirEntry.fullPathName;
            }
            root = (String)curr.getUserObject();
        }
        return root;
    }

    private String stripName(String name) {
        String root = null;
        if (name != null) {
            int number = _dirs.size();
            if (number != 0) {
                for (int i = 0; i < number; ++i) {
                    DirEntry dirEntry = (DirEntry)_dirs.elementAt(i);
                    if (dirEntry == null) continue;
                    DefaultMutableTreeNode node = dirEntry.node;
                    String dirName = dirEntry.fullPathName;
                    int subString = name.indexOf(dirName);
                    if (subString == -1 || name.compareTo(dirName) == 0) continue;
                    root = name.substring(subString + dirName.length() + 1);
                }
            }
            if (root == null) {
                root = name;
            }
        } else {
            root = "StateManager";
        }
        return root;
    }

    private void printChildren(DefaultMutableTreeNode currentNode) {
        Enumeration<TreeNode> children;
        if (currentNode != null && (children = currentNode.children()) != null) {
            String name = (String)currentNode.getUserObject();
            System.out.println("Node: " + name);
            while (children.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)children.nextElement();
                name = (String)node.getUserObject();
                System.out.println("\tChild: " + name);
            }
        }
    }

    private static String statusToString(int status) {
        switch (status) {
            case 1: {
                return "ObjectStore.OS_COMMITTED";
            }
            case 2: {
                return "ObjectStore.OS_UNCOMMITTED";
            }
            case 4: {
                return "ObjectStore.OS_HIDDEN";
            }
            case 5: {
                return "ObjectStore.OS_COMMITTED_HIDDEN";
            }
            case 6: {
                return "ObjectStore.OS_UNCOMMITTED_HIDDEN";
            }
        }
        return "ObjectStore.OS_UNKNOWN";
    }

    public static void main(String[] args) {
        Uid u = new Uid();
        String timeout = arjPropertyManager.getPropertyManager().getProperty(pollingTimeout);
        if (timeout != null) {
            try {
                sleepTime = Long.parseLong(timeout);
            }
            catch (NumberFormatException e) {
                System.err.println("Error - specified timeout " + timeout + " is invalid!");
                System.exit(0);
            }
        }
        JFrame frame = new JFrame("OTM Transaction Monitor");
        WindowAdapter l = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        };
        frame.addWindowListener(l);
        OTM otm = new OTM();
        frame.getContentPane().add("Center", otm);
        frame.pack();
        frame.show();
        if (sleepTime != -1L) {
            MonitorThread thread = new MonitorThread(otm, sleepTime);
            thread.start();
        }
    }
}

