/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.objectstore;

import com.arjuna.ats.arjuna.ArjunaNames;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.gandiva.ClassName;
import com.arjuna.ats.arjuna.gandiva.ObjectName;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.jdbc.JDBCAccess;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.objectstore.JDBCStore;
import java.io.IOException;

public class JDBCActionStore
extends JDBCStore {
    private JDBCAccess _txJDBCAccess;
    private String _txClassName;
    private String _txTableName;
    private static String _defaultTxTableName = "JBossTSTxTable";

    @Override
    public int typeIs() {
        return 16;
    }

    @Override
    public synchronized boolean commit_state(Uid objUid, String tName) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 16L, "JDBCActionStore.commit_state(" + objUid + ", " + tName + ")");
        }
        boolean result = false;
        if (!this.storeValid()) {
            return false;
        }
        if (this.currentState(objUid, tName) == 1) {
            result = true;
        }
        return result;
    }

    @Override
    public boolean hide_state(Uid u, String tn) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 16L, "JDBCActionStore.hide_state(" + u + ", " + tn + ")");
        }
        return false;
    }

    @Override
    public boolean reveal_state(Uid u, String tn) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 16L, "JDBCActionStore.reveal_state(" + u + ", " + tn + ")");
        }
        return false;
    }

    @Override
    public InputObjectState read_committed(Uid storeUid, String tName) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 16L, "JDBCActionStore.read_committed(" + storeUid + ", " + tName + ")");
        }
        return super.read_committed(storeUid, tName);
    }

    @Override
    public InputObjectState read_uncommitted(Uid u, String tn) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 16L, "JDBCActionStore.read_uncommitted(" + u + ", " + tn + ")");
        }
        return null;
    }

    @Override
    public boolean remove_committed(Uid storeUid, String tName) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 16L, "JDBCActionStore.remove_committed(" + storeUid + ", " + tName + ")");
        }
        return super.remove_committed(storeUid, tName);
    }

    @Override
    public boolean remove_uncommitted(Uid u, String tn) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 16L, "JDBCActionStore.remove_uncommitted(" + u + ", " + tn + ")");
        }
        return false;
    }

    @Override
    public boolean write_committed(Uid storeUid, String tName, OutputObjectState state) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 16L, "JDBCActionStore.write_committed(" + storeUid + ", " + tName + ")");
        }
        return super.write_committed(storeUid, tName, state);
    }

    @Override
    public boolean write_uncommitted(Uid u, String tn, OutputObjectState s) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 16L, "JDBCActionStore.write_uncommitted(" + u + ", " + tn + ", " + s + ")");
        }
        return false;
    }

    @Override
    public ClassName className() {
        return ArjunaNames.Implementation_ObjectStore_JDBCActionStore();
    }

    public static ClassName name() {
        return ArjunaNames.Implementation_ObjectStore_JDBCActionStore();
    }

    public static JDBCStore create() {
        return new JDBCActionStore();
    }

    public static JDBCStore create(Object[] param) {
        if (param == null) {
            return null;
        }
        return new JDBCActionStore((String)param[0]);
    }

    public static JDBCStore create(ObjectName param) {
        if (param == null) {
            return null;
        }
        return new JDBCActionStore(param);
    }

    private JDBCActionStore() {
    }

    private JDBCActionStore(String tableName) {
        super(tableName);
    }

    private JDBCActionStore(ObjectName objName) {
        super(objName);
    }

    @Override
    protected String getAccessClassName() {
        if (this._txClassName == null) {
            this._txClassName = arjPropertyManager.getObjectStoreEnvironmentBean().getJdbcTxDbAccess();
        }
        return this._txClassName;
    }

    @Override
    protected void setAccessClassName(String txClassName) {
        this._txClassName = txClassName;
    }

    @Override
    protected String getDefaultTableName() {
        return _defaultTxTableName;
    }

    @Override
    protected String getAccessClassNameFromObject(ObjectName objName) throws IOException {
        return objName.getStringAttribute("com.arjuna.ats.arjuna.objectstore.jdbcTxDbAccess");
    }

    @Override
    protected String getTableNameFromObject(ObjectName objName) throws IOException {
        return objName.getStringAttribute(ArjunaNames.Implementation_ObjectStore_JDBC_tableName());
    }

    @Override
    protected JDBCAccess getJDBCAccess() {
        return this._txJDBCAccess;
    }

    @Override
    protected void setJDBCAccess(JDBCAccess jdbcAccess) {
        this._txJDBCAccess = jdbcAccess;
    }

    @Override
    protected String getTableName() {
        return this._txTableName;
    }

    @Override
    protected void setTableName(String tableName) {
        this._txTableName = tableName;
    }
}

