/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.recovery;

import com.arjuna.ats.arjuna.common.recoveryPropertyManager;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.recovery.RecoveryActivator;
import java.util.Enumeration;
import java.util.Vector;

public class RecActivatorLoader {
    private static Vector _recoveryActivators = null;

    public RecActivatorLoader() {
        this.initialise();
        RecActivatorLoader.loadRecoveryActivators();
        this.startRecoveryActivators();
    }

    public void startRecoveryActivators() {
        if (tsLogger.arjLogger.isInfoEnabled()) {
            tsLogger.arjLogger.info("--- Start RecoveryActivators ");
        }
        Enumeration activators = _recoveryActivators.elements();
        while (activators.hasMoreElements()) {
            RecoveryActivator acti = (RecoveryActivator)activators.nextElement();
            acti.startRCservice();
        }
    }

    private static void loadRecoveryActivators() {
        Vector<String> activatorNames = new Vector<String>(recoveryPropertyManager.getRecoveryEnvironmentBean().getRecoveryActivators());
        for (String activatorName : activatorNames) {
            RecActivatorLoader.loadActivator(activatorName);
        }
    }

    private static void loadActivator(String className) {
        block12: {
            if (tsLogger.arjLogger.isDebugEnabled()) {
                tsLogger.arjLogger.debug(16L, 1L, 2048L, "Loading recovery activator " + className);
            }
            if (className == null) {
                if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.RecActivatorLoader_1");
                }
                return;
            }
            try {
                Class<?> c;
                block11: {
                    c = Thread.currentThread().getContextClassLoader().loadClass(className);
                    try {
                        RecoveryActivator ra = (RecoveryActivator)c.newInstance();
                        _recoveryActivators.add(ra);
                    }
                    catch (ClassCastException e) {
                        if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.RecActivatorLooader_2", new Object[]{className});
                        }
                    }
                    catch (IllegalAccessException iae) {
                        if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.RecActivatorLoader_3", new Object[]{iae});
                        }
                    }
                    catch (InstantiationException ie) {
                        if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block11;
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.RecActivatorLoader_4", new Object[]{ie});
                    }
                }
                c = null;
            }
            catch (ClassNotFoundException cnfe) {
                if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block12;
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.RecActivatorLoader_5", new Object[]{className});
            }
        }
    }

    private final void initialise() {
        _recoveryActivators = new Vector();
    }
}

