/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.resources.arjunacore;

import com.arjuna.ats.arjuna.coordinator.OnePhaseResource;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.jta.logging.jtaLogger;
import com.arjuna.ats.jta.xa.RecoverableXAConnection;
import com.arjuna.ats.jta.xa.XidImple;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAOnePhaseResource
implements OnePhaseResource {
    private XAResource xaResource;
    private RecoverableXAConnection recoverableXAConnection;
    private Xid xid;

    public XAOnePhaseResource() {
    }

    public XAOnePhaseResource(XAResource xaResource, Xid xid, Object[] params) {
        Object param;
        this.xaResource = xaResource;
        this.xid = xid;
        if (params != null && params.length >= 0 && (param = params[0]) instanceof RecoverableXAConnection) {
            this.recoverableXAConnection = (RecoverableXAConnection)param;
        }
    }

    @Override
    public int commit() {
        try {
            this.xaResource.commit(this.xid, true);
            return 7;
        }
        catch (XAException xae) {
            if (jtaLogger.logger.isDebugEnabled()) {
                jtaLogger.logger.debug(1024L, 4L, 1L, "XAOnePhaseResource.commit(" + this.xid + ") " + xae.getMessage());
            }
            if (xae.errorCode >= 100 && xae.errorCode <= 107) {
                return 3;
            }
            return 8;
        }
    }

    @Override
    public int rollback() {
        try {
            this.xaResource.rollback(this.xid);
            return 7;
        }
        catch (XAException xae) {
            if (jtaLogger.logger.isWarnEnabled()) {
                jtaLogger.logger.warn("XAOnePhaseResource.rollback(" + this.xid + ") " + xae.getMessage());
            }
            return 8;
        }
    }

    @Override
    public void pack(OutputObjectState os) throws IOException {
        XidImple.pack(os, this.xid);
        if (this.recoverableXAConnection != null) {
            os.packInt(0);
            os.packString(this.recoverableXAConnection.getClass().getName());
            this.recoverableXAConnection.packInto(os);
        } else {
            byte[] data;
            os.packInt(1);
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(this.xaResource);
                oos.flush();
                oos.close();
                data = baos.toByteArray();
            }
            catch (IOException ioe) {
                String message = "XAOnePhaseResource.pack() " + jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.resources.arjunacore.XAOnePhaseResource.pack", new Object[]{ioe});
                if (jtaLogger.logger.isWarnEnabled()) {
                    jtaLogger.logger.warn(message);
                }
                IOException ioException = new IOException(message);
                ioException.initCause(ioe);
                throw ioException;
            }
            os.packBytes(data);
        }
    }

    @Override
    public void unpack(InputObjectState is) throws IOException {
        XidImple.unpack(is);
        int recoveryType = is.unpackInt();
        switch (recoveryType) {
            case 0: {
                Class<?> recoverableXAConnectionClass;
                String recoverableXAConnectionClassName = is.unpackString();
                ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    recoverableXAConnectionClass = contextClassLoader.loadClass(recoverableXAConnectionClassName);
                }
                catch (ClassNotFoundException cnfe) {
                    throw XAOnePhaseResource.generateUnpackError(cnfe);
                }
                try {
                    this.recoverableXAConnection = (RecoverableXAConnection)recoverableXAConnectionClass.newInstance();
                }
                catch (InstantiationException ie) {
                    throw XAOnePhaseResource.generateUnpackError(ie);
                }
                catch (IllegalAccessException iae) {
                    throw XAOnePhaseResource.generateUnpackError(iae);
                }
                this.recoverableXAConnection.unpackFrom(is);
                try {
                    this.xaResource = this.recoverableXAConnection.getResource();
                    break;
                }
                catch (SQLException sqle) {
                    throw XAOnePhaseResource.generateUnpackError(sqle);
                }
            }
            case 1: {
                byte[] data = is.unpackBytes();
                try {
                    ByteArrayInputStream bais = new ByteArrayInputStream(data);
                    ObjectInputStream ois = new ObjectInputStream(bais);
                    this.xaResource = (XAResource)ois.readObject();
                    break;
                }
                catch (ClassNotFoundException cnfe) {
                    throw XAOnePhaseResource.generateUnpackError(cnfe);
                }
                catch (IOException ioe) {
                    throw XAOnePhaseResource.generateUnpackError(ioe);
                }
                catch (ClassCastException cce) {
                    throw XAOnePhaseResource.generateUnpackError(cce);
                }
            }
            default: {
                String message = "XAOnePhaseResource.unpack() " + jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.resources.arjunacore.XAOnePhaseResource.unpackType", new Object[]{new Integer(recoveryType)});
                if (jtaLogger.logger.isWarnEnabled()) {
                    jtaLogger.logger.warn(message);
                }
                throw new IOException(message);
            }
        }
    }

    private static IOException generateUnpackError(Exception ex) {
        String message = "XAOnePhaseResource.unpack() " + jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.resources.arjunacore.XAOnePhaseResource.unpack", new Object[]{ex});
        if (jtaLogger.logger.isWarnEnabled()) {
            jtaLogger.logger.warn(message);
        }
        return new IOException(message);
    }
}

