/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.recovery.transactions;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.jts.orbspecific.coordinator.ArjunaTransactionImple;
import com.arjuna.ats.internal.jts.recovery.contact.StatusChecker;
import com.arjuna.ats.internal.jts.recovery.transactions.AssumedCompleteTransaction;
import com.arjuna.ats.internal.jts.recovery.transactions.RecoveringTransaction;
import com.arjuna.ats.internal.jts.recovery.transactions.RecoveryStatus;
import com.arjuna.ats.jts.logging.jtsLogger;
import com.arjuna.ats.jts.utils.Utility;
import java.io.IOException;
import java.util.Date;
import org.omg.CORBA.SystemException;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;

public class RecoveredTransaction
extends ArjunaTransactionImple
implements RecoveringTransaction {
    private String _typeName;
    private boolean _reportHeuristics = false;
    private int _recoveryStatus = RecoveryStatus.NEW;
    protected Uid _originalProcessUid;
    private Status _txStatus;

    public RecoveredTransaction(Uid actionUid) {
        this(actionUid, "");
    }

    public RecoveredTransaction(Uid actionUid, String changedTypeName) {
        super(actionUid);
        if (jtsLogger.loggerI18N.isDebugEnabled()) {
            jtsLogger.loggerI18N.debug(1L, 4L, 2048L, "com.arjuna.ats.internal.jts.recovery.transactions.RecoveredTransaction_1", new Object[]{this.get_uid()});
        }
        this._recoveryStatus = RecoveryStatus.ACTIVATE_FAILED;
        String effectiveTypeName = RecoveredTransaction.typeName();
        if (changedTypeName.length() < 1) {
            this._typeName = null;
        } else {
            this._typeName = changedTypeName;
            effectiveTypeName = changedTypeName;
        }
        this._originalProcessUid = new Uid(Uid.nullUid());
        try {
            if (this.store().currentState(actionUid, effectiveTypeName) != 0) {
                if (this.activate()) {
                    this._recoveryStatus = RecoveryStatus.ACTIVATED;
                } else {
                    jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.recovery.transactions.RecoveredTransaction_2", new Object[]{actionUid});
                }
            }
        }
        catch (Exception e) {
            jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.recovery.transactions.RecoveredTransaction_3", new Object[]{actionUid, e}, e);
        }
        this._txStatus = Status.StatusUnknown;
    }

    @Override
    public synchronized Status get_status() throws SystemException {
        if (this._txStatus != Status.StatusUnknown) {
            return this._txStatus;
        }
        Status theStatus = Status.StatusUnknown;
        theStatus = this._recoveryStatus == RecoveryStatus.ACTIVATE_FAILED ? Status.StatusRolledBack : super.get_status();
        return theStatus;
    }

    @Override
    public Status getOriginalStatus() {
        if (this._recoveryStatus != RecoveryStatus.ACTIVATE_FAILED) {
            try {
                return StatusChecker.get_status(this.get_uid(), this._originalProcessUid);
            }
            catch (Inactive ex) {
                return Status.StatusUnknown;
            }
        }
        return Status.StatusUnknown;
    }

    @Override
    public void addResourceRecord(Uid rcUid, Resource r) {
        Coordinator coord = null;
        AbstractRecord corbaRec = this.createOTSRecord(true, r, coord, rcUid);
        this.addRecord(corbaRec);
    }

    @Override
    public void replayPhase2() {
        this._recoveryStatus = RecoveryStatus.REPLAYING;
        Status theStatus = this.get_status();
        if (jtsLogger.loggerI18N.isDebugEnabled()) {
            jtsLogger.loggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.jts.recovery.transactions.RecoveredTransaction_5", new Object[]{this.get_uid(), Utility.stringStatus(theStatus)});
        }
        if (theStatus == Status.StatusPrepared || theStatus == Status.StatusCommitting || theStatus == Status.StatusCommitted) {
            this.phase2Commit(this._reportHeuristics);
            this._recoveryStatus = RecoveryStatus.REPLAYED;
            this._txStatus = Status.StatusCommitted;
        } else if (theStatus == Status.StatusRolledBack || theStatus == Status.StatusRollingBack || theStatus == Status.StatusMarkedRollback) {
            this.phase2Abort(this._reportHeuristics);
            this._recoveryStatus = RecoveryStatus.REPLAYED;
            this._txStatus = Status.StatusRolledBack;
        } else {
            jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.recovery.transactions.RecoveredTransaction_6", new Object[]{Utility.stringStatus(theStatus)});
            this._recoveryStatus = RecoveryStatus.REPLAY_FAILED;
        }
        if (jtsLogger.loggerI18N.isDebugEnabled()) {
            jtsLogger.loggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.jts.recovery.transactions.RecoveredTransaction_5", new Object[]{this.get_uid()});
        }
    }

    @Override
    public int getRecoveryStatus() {
        return this._recoveryStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean allCompleted() {
        RecoveredTransaction recoveredTransaction = this;
        synchronized (recoveredTransaction) {
            if (this.preparedList != null && this.preparedList.size() > 0) {
                return false;
            }
            if (this.failedList != null && this.failedList.size() > 0) {
                return false;
            }
            if (this.pendingList != null && this.pendingList.size() > 0) {
                return false;
            }
            return this.heuristicList == null || this.heuristicList.size() <= 0;
            {
            }
        }
    }

    @Override
    public String type() {
        if (this._typeName == null) {
            return super.type();
        }
        return this._typeName;
    }

    @Override
    public void removeOldStoreEntry() {
        try {
            this.store().remove_committed(this.get_uid(), super.type());
        }
        catch (ObjectStoreException ex) {
            jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.recovery.transactions.RecoveredTransaction_8", ex);
        }
    }

    @Override
    public boolean assumeComplete() {
        this._typeName = AssumedCompleteTransaction.typeName();
        return true;
    }

    @Override
    protected void packHeader(OutputObjectState os, Uid txId, Uid processUid) throws IOException {
        super.packHeader(os, txId, this._originalProcessUid);
    }

    @Override
    protected void unpackHeader(InputObjectState os, Uid txId, Uid processUid) throws IOException {
        this._originalProcessUid = new Uid(Uid.nullUid());
        super.unpackHeader(os, txId, this._originalProcessUid);
    }

    @Override
    public boolean save_state(OutputObjectState objectState, int ot) {
        boolean result = super.save_state(objectState, ot);
        if (this._typeName != null && result) {
            Date lastActiveTime = new Date();
            try {
                objectState.packLong(lastActiveTime.getTime());
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public Date getLastActiveTime() {
        return null;
    }
}

